/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModuleItem;

public abstract class PatchContentLoader {
    public static final String MODULES = "modules";
    public static final String BUNDLES = "bundles";
    public static final String MISC = "misc";

    public static PatchContentLoader create(File root) {
        File miscRoot = new File(root, MISC);
        File bundlesRoot = new File(root, BUNDLES);
        File modulesRoot = new File(root, MODULES);
        return PatchContentLoader.create(miscRoot, bundlesRoot, modulesRoot);
    }

    public static PatchContentLoader create(File miscRoot, File bundlesRoot, File modulesRoot) {
        return new BasicContentLoader(miscRoot, bundlesRoot, modulesRoot);
    }

    InputStream openContentStream(ContentItem item) throws IOException {
        File file = this.getFile(item);
        if (file == null) {
            throw new IllegalStateException();
        }
        return new FileInputStream(file);
    }

    public abstract File getFile(ContentItem var1);

    public static File getMiscPath(File miscRoot, MiscContentItem item) {
        if (miscRoot == null) {
            throw new IllegalStateException();
        }
        File file = miscRoot;
        for (String path : item.getPath()) {
            file = new File(file, path);
        }
        file = new File(file, item.getName());
        return file;
    }

    public static File getModulePath(File root, ModuleItem item) {
        return PatchContentLoader.getModulePath(root, item.getName(), item.getSlot());
    }

    static File getModulePath(File root, String name, String slot) {
        if (root == null) {
            throw new IllegalStateException();
        }
        String[] ss = name.split("\\.");
        File file = root;
        for (String s : ss) {
            file = new File(file, s);
        }
        return new File(file, slot);
    }

    static class BasicContentLoader
    extends PatchContentLoader {
        private final File miscRoot;
        private final File bundlesRoot;
        private final File modulesRoot;

        BasicContentLoader(File miscRoot, File bundlesRoot, File modulesRoot) {
            this.miscRoot = miscRoot;
            this.bundlesRoot = bundlesRoot;
            this.modulesRoot = modulesRoot;
        }

        @Override
        public File getFile(ContentItem item) {
            ContentType content = item.getContentType();
            switch (content) {
                case MODULE: {
                    return this.getModulePath((ModuleItem)item);
                }
                case MISC: {
                    return this.getMiscPath((MiscContentItem)item);
                }
                case BUNDLE: {
                    return this.getBundlePath((BundleItem)item);
                }
            }
            throw new IllegalStateException();
        }

        File getMiscPath(MiscContentItem item) {
            return BasicContentLoader.getMiscPath(this.miscRoot, item);
        }

        File getModulePath(ModuleItem item) {
            return BasicContentLoader.getModulePath(this.modulesRoot, item);
        }

        File getBundlePath(BundleItem item) {
            return BasicContentLoader.getModulePath(this.bundlesRoot, item.getName(), item.getSlot());
        }
    }
}

