/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerRegistry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class LdapConnectionAddHandler
extends AbstractAddStepHandler {
    private final LdapConnectionManagerRegistry connectionManagerRegistry = new LdapConnectionManagerRegistry();

    static LdapConnectionAddHandler newInstance() {
        return new LdapConnectionAddHandler();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName()), (String)LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName());
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName ldapConMgrName = LdapConnectionManagerService.ServiceUtil.createServiceName(name);
        ServiceBuilder sb = serviceTarget.addService(ldapConMgrName);
        Consumer lcmConsumer = sb.provides(new ServiceName[]{ldapConMgrName});
        ModelNode securityRealm = LdapConnectionResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        Supplier<SSLContext> fullSSLContextSupplier = null;
        Supplier<SSLContext> trustSSLContextSupplier = null;
        if (securityRealm.isDefined()) {
            String realmName = securityRealm.asString();
            fullSSLContextSupplier = SSLContextService.ServiceUtil.requires(sb, SecurityRealm.ServiceUtil.createServiceName(realmName), false);
            trustSSLContextSupplier = SSLContextService.ServiceUtil.requires(sb, SecurityRealm.ServiceUtil.createServiceName(realmName), true);
        }
        ExceptionSupplier credentialSourceSupplier = null;
        if (LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.resolveModelAttribute(context, model).isDefined()) {
            credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)sb);
        }
        LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService(lcmConsumer, fullSSLContextSupplier, trustSSLContextSupplier, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier, name, this.connectionManagerRegistry);
        LdapConnectionAddHandler.updateRuntime(context, model, connectionManagerService);
        sb.setInstance((Service)connectionManagerService);
        sb.install();
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    static LdapConnectionManagerService.Config updateRuntime(OperationContext context, ModelNode model, LdapConnectionManagerService connectionManagerService) throws OperationFailedException {
        Set<URI> handlesReferralsForSet;
        String initialContextFactory = LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.resolveModelAttribute(context, model).asString();
        String url = LdapConnectionResourceDefinition.URL.resolveModelAttribute(context, model).asString();
        ModelNode searchDnNode = LdapConnectionResourceDefinition.SEARCH_DN.resolveModelAttribute(context, model);
        String searchDn = searchDnNode.isDefined() ? searchDnNode.asString() : null;
        ModelNode searchCredentialNode = LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.resolveModelAttribute(context, model);
        String searchCredential = searchCredentialNode.isDefined() ? searchCredentialNode.asString() : null;
        LdapConnectionResourceDefinition.ReferralHandling referralHandling = LdapConnectionResourceDefinition.ReferralHandling.valueOf(LdapConnectionResourceDefinition.REFERRALS.resolveModelAttribute(context, model).asString());
        ModelNode handlesReferralsFor = LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.resolveModelAttribute(context, model);
        if (handlesReferralsFor.isDefined()) {
            List list = handlesReferralsFor.asList();
            handlesReferralsForSet = new HashSet(list.size());
            for (ModelNode current : list) {
                try {
                    handlesReferralsForSet.add(new URI(current.asString()));
                }
                catch (URISyntaxException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        } else {
            handlesReferralsForSet = Collections.emptySet();
        }
        boolean alwaysSendClientCert = LdapConnectionResourceDefinition.ALWAYS_SEND_CLIENT_CERT.resolveModelAttribute(context, model).asBoolean();
        return connectionManagerService.setConfiguration(initialContextFactory, url, searchDn, searchCredential, referralHandling, handlesReferralsForSet, alwaysSendClientCert);
    }
}

