/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.jboss.logging.Logger;

public class CriticalMeasure {
    private static final Logger logger = Logger.getLogger(CriticalMeasure.class);
    private volatile Exception traceEnter;
    static final AtomicReferenceFieldUpdater<CriticalMeasure, Thread> CURRENT_THREAD_UDPATER = AtomicReferenceFieldUpdater.newUpdater(CriticalMeasure.class, Thread.class, "currentThread");
    private static final Thread GHOST_THREAD = new Thread();
    private volatile Thread currentThread;
    protected volatile long timeEnter;
    private final int id;
    private final CriticalComponent component;

    public CriticalMeasure(CriticalComponent component, int id) {
        this.id = id;
        this.component = component;
        this.timeEnter = 0L;
    }

    public void enterCritical() {
        if (CURRENT_THREAD_UDPATER.compareAndSet(this, null, Thread.currentThread())) {
            this.timeEnter = System.nanoTime();
            if (logger.isTraceEnabled()) {
                this.traceEnter = new Exception("entered");
            }
        }
    }

    public void leaveCritical() {
        if (CURRENT_THREAD_UDPATER.compareAndSet(this, Thread.currentThread(), GHOST_THREAD)) {
            if (logger.isTraceEnabled()) {
                long nanoTimeout;
                CriticalAnalyzer analyzer;
                CriticalAnalyzer criticalAnalyzer = analyzer = this.component != null ? this.component.getCriticalAnalyzer() : null;
                if (analyzer != null && this.checkExpiration(nanoTimeout = analyzer.getTimeoutNanoSeconds(), false)) {
                    logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, leaving at"), new Exception("left"));
                    logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, entered at"), this.traceEnter);
                }
                this.traceEnter = null;
            }
            this.timeEnter = 0L;
            CURRENT_THREAD_UDPATER.set(this, null);
        }
    }

    protected String getComponentName() {
        if (this.component == null) {
            return "null";
        }
        return this.component.getClass().getName();
    }

    public boolean checkExpiration(long timeout, boolean reset) {
        long timeEnter = this.timeEnter;
        if (timeEnter != 0L) {
            boolean expired;
            long time = System.nanoTime();
            boolean bl = expired = time - timeEnter > timeout;
            if (expired) {
                Exception lastTraceEnter = this.traceEnter;
                if (lastTraceEnter != null) {
                    logger.warn((Object)("Component " + this.getComponentName() + " is expired on path " + this.id), lastTraceEnter);
                } else {
                    logger.warn("Component " + this.getComponentName() + " is expired on path " + this.id);
                }
                if (reset) {
                    this.timeEnter = 0L;
                }
            }
            return expired;
        }
        return false;
    }
}

