/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceDesignation;
import org.wildfly.discovery.ServiceType;

public final class ServiceURL
extends ServiceDesignation {
    private static final long serialVersionUID = -5463002934752940723L;
    private final String abstractType;
    private final String abstractTypeAuthority;
    private final URI uri;
    private final String uriSchemeAuthority;
    private final Map<String, List<AttributeValue>> attributes;
    private transient Set<String> attributeNames;
    private transient int hashCode;
    private transient String toString;
    private transient URI toServiceURI;

    ServiceURL(Builder builder, Map<String, List<AttributeValue>> attributes) {
        this.abstractType = builder.abstractType;
        this.abstractTypeAuthority = builder.abstractType == null ? null : builder.abstractTypeAuthority;
        this.uri = Assert.checkNotNullParam("uri", builder.uri);
        this.uriSchemeAuthority = builder.uriSchemeAuthority;
        this.attributes = attributes;
    }

    public boolean satisfies(FilterSpec filterSpec) {
        return filterSpec == null || filterSpec.matchesMulti(this.attributes);
    }

    public boolean implies(ServiceURL other) {
        return this.equals(other);
    }

    @Override
    public boolean implies(ServiceDesignation other) {
        return other instanceof ServiceURL && this.implies((ServiceURL)other);
    }

    public boolean equals(ServiceURL other) {
        return this.hashCode() == other.hashCode() && Objects.equals(this.abstractType, other.abstractType) && Objects.equals(this.abstractTypeAuthority, other.abstractTypeAuthority) && Objects.equals(this.uri, other.uri) && Objects.equals(this.uriSchemeAuthority, other.uriSchemeAuthority) && this.attributes.equals(other.attributes);
    }

    @Override
    public boolean equals(ServiceDesignation other) {
        return other instanceof ServiceURL && this.equals((ServiceURL)other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ServiceURL && this.equals((ServiceURL)other);
    }

    @Override
    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            if (this.abstractType != null) {
                hashCode = this.abstractType.hashCode();
            }
            hashCode *= 17;
            if (this.abstractTypeAuthority != null) {
                hashCode += this.abstractTypeAuthority.hashCode();
            }
            hashCode *= 17;
            hashCode += this.uri.hashCode();
            hashCode *= 17;
            if (this.uriSchemeAuthority != null) {
                hashCode += this.uriSchemeAuthority.hashCode();
            }
            hashCode *= 17;
            if ((hashCode += this.attributes.hashCode()) == 0) {
                hashCode = -1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder b = new StringBuilder(40);
            b.append("service:");
            if (this.abstractType != null) {
                b.append(this.abstractType);
                if (this.abstractTypeAuthority != null) {
                    b.append('.').append(this.abstractTypeAuthority);
                }
                b.append(':');
            }
            b.append(this.uri.getScheme());
            if (this.uriSchemeAuthority != null) {
                b.append('.').append(this.uriSchemeAuthority);
            }
            b.append(':').append(this.uri.getRawSchemeSpecificPart());
            for (Map.Entry<String, List<AttributeValue>> entry : this.attributes.entrySet()) {
                b.append(';').append(entry.getKey());
                Iterator<AttributeValue> iterator = entry.getValue().iterator();
                if (!iterator.hasNext()) continue;
                b.append('=');
                b.append(iterator.next());
                while (iterator.hasNext()) {
                    b.append(',');
                    b.append(iterator.next());
                }
            }
            this.toString = toString = b.toString();
        }
        return toString;
    }

    public URI toServiceURI() throws URISyntaxException {
        URI toServiceURI = this.toServiceURI;
        if (toServiceURI == null) {
            toServiceURI = this.toServiceURI = new URI(this.toString());
        }
        return toServiceURI;
    }

    public URI getLocationURI() {
        return this.uri;
    }

    public ServiceType getServiceType() {
        return this.abstractType != null ? new ServiceType(this.abstractType, this.abstractTypeAuthority, this.uri.getScheme(), this.uriSchemeAuthority) : new ServiceType(this.uri.getScheme(), this.uriSchemeAuthority, null, null);
    }

    @Override
    public String getAbstractType() {
        return this.abstractType;
    }

    @Override
    public String getAbstractTypeAuthority() {
        return this.abstractTypeAuthority;
    }

    @Override
    public String getUriScheme() {
        return this.uri.getScheme();
    }

    @Override
    public String getUriSchemeAuthority() {
        return this.uriSchemeAuthority;
    }

    public String getUserName() {
        return this.uri.getUserInfo();
    }

    public String getHostName() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public AttributeValue getFirstAttributeValue(String name) {
        Assert.checkNotNullParam("name", name);
        List list = this.attributes.getOrDefault(name, Collections.emptyList());
        return list.isEmpty() ? null : (AttributeValue)list.get(0);
    }

    public AttributeValue getFirstAttributeValue(String name, AttributeValue defaultValue) {
        Assert.checkNotNullParam("name", name);
        List list = this.attributes.getOrDefault(name, Collections.emptyList());
        return list.isEmpty() ? defaultValue : (AttributeValue)list.get(0);
    }

    public AttributeValue getLastAttributeValue(String name) {
        Assert.checkNotNullParam("name", name);
        List list = this.attributes.getOrDefault(name, Collections.emptyList());
        return list.isEmpty() ? null : (AttributeValue)list.get(list.size() - 1);
    }

    public AttributeValue getLastAttributeValue(String name, AttributeValue defaultValue) {
        Assert.checkNotNullParam("name", name);
        List list = this.attributes.getOrDefault(name, Collections.emptyList());
        return list.isEmpty() ? defaultValue : (AttributeValue)list.get(list.size() - 1);
    }

    public List<AttributeValue> getAttributeValues(String name) {
        Assert.checkNotNullParam("name", name);
        return this.attributes.getOrDefault(name, Collections.emptyList());
    }

    public Set<String> getAttributeNames() {
        Set<String> attributeNames = this.attributeNames;
        if (attributeNames == null) {
            attributeNames = this.attributeNames = Collections.unmodifiableSet(this.attributes.keySet());
        }
        return attributeNames;
    }

    Map<String, List<AttributeValue>> getAttributes() {
        return this.attributes;
    }

    public static class Builder {
        private String abstractType;
        private String abstractTypeAuthority;
        private URI uri;
        private String uriSchemeAuthority;
        private Map<String, LinkedHashSet<AttributeValue>> attributes;

        public Builder() {
            this.attributes = new HashMap<String, LinkedHashSet<AttributeValue>>();
        }

        public Builder(ServiceURL original) {
            this.abstractType = original.getAbstractType();
            this.abstractTypeAuthority = original.getAbstractTypeAuthority();
            this.uri = original.getLocationURI();
            this.uriSchemeAuthority = original.getUriSchemeAuthority();
            Map<String, List<AttributeValue>> attributes = original.getAttributes();
            HashMap<String, LinkedHashSet<AttributeValue>> map = new HashMap<String, LinkedHashSet<AttributeValue>>(attributes.size());
            for (Map.Entry<String, List<AttributeValue>> entry : attributes.entrySet()) {
                map.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
            }
            this.attributes = map;
        }

        public String getAbstractType() {
            return this.abstractType;
        }

        public Builder setAbstractType(String abstractType) {
            this.abstractType = abstractType;
            return this;
        }

        public String getAbstractTypeAuthority() {
            return this.abstractTypeAuthority;
        }

        public Builder setAbstractTypeAuthority(String abstractTypeAuthority) {
            this.abstractTypeAuthority = abstractTypeAuthority;
            return this;
        }

        public URI getUri() {
            return this.uri;
        }

        public Builder setUri(URI uri) {
            Assert.checkNotNullParam("uri", uri);
            String fragment = uri.getFragment();
            if (fragment != null && !fragment.isEmpty()) {
                throw new IllegalArgumentException("Service URI " + uri + " may not have a fragment");
            }
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("Service URI " + uri + " must be absolute");
            }
            String query = uri.getQuery();
            try {
                this.uri = uri.isOpaque() ? new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null) : new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), (String)(query != null && query.isEmpty() ? null : query), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public String getUriSchemeAuthority() {
            return this.uriSchemeAuthority;
        }

        public Builder setUriSchemeAuthority(String uriSchemeAuthority) {
            this.uriSchemeAuthority = uriSchemeAuthority;
            return this;
        }

        public Builder addAttribute(String name, AttributeValue value) {
            Assert.checkNotNullParam("name", name);
            Assert.checkNotNullParam("value", value);
            this.attributes.computeIfAbsent(name, n -> new LinkedHashSet()).add(value);
            return this;
        }

        public Builder addAttribute(String name) {
            Assert.checkNotNullParam("name", name);
            this.attributes.computeIfAbsent(name, n -> new LinkedHashSet()).add(null);
            return this;
        }

        public List<AttributeValue> removeAttribute(String name) {
            Assert.checkNotNullParam("name", name);
            LinkedHashSet<AttributeValue> removed = this.attributes.remove(name);
            if (removed == null) {
                return Collections.emptyList();
            }
            Iterator iterator = removed.iterator();
            if (!iterator.hasNext()) {
                return Collections.emptyList();
            }
            AttributeValue first = (AttributeValue)iterator.next();
            if (!iterator.hasNext()) {
                return Collections.singletonList(first);
            }
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(removed.size());
            list.add(first);
            do {
                list.add((AttributeValue)iterator.next());
            } while (iterator.hasNext());
            return list;
        }

        public boolean removeAttributeValue(String name, AttributeValue value) {
            Assert.checkNotNullParam("name", name);
            Assert.checkNotNullParam("value", value);
            LinkedHashSet<AttributeValue> set = this.attributes.get(name);
            if (set == null) {
                return false;
            }
            if (set.remove(value)) {
                if (set.isEmpty()) {
                    this.attributes.remove(name, set);
                }
                return true;
            }
            return false;
        }

        public ServiceURL create() {
            HashMap<String, List<AttributeValue>> map = new HashMap<String, List<AttributeValue>>(this.attributes.size());
            for (Map.Entry<String, LinkedHashSet<AttributeValue>> entry : this.attributes.entrySet()) {
                map.put(entry.getKey(), Builder.unmodList((Collection)entry.getValue()));
            }
            return new ServiceURL(this, map);
        }

        static <T> List<T> unmodList(Collection<T> original) {
            if (original.isEmpty()) {
                return Collections.emptyList();
            }
            if (original.size() == 1) {
                return Collections.singletonList(original.iterator().next());
            }
            return Collections.unmodifiableList(new ArrayList<T>(original));
        }
    }
}

