/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.correctors;

import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FileCorrector
implements ParameterCorrector {
    public static final FileCorrector INSTANCE = new FileCorrector();

    public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
        if (newValue.getType() == ModelType.UNDEFINED) {
            return newValue;
        }
        if (newValue.getType() != ModelType.OBJECT || currentValue.getType() != ModelType.OBJECT) {
            return newValue;
        }
        ModelNode newPath = newValue.get(PathResourceDefinition.PATH.getName());
        if (newPath.isDefined() && !AbstractPathService.isAbsoluteUnixOrWindowsPath((String)newPath.asString()) && currentValue.hasDefined(CommonAttributes.RELATIVE_TO.getName()) && !newValue.hasDefined(CommonAttributes.RELATIVE_TO.getName())) {
            newValue.get(CommonAttributes.RELATIVE_TO.getName()).set(currentValue.get(CommonAttributes.RELATIVE_TO.getName()));
        }
        return newValue;
    }
}

