/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HostExclude {
    private final String name;
    private final ApiVersion apiVersion;
    private final Release release;
    private final List<ExcludedExtension> excludedExtensions;

    public static Builder builder() {
        return new Builder();
    }

    protected HostExclude(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.apiVersion = builder.apiVersion;
        this.release = builder.release;
        this.excludedExtensions = Collections.unmodifiableList(builder.excludedExtensions);
    }

    public String getName() {
        return this.name;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public Release getRelease() {
        return this.release;
    }

    public List<ExcludedExtension> getExcludedExtensions() {
        return this.excludedExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostExclude that = (HostExclude)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "HostExclude{ name=" + this.name + ", apiVersion=" + String.valueOf(this.apiVersion) + ", release=" + String.valueOf(this.release) + ", excluded-extensions=" + this.excludedExtensions + " }";
    }

    public static class ExcludedExtension {
        private final String module;

        protected ExcludedExtension(String module) {
            this.module = Objects.requireNonNull(module);
        }

        public String getModule() {
            return this.module;
        }

        public String toString() {
            return this.getModule();
        }
    }

    public static class Release {
        private final String id;

        protected Release(String id) {
            this.id = Objects.requireNonNull(id);
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.getId();
        }
    }

    public static class ApiVersion {
        private final String majorVersion;
        private final String microVersion;
        private final String minorVersion;

        protected ApiVersion(String majorVersion, String minorVersion, String microVersion) {
            this.majorVersion = Objects.requireNonNull(majorVersion);
            this.minorVersion = Objects.requireNonNull(minorVersion);
            this.microVersion = microVersion;
        }

        public String getMajorVersion() {
            return this.majorVersion;
        }

        public String getMicroVersion() {
            return this.microVersion;
        }

        public String getMinorVersion() {
            return this.minorVersion;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getMajorVersion()).append('.').append(this.getMinorVersion());
            if (this.microVersion != null) {
                sb.append('.').append(this.getMicroVersion());
            }
            return sb.toString();
        }
    }

    public static class Builder {
        private String name;
        private ApiVersion apiVersion;
        private Release release;
        private final List<ExcludedExtension> excludedExtensions = new ArrayList<ExcludedExtension>();

        protected Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder apiVersion(String majorVersion, String minorVersion) {
            return this.apiVersion(majorVersion, minorVersion, null);
        }

        public Builder apiVersion(String majorVersion, String minorVersion, String microVersion) {
            this.apiVersion = new ApiVersion(majorVersion, minorVersion, microVersion);
            return this;
        }

        public Builder release(String id) {
            this.release = new Release(id);
            return this;
        }

        public Builder excludedExtension(String module) {
            this.excludedExtensions.add(new ExcludedExtension(module));
            return this;
        }

        public HostExclude build() {
            return new HostExclude(this);
        }
    }
}

