/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.Obligation;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicyTreeElement;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.combine.CombinerElement;
import org.jboss.security.xacml.sunxacml.combine.CombinerParameter;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.combine.RuleCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPolicy
implements PolicyTreeElement {
    private URI idAttr;
    private String version;
    private CombiningAlgorithm combiningAlg;
    private String description;
    private Target target;
    private String defaultVersion;
    private PolicyMetaData metaData;
    private List children;
    private List childElements;
    private Set obligations;
    private List parameters;

    protected AbstractPolicy() {
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, Target target) {
        this(id, version, combiningAlg, description, target, null);
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion) {
        this(id, version, combiningAlg, description, target, defaultVersion, null, null);
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, Set obligations, List parameters) {
        this.idAttr = id;
        this.combiningAlg = combiningAlg;
        this.description = description;
        this.target = target;
        this.defaultVersion = defaultVersion;
        this.version = version == null ? "1.0" : version;
        this.metaData = null;
        this.obligations = obligations == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(obligations));
        this.parameters = parameters == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(new ArrayList(parameters));
    }

    protected AbstractPolicy(Node root, String policyPrefix, String combiningName) throws ParsingException {
        Node child;
        int i;
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.idAttr = new URI(attrs.getNamedItem(policyPrefix + "Id").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute " + policyPrefix + "Id", e);
        }
        Node versionNode = attrs.getNamedItem("Version");
        this.version = versionNode != null ? versionNode.getNodeValue() : "1.0";
        try {
            URI algId = new URI(attrs.getNamedItem(combiningName).getNodeValue());
            CombiningAlgFactory factory = CombiningAlgFactory.getInstance();
            this.combiningAlg = factory.createAlgorithm(algId);
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing combining algorithm in " + policyPrefix, e);
        }
        if (policyPrefix.equals("Policy")) {
            if (!(this.combiningAlg instanceof RuleCombiningAlgorithm)) {
                throw new ParsingException("Policy must use a Rule Combining Algorithm");
            }
        } else if (!(this.combiningAlg instanceof PolicyCombiningAlgorithm)) {
            throw new ParsingException("PolicySet must use a Policy Combining Algorithm");
        }
        NodeList children = root.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!SunxacmlUtil.getNodeName(child).equals(policyPrefix + "Defaults")) continue;
            this.handleDefaults(child);
        }
        this.metaData = new PolicyMetaData(root.getNamespaceURI(), this.defaultVersion);
        this.obligations = new HashSet();
        this.parameters = new ArrayList();
        children = root.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            String cname = SunxacmlUtil.getNodeName(child);
            if (cname.equals("Description")) {
                this.description = child.getFirstChild() != null ? child.getFirstChild().getNodeValue() : "";
                continue;
            }
            if (cname.equals("Target")) {
                this.target = Target.getInstance(child, this.metaData);
                continue;
            }
            if (cname.equals("Obligations")) {
                this.parseObligations(child);
                continue;
            }
            if (!cname.equals("CombinerParameters")) continue;
            this.handleParameters(child);
        }
        this.obligations = Collections.unmodifiableSet(this.obligations);
        this.parameters = Collections.unmodifiableList(this.parameters);
    }

    private void parseObligations(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("Obligation")) continue;
            this.obligations.add(Obligation.getInstance(node));
        }
    }

    private void handleDefaults(Node root) throws ParsingException {
        this.defaultVersion = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("XPathVersion")) continue;
            this.defaultVersion = node.getFirstChild().getNodeValue();
        }
    }

    private void handleParameters(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("CombinerParameter")) continue;
            this.parameters.add(CombinerParameter.getInstance(node));
        }
    }

    @Override
    public URI getId() {
        return this.idAttr;
    }

    public String getVersion() {
        return this.version;
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.combiningAlg;
    }

    public List getCombiningParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    public List getChildElements() {
        return this.childElements;
    }

    public Set getObligations() {
        return this.obligations;
    }

    public PolicyMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public MatchResult match(EvaluationCtx context) {
        if (this.target == null) {
            throw new RuntimeException("No Target found in policy with id=" + this.idAttr);
        }
        return this.target.match(context);
    }

    protected void setChildren(List children) {
        if (children == null) {
            this.children = Collections.EMPTY_LIST;
        } else {
            ArrayList<PolicyTreeElement> list = new ArrayList<PolicyTreeElement>();
            for (CombinerElement element : children) {
                list.add(element.getElement());
            }
            this.children = Collections.unmodifiableList(list);
            this.childElements = Collections.unmodifiableList(children);
        }
    }

    @Override
    public Result evaluate(EvaluationCtx context) {
        Result result = this.combiningAlg.combine(context, this.parameters, this.childElements);
        if (this.obligations.size() == 0) {
            return result;
        }
        int effect = result.getDecision();
        if (effect == 2 || effect == 3) {
            return result;
        }
        for (Obligation obligation : this.obligations) {
            if (obligation.getFulfillOn() != effect) continue;
            result.addObligation(obligation);
        }
        return result;
    }

    protected void encodeCommonElements(OutputStream output, Indenter indenter) {
        Iterator it = this.childElements.iterator();
        while (it.hasNext()) {
            ((CombinerElement)it.next()).encode(output, indenter);
        }
        if (this.obligations.size() != 0) {
            PrintStream out = new PrintStream(output);
            String indent = indenter.makeString();
            out.println(indent + "<Obligations>");
            indenter.in();
            it = this.obligations.iterator();
            while (it.hasNext()) {
                ((Obligation)it.next()).encode(output, indenter);
            }
            out.println(indent + "</Obligations>");
            indenter.out();
        }
    }
}

