/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

class ConstraintExpressionFormula
extends ConstraintFormula {
    Expression left;
    boolean isSoft;

    ConstraintExpressionFormula(Expression expression, TypeBinding type, int relation) {
        this.left = expression;
        this.right = type;
        this.relation = relation;
    }

    ConstraintExpressionFormula(Expression expression, TypeBinding type, int relation, boolean isSoft) {
        this(expression, type, relation);
        this.isSoft = isSoft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object reduce(InferenceContext18 inferenceContext) throws InferenceFailureException {
        if (this.relation == 8) {
            return this.left.isPotentiallyCompatibleWith(this.right, inferenceContext.scope) ? TRUE : FALSE;
        }
        if (this.right.isProperType(true)) {
            return this.left.isCompatibleWith(this.right, inferenceContext.scope) || this.left.isBoxingCompatibleWith(this.right, inferenceContext.scope) ? TRUE : FALSE;
        }
        if (!this.canBePolyExpression(this.left)) {
            TypeBinding exprType = this.left.resolvedType;
            if (exprType == null || !exprType.isValidBinding()) {
                if (this.left instanceof MessageSend && ((MessageSend)this.left).actualReceiverType instanceof InferenceVariable) {
                    return null;
                }
                return FALSE;
            }
            return ConstraintTypeFormula.create(exprType, this.right, 1, this.isSoft);
        }
        if (this.left instanceof Invocation) {
            Invocation invocation = (Invocation)((Object)this.left);
            MethodBinding previousMethod = invocation.binding();
            if (previousMethod == null) {
                return null;
            }
            MethodBinding method = previousMethod;
            method = previousMethod.shallowOriginal();
            InferenceContext18.SuspendedInferenceRecord prevInvocation = inferenceContext.enterPolyInvocation(invocation, invocation.arguments());
            try {
                Expression[] arguments = invocation.arguments();
                TypeBinding[] argumentTypes = arguments == null ? Binding.NO_PARAMETERS : new TypeBinding[arguments.length];
                for (int i = 0; i < argumentTypes.length; ++i) {
                    argumentTypes[i] = arguments[i].resolvedType;
                }
                if (previousMethod instanceof ParameterizedGenericMethodBinding) {
                    InferenceContext18 innerCtx = invocation.getInferenceContext((ParameterizedGenericMethodBinding)previousMethod);
                    if (innerCtx == null) {
                        TypeBinding exprType = this.left.resolvedType;
                        if (exprType == null || !exprType.isValidBinding()) {
                            ConstraintTypeFormula constraintTypeFormula = FALSE;
                            return constraintTypeFormula;
                        }
                        ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(exprType, this.right, 1, this.isSoft);
                        return constraintTypeFormula;
                    }
                    if (innerCtx.stepCompleted < 1) {
                        ConstraintTypeFormula exprType = FALSE;
                        return exprType;
                    }
                    inferenceContext.integrateInnerInferenceB2(innerCtx);
                } else {
                    inferenceContext.inferenceKind = inferenceContext.getInferenceKind(previousMethod, argumentTypes);
                    boolean isDiamond = method.isConstructor() && this.left.isPolyExpression(method);
                    ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext, method, argumentTypes, isDiamond, inferenceContext.inferenceKind);
                }
                if (!ConstraintExpressionFormula.inferPolyInvocationType(inferenceContext, invocation, this.right, method)) {
                    ConstraintTypeFormula isDiamond = FALSE;
                    return isDiamond;
                }
                Object isDiamond = null;
                return isDiamond;
            }
            finally {
                inferenceContext.resumeSuspendedInference(prevInvocation);
            }
        }
        if (this.left instanceof ConditionalExpression) {
            ConditionalExpression conditional = (ConditionalExpression)this.left;
            return new ConstraintFormula[]{new ConstraintExpressionFormula(conditional.valueIfTrue, this.right, this.relation, this.isSoft), new ConstraintExpressionFormula(conditional.valueIfFalse, this.right, this.relation, this.isSoft)};
        }
        if (this.left instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)this.left;
            BlockScope scope = lambda.enclosingScope;
            if (!this.right.isFunctionalInterface(scope)) {
                return FALSE;
            }
            ReferenceBinding t = (ReferenceBinding)this.right;
            ParameterizedTypeBinding withWildCards = InferenceContext18.parameterizedWithWildcard(t);
            if (withWildCards != null) {
                t = ConstraintExpressionFormula.findGroundTargetType(inferenceContext, scope, lambda, withWildCards);
            }
            if (t == null) {
                return FALSE;
            }
            MethodBinding functionType = t.getSingleAbstractMethod(scope, true);
            if (functionType == null) {
                return FALSE;
            }
            TypeBinding[] parameters = functionType.parameters;
            if (parameters.length != lambda.arguments().length) {
                return FALSE;
            }
            if (lambda.argumentsTypeElided()) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].isProperType(true)) continue;
                    return FALSE;
                }
            }
            if ((lambda = lambda.resolveExpressionExpecting(t, inferenceContext.scope, inferenceContext)) == null) {
                return FALSE;
            }
            if (functionType.returnType == TypeBinding.VOID ? !lambda.isVoidCompatible() : !lambda.isValueCompatible()) {
                return FALSE;
            }
            ArrayList<ConstraintFormula> result = new ArrayList<ConstraintFormula>();
            if (!lambda.argumentsTypeElided()) {
                Argument[] arguments = lambda.arguments();
                for (int i = 0; i < parameters.length; ++i) {
                    result.add(ConstraintTypeFormula.create(parameters[i], arguments[i].type.resolvedType, 4));
                }
                if (lambda.resolvedType != null) {
                    result.add(ConstraintTypeFormula.create(lambda.resolvedType, this.right, 2));
                }
            }
            if (functionType.returnType != TypeBinding.VOID) {
                int length;
                TypeBinding r = functionType.returnType;
                Expression[] exprs = lambda.resultExpressions();
                int n = length = exprs == null ? 0 : exprs.length;
                for (int i = 0; i < length; ++i) {
                    Expression expr = exprs[i];
                    if (r.isProperType(true) && expr.resolvedType != null) {
                        TypeBinding exprType = expr.resolvedType;
                        if (expr.isConstantValueOfTypeAssignableToType(exprType, r) || exprType.isCompatibleWith(r) || expr.isBoxingCompatible(exprType, r, expr, scope)) continue;
                        return FALSE;
                    }
                    result.add(new ConstraintExpressionFormula(expr, r, 1, this.isSoft));
                }
            }
            if (result.size() == 0) {
                return TRUE;
            }
            return result.toArray(new ConstraintFormula[result.size()]);
        }
        if (this.left instanceof ReferenceExpression) {
            return this.reduceReferenceExpressionCompatibility((ReferenceExpression)this.left, inferenceContext);
        }
        return FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceBinding findGroundTargetType(InferenceContext18 inferenceContext, BlockScope scope, LambdaExpression lambda, ParameterizedTypeBinding targetTypeWithWildCards) {
        if (lambda.argumentsTypeElided()) {
            return lambda.findGroundTargetTypeForElidedLambda(scope, targetTypeWithWildCards);
        }
        InferenceContext18.SuspendedInferenceRecord previous = inferenceContext.enterLambda(lambda);
        try {
            ReferenceBinding referenceBinding = inferenceContext.inferFunctionalInterfaceParameterization(lambda, scope, targetTypeWithWildCards);
            return referenceBinding;
        }
        finally {
            inferenceContext.resumeSuspendedInference(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBePolyExpression(Expression expr) {
        ExpressionContext previousExpressionContext = expr.getExpressionContext();
        if (previousExpressionContext == ExpressionContext.VANILLA_CONTEXT) {
            this.left.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
        }
        try {
            boolean bl = expr.isPolyExpression();
            return bl;
        }
        finally {
            expr.setExpressionContext(previousExpressionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object reduceReferenceExpressionCompatibility(ReferenceExpression reference, InferenceContext18 inferenceContext) {
        ReferenceBinding rPrime;
        TypeBinding compileTypeReturn;
        TypeBinding r;
        MethodBinding potentiallyApplicable;
        TypeBinding t = this.right;
        if (t.isProperType(true)) {
            throw new IllegalStateException("Should not reach here with T being a proper type");
        }
        if (!t.isFunctionalInterface(inferenceContext.scope)) {
            return FALSE;
        }
        MethodBinding functionType = t.getSingleAbstractMethod(inferenceContext.scope, true);
        if (functionType == null) {
            return FALSE;
        }
        MethodBinding methodBinding = potentiallyApplicable = (reference = reference.resolveExpressionExpecting(t, inferenceContext.scope, inferenceContext)) != null ? reference.binding : null;
        if (potentiallyApplicable == null) {
            return FALSE;
        }
        if (reference.isExactMethodReference()) {
            ArrayList<ConstraintTypeFormula> newConstraints = new ArrayList<ConstraintTypeFormula>();
            TypeBinding[] p = functionType.parameters;
            int n = p.length;
            TypeBinding[] pPrime = potentiallyApplicable.parameters;
            int k = pPrime.length;
            int offset = 0;
            if (n == k + 1) {
                newConstraints.add(ConstraintTypeFormula.create(p[0], reference.lhs.resolvedType, 1));
                offset = 1;
            }
            for (int i = offset; i < n; ++i) {
                newConstraints.add(ConstraintTypeFormula.create(p[i], pPrime[i - offset], 1));
            }
            TypeBinding r2 = functionType.returnType;
            if (r2 != TypeBinding.VOID) {
                TypeBinding rAppl;
                TypeBinding typeBinding = rAppl = potentiallyApplicable.isConstructor() && !reference.isArrayConstructorReference() ? potentiallyApplicable.declaringClass : potentiallyApplicable.returnType;
                if (rAppl == TypeBinding.VOID) {
                    return FALSE;
                }
                TypeBinding rPrime2 = rAppl.capture(inferenceContext.scope, reference.sourceStart, reference.sourceEnd);
                newConstraints.add(ConstraintTypeFormula.create(rPrime2, r2, 1));
            }
            return newConstraints.toArray(new ConstraintFormula[newConstraints.size()]);
        }
        int n = functionType.parameters.length;
        for (int i = 0; i < n; ++i) {
            if (functionType.parameters[i].isProperType(true)) continue;
            return FALSE;
        }
        MethodBinding compileTimeDecl = potentiallyApplicable;
        if (!compileTimeDecl.isValidBinding()) {
            return FALSE;
        }
        TypeBinding typeBinding = r = functionType.isConstructor() ? functionType.declaringClass : functionType.returnType;
        if (r.id == 6) {
            return TRUE;
        }
        MethodBinding original = compileTimeDecl.shallowOriginal();
        TypeBinding typeBinding2 = compileTypeReturn = original.isConstructor() ? original.declaringClass : original.returnType;
        if (reference.typeArguments == null && (original.typeVariables() != Binding.NO_TYPE_VARIABLES && compileTypeReturn.mentionsAny(original.typeVariables(), -1) || original.isConstructor() && compileTimeDecl.declaringClass.isRawType())) {
            TypeBinding[] argumentTypes;
            if (t.isParameterizedType()) {
                MethodBinding capturedFunctionType = ((ParameterizedTypeBinding)t).getSingleAbstractMethod(inferenceContext.scope, true, reference.sourceStart, reference.sourceEnd);
                argumentTypes = capturedFunctionType.parameters;
            } else {
                argumentTypes = functionType.parameters;
            }
            InferenceContext18.SuspendedInferenceRecord prevInvocation = inferenceContext.enterPolyInvocation(reference, reference.createPseudoExpressions(argumentTypes));
            try {
                InferenceContext18 innerContex = reference.getInferenceContext((ParameterizedMethodBinding)compileTimeDecl);
                int innerInferenceKind = innerContex != null ? innerContex.inferenceKind : 1;
                ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext, original, argumentTypes, original.isConstructor(), innerInferenceKind);
                if (!ConstraintExpressionFormula.inferPolyInvocationType(inferenceContext, reference, r, original)) {
                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                if (!original.isConstructor() || reference.receiverType.isRawType() || reference.receiverType.typeArguments() == null) {
                    Object var15_29 = null;
                    return var15_29;
                }
            }
            catch (InferenceFailureException e) {
                ConstraintTypeFormula constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            finally {
                inferenceContext.resumeSuspendedInference(prevInvocation);
            }
        }
        TypeBinding typeBinding3 = rPrime = compileTimeDecl.isConstructor() ? compileTimeDecl.declaringClass : compileTimeDecl.returnType.capture(inferenceContext.scope, reference.sourceStart(), reference.sourceEnd());
        if (rPrime.id == 6) {
            return FALSE;
        }
        return ConstraintTypeFormula.create(rPrime, r, 1, this.isSoft);
    }

    static void inferInvocationApplicability(InferenceContext18 inferenceContext, MethodBinding method, TypeBinding[] arguments, boolean isDiamond, int checkType) {
        TypeBinding[] typeVariables = method.getAllTypeVariables(isDiamond);
        InferenceVariable[] inferenceVariables = inferenceContext.createInitialBoundSet((TypeVariableBinding[])typeVariables);
        int paramLength = method.parameters.length;
        TypeBinding varArgsType = null;
        if (method.isVarargs()) {
            int varArgPos = paramLength - 1;
            varArgsType = method.parameters[varArgPos];
        }
        inferenceContext.createInitialConstraintsForParameters(method.parameters, checkType == 3, varArgsType, method);
        inferenceContext.addThrowsContraints(typeVariables, inferenceVariables, method.thrownExceptions);
    }

    static boolean inferPolyInvocationType(InferenceContext18 inferenceContext, InvocationSite invocationSite, TypeBinding targetType, MethodBinding method) throws InferenceFailureException {
        TypeBinding[] typeArguments = invocationSite.genericTypeArguments();
        if (typeArguments == null) {
            ConstraintTypeFormula newConstraint;
            TypeBinding returnType;
            TypeBinding typeBinding = returnType = method.isConstructor() ? method.declaringClass : method.returnType;
            if (returnType == TypeBinding.VOID) {
                throw new InferenceFailureException("expression has no value");
            }
            if (inferenceContext.usesUncheckedConversion) {
                TypeBinding erasure = inferenceContext.environment.convertToRawType(returnType, false);
                ConstraintTypeFormula newConstraint2 = ConstraintTypeFormula.create(erasure, targetType, 1);
                return inferenceContext.reduceAndIncorporate(newConstraint2);
            }
            TypeBinding rTheta = inferenceContext.substitute(returnType);
            ParameterizedTypeBinding parameterizedType = InferenceContext18.parameterizedWithWildcard(rTheta);
            if (parameterizedType != null && parameterizedType.arguments != null) {
                TypeBinding[] arguments = parameterizedType.arguments;
                TypeBinding[] betas = inferenceContext.addTypeVariableSubstitutions(arguments);
                ParameterizedTypeBinding gbeta = inferenceContext.environment.createParameterizedType(parameterizedType.genericType(), betas, parameterizedType.enclosingType(), parameterizedType.getTypeAnnotations());
                inferenceContext.currentBounds.captures.put(gbeta, parameterizedType);
                parameterizedType = parameterizedType.capture(inferenceContext.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                arguments = parameterizedType.arguments;
                int length = arguments.length;
                for (int i = 0; i < length; ++i) {
                    if (!arguments[i].isCapture() || !arguments[i].isProperType(true)) continue;
                    CaptureBinding capture = (CaptureBinding)arguments[i];
                    inferenceContext.currentBounds.addBound(new TypeBound((InferenceVariable)betas[i], capture, 4), inferenceContext.environment);
                }
                ConstraintTypeFormula newConstraint3 = ConstraintTypeFormula.create(gbeta, targetType, 1);
                return inferenceContext.reduceAndIncorporate(newConstraint3);
            }
            if (rTheta.leafComponentType() instanceof InferenceVariable) {
                TypeBinding wrapper;
                InferenceVariable alpha = (InferenceVariable)rTheta.leafComponentType();
                TypeBinding targetLeafType = targetType.leafComponentType();
                boolean toResolve = false;
                if (inferenceContext.currentBounds.condition18_5_2_bullet_3_3_1(alpha, targetLeafType)) {
                    toResolve = true;
                } else if (inferenceContext.currentBounds.condition18_5_2_bullet_3_3_2(alpha, targetLeafType, inferenceContext)) {
                    toResolve = true;
                } else if (targetLeafType.isPrimitiveType() && (wrapper = inferenceContext.currentBounds.findWrapperTypeBound(alpha)) != null) {
                    toResolve = true;
                }
                if (toResolve) {
                    BoundSet solution = inferenceContext.solve(new InferenceVariable[]{alpha});
                    if (solution == null) {
                        return false;
                    }
                    TypeBinding u = solution.getInstantiation(alpha, null).capture(inferenceContext.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    if (rTheta.dimensions() != 0) {
                        u = inferenceContext.environment.createArrayType(u, rTheta.dimensions());
                    }
                    ConstraintTypeFormula newConstraint4 = ConstraintTypeFormula.create(u, targetType, 1);
                    return inferenceContext.reduceAndIncorporate(newConstraint4);
                }
            }
            if (!inferenceContext.reduceAndIncorporate(newConstraint = ConstraintTypeFormula.create(rTheta, targetType, 1))) {
                return false;
            }
        }
        return true;
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 context) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                LambdaExpression lambda = (LambdaExpression)this.left;
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
                if (lambda.argumentsTypeElided()) {
                    int len = sam.parameters.length;
                    for (int i = 0; i < len; ++i) {
                        sam.parameters[i].collectInferenceVariables(variables);
                    }
                }
                if (sam.returnType != TypeBinding.VOID) {
                    int length;
                    TypeBinding r = sam.returnType;
                    LambdaExpression resolved = lambda.resolveExpressionExpecting(this.right, context.scope, context);
                    Expression[] resultExpressions = resolved != null ? resolved.resultExpressions() : null;
                    int n = length = resultExpressions == null ? 0 : resultExpressions.length;
                    for (int i = 0; i < length; ++i) {
                        variables.addAll(new ConstraintExpressionFormula(resultExpressions[i], r, 1).inputVariables(context));
                    }
                }
                return variables;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope) && !this.left.isExactMethodReference()) {
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
                int len = sam.parameters.length;
                for (int i = 0; i < len; ++i) {
                    sam.parameters[i].collectInferenceVariables(variables);
                }
                return variables;
            }
        } else if (this.left instanceof ConditionalExpression && this.left.isPolyExpression()) {
            ConditionalExpression expr = (ConditionalExpression)this.left;
            HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
            variables.addAll(new ConstraintExpressionFormula(expr.valueIfTrue, this.right, 1).inputVariables(context));
            variables.addAll(new ConstraintExpressionFormula(expr.valueIfFalse, this.right, 1).inputVariables(context));
            return variables;
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, buf);
        buf.append(ConstraintExpressionFormula.relationToString(this.relation));
        this.appendTypeName(buf, this.right);
        buf.append('\u27e9');
        return buf.toString();
    }
}

