/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BooleanAttribute;
import org.jboss.security.xacml.sunxacml.attr.DateAttribute;
import org.jboss.security.xacml.sunxacml.attr.IntegerAttribute;
import org.jboss.security.xacml.sunxacml.attr.StringAttribute;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JBossXACMLUtil {
    public static Element getResponseContextElement(ResponseContext response) throws Exception {
        Node node = response.getDocumentElement();
        if (node instanceof Element) {
            return (Element)node;
        }
        Element element = null;
        if (element == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.marshall(baos);
            byte[] resp = baos.toByteArray();
            System.out.println("RESPONSE:" + new String(resp));
            ByteArrayInputStream bis = new ByteArrayInputStream(resp);
            ResponseContext newRC = RequestResponseContextFactory.createResponseContext();
            newRC.readResponse(bis);
            element = (Element)newRC.getDocumentElement();
        }
        return element;
    }

    public static AttributeValue getAttributeValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value passed is null");
        }
        if (value instanceof String) {
            return new StringAttribute((String)value);
        }
        if (value instanceof Integer) {
            return new IntegerAttribute(((Integer)value).intValue());
        }
        if (value instanceof Boolean) {
            Boolean boolVal = (Boolean)value;
            return BooleanAttribute.getInstance(boolVal);
        }
        if (value instanceof Date) {
            return new DateAttribute((Date)value);
        }
        throw new RuntimeException("unrecognized attribute value:" + value);
    }

    public static List<String> getTokenList(String commaSeparatedListOfStrings) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (commaSeparatedListOfStrings != null) {
            StringTokenizer st = new StringTokenizer(commaSeparatedListOfStrings, ",");
            while (st != null && st.hasMoreTokens()) {
                stringList.add(st.nextToken());
            }
        }
        return stringList;
    }
}

