/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class MetadataTransientCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;
    long lastUsed;

    public MetadataTransientCacheValue(Object value, Metadata metadata, long lastUsed) {
        this(value, null, metadata, lastUsed);
    }

    protected MetadataTransientCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed) {
        super(value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataTransientCacheEntry(key, this.value, this.internalMetadata, this.metadata, this.lastUsed);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", lastUsed=").append(this.lastUsed);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientCacheValue> {
        public void writeObject(ObjectOutput output, MetadataTransientCacheValue tcv) throws IOException {
            output.writeObject(tcv.value);
            output.writeObject(tcv.internalMetadata);
            output.writeObject(tcv.metadata);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)tcv.lastUsed);
        }

        public MetadataTransientCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            return new MetadataTransientCacheValue(value, internalMetadata, metadata, lastUsed);
        }

        public Integer getId() {
            return 44;
        }

        public Set<Class<? extends MetadataTransientCacheValue>> getTypeClasses() {
            return Collections.singleton(MetadataTransientCacheValue.class);
        }
    }
}

