/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.container.modules.DelegatingServerAuthModule;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.message.config.JBossServerAuthContext;
import org.jboss.security.auth.message.config.SecurityActions;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;

public class JBossServerAuthConfig
implements ServerAuthConfig {
    private String layer;
    private String contextId;
    private CallbackHandler callbackHandler = new JBossCallbackHandler();
    private List modules = new ArrayList();
    private Map contextProperties;

    public JBossServerAuthConfig(String layer, String appContext, CallbackHandler handler, Map properties) {
        this.layer = layer;
        this.contextId = appContext;
        this.callbackHandler = handler;
        this.contextProperties = properties;
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        ArrayList<ControlFlag> controlFlags = new ArrayList<ControlFlag>();
        SecurityContext securityContext = SecurityActions.getSecurityContext();
        String secDomain = null;
        if (securityContext != null) {
            secDomain = securityContext.getSecurityDomain();
        } else {
            secDomain = (String)properties.get("security-domain");
            if (secDomain == null) {
                throw PicketBoxMessages.MESSAGES.failedToObtainSecDomainFromContextOrConfig();
            }
        }
        String defaultAppDomain = "other";
        ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(secDomain);
        if (ap == null) {
            ap = SecurityConfiguration.getApplicationPolicy(defaultAppDomain);
        }
        if (ap == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainApplicationPolicy(secDomain);
        }
        BaseAuthenticationInfo bai = ap.getAuthenticationInfo();
        if (bai == null) {
            throw PicketBoxMessages.MESSAGES.failedToObtainAuthenticationInfo(secDomain);
        }
        if (bai instanceof AuthenticationInfo) {
            DelegatingServerAuthModule sam = new DelegatingServerAuthModule();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("javax.security.auth.login.LoginContext", secDomain);
            sam.initialize(null, null, this.callbackHandler, options);
            this.modules.add(sam);
        } else {
            ClassLoaderLocator locator;
            JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
            AuthModuleEntry[] amearr = jai.getAuthModuleEntry();
            ClassLoader moduleCL = null;
            List<String> jbossModuleNames = jai.getJBossModuleNames();
            if (!jbossModuleNames.isEmpty() && (locator = ClassLoaderLocatorFactory.get()) != null) {
                moduleCL = locator.get(jbossModuleNames);
            }
            for (AuthModuleEntry ame : amearr) {
                HashMap<String, Object> options;
                ServerAuthModule sam;
                if (ame.getLoginModuleStackHolderName() != null) {
                    try {
                        controlFlags.add(ame.getControlFlag());
                        sam = this.createSAM(moduleCL, ame.getAuthModuleName(), ame.getLoginModuleStackHolderName());
                        options = new HashMap();
                        options.putAll(ame.getOptions());
                        sam.initialize(null, null, this.callbackHandler, options);
                        this.modules.add(sam);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AuthException(e.getLocalizedMessage());
                    }
                }
                try {
                    controlFlags.add(ame.getControlFlag());
                    sam = this.createSAM(moduleCL, ame.getAuthModuleName());
                    options = new HashMap<String, Object>();
                    options.putAll(ame.getOptions());
                    sam.initialize(null, null, this.callbackHandler, options);
                    this.modules.add(sam);
                }
                catch (Exception e) {
                    throw new AuthException(e.getLocalizedMessage());
                }
            }
        }
        JBossServerAuthContext serverAuthContext = new JBossServerAuthContext(this.modules, null, null);
        serverAuthContext.setControlFlags(controlFlags);
        return serverAuthContext;
    }

    public String getAppContext() {
        return this.contextId;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public void refresh() {
    }

    public List getServerAuthModules() {
        return this.modules;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.contextId;
    }

    public boolean isProtected() {
        throw new UnsupportedOperationException();
    }

    private ServerAuthModule createSAM(ClassLoader moduleCL, String name) throws Exception {
        Class<?> clazz = SecurityActions.loadClass(moduleCL, name);
        Constructor<?> ctr = clazz.getConstructor(new Class[0]);
        return (ServerAuthModule)ctr.newInstance(new Object[0]);
    }

    private ServerAuthModule createSAM(ClassLoader moduleCL, String name, String lmshName) throws Exception {
        Class<?> clazz = SecurityActions.loadClass(moduleCL, name);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (ServerAuthModule)ctr.newInstance(lmshName);
    }
}

