/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.field.contenttype.parser.ContentTypeParser;
import org.apache.james.mime4j.field.contenttype.parser.ParseException;
import org.apache.james.mime4j.field.contenttype.parser.TokenMgrError;
import org.apache.james.mime4j.util.ByteSequence;

public class ContentTypeField
extends AbstractField {
    private static Log log = LogFactory.getLog(ContentTypeField.class);
    public static final String TYPE_MULTIPART_PREFIX = "multipart/";
    public static final String TYPE_MULTIPART_DIGEST = "multipart/digest";
    public static final String TYPE_TEXT_PLAIN = "text/plain";
    public static final String TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String PARAM_BOUNDARY = "boundary";
    public static final String PARAM_CHARSET = "charset";
    private boolean parsed = false;
    private String mimeType = "";
    private Map<String, String> parameters = new HashMap<String, String>();
    private ParseException parseException;
    static final FieldParser PARSER = new FieldParser(){

        @Override
        public ParsedField parse(String name, String body, ByteSequence raw) {
            return new ContentTypeField(name, body, raw);
        }
    };

    ContentTypeField(String name, String body, ByteSequence raw) {
        super(name, body, raw);
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    public String getMimeType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType;
    }

    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.parameters.get(name.toLowerCase());
    }

    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isMimeType(String mimeType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType.equalsIgnoreCase(mimeType);
    }

    public boolean isMultipart() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType.startsWith(TYPE_MULTIPART_PREFIX);
    }

    public String getBoundary() {
        return this.getParameter(PARAM_BOUNDARY);
    }

    public String getCharset() {
        return this.getParameter(PARAM_CHARSET);
    }

    public static String getMimeType(ContentTypeField child, ContentTypeField parent) {
        if (child == null || child.getMimeType().length() == 0 || child.isMultipart() && child.getBoundary() == null) {
            if (parent != null && parent.isMimeType(TYPE_MULTIPART_DIGEST)) {
                return TYPE_MESSAGE_RFC822;
            }
            return TYPE_TEXT_PLAIN;
        }
        return child.getMimeType();
    }

    public static String getCharset(ContentTypeField f) {
        String charset;
        if (f != null && (charset = f.getCharset()) != null && charset.length() > 0) {
            return charset;
        }
        return "us-ascii";
    }

    private void parse() {
        String body = this.getBody();
        ContentTypeParser parser = new ContentTypeParser(new StringReader(body));
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = e;
        }
        catch (TokenMgrError e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = new ParseException(e.getMessage());
        }
        String type = parser.getType();
        String subType = parser.getSubType();
        if (type != null && subType != null) {
            this.mimeType = (type + "/" + subType).toLowerCase();
            List<String> paramNames = parser.getParamNames();
            List<String> paramValues = parser.getParamValues();
            if (paramNames != null && paramValues != null) {
                int len = Math.min(paramNames.size(), paramValues.size());
                for (int i = 0; i < len; ++i) {
                    String paramName = paramNames.get(i).toLowerCase();
                    String paramValue = paramValues.get(i);
                    this.parameters.put(paramName, paramValue);
                }
            }
        }
        this.parsed = true;
    }
}

