/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.vfs.VirtualFile;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.common.configuration.AbstractCommonConfigResolver;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

public class ConfigResolver
extends AbstractCommonConfigResolver {
    private final ClassInfo epClassInfo;
    private final String className;
    private final String annotationConfigName;
    private final String annotationConfigFile;
    private final String descriptorConfigName;
    private final String descriptorConfigFile;
    private final VirtualFile root;
    private final boolean isWar;

    public ConfigResolver(ClassInfo epClassInfo, JBossWebservicesMetaData jwmd, JBossWebMetaData jbwebmd, VirtualFile root, boolean isWar) {
        this.epClassInfo = epClassInfo;
        this.className = epClassInfo.name().toString();
        List annotations = (List)epClassInfo.annotations().get(DotName.createSimple((String)EndpointConfig.class.getName()));
        if (annotations != null && !annotations.isEmpty()) {
            AnnotationInstance ann = (AnnotationInstance)annotations.get(0);
            AnnotationValue av = ann.value("configName");
            this.annotationConfigName = av != null ? av.asString() : null;
            av = ann.value("configFile");
            this.annotationConfigFile = av != null ? av.asString() : null;
        } else {
            this.annotationConfigName = null;
            this.annotationConfigFile = null;
        }
        String f = null;
        String n = null;
        if (jbwebmd != null && jbwebmd.getContextParams() != null) {
            for (ParamValueMetaData pvmd : jbwebmd.getContextParams()) {
                if ("jbossws-config-name".equals(pvmd.getParamName())) {
                    n = pvmd.getParamValue();
                }
                if (!"jbossws-config-file".equals(pvmd.getParamName())) continue;
                f = pvmd.getParamValue();
            }
        }
        String string = f != null ? f : (this.descriptorConfigFile = jwmd != null ? jwmd.getConfigFile() : null);
        this.descriptorConfigName = n != null ? n : (jwmd != null ? jwmd.getConfigName() : null);
        this.root = root;
        this.isWar = isWar;
    }

    protected String getEndpointClassName() {
        return this.className;
    }

    protected <T extends Annotation> boolean isEndpointClassAnnotated(Class<T> annotation) {
        return this.epClassInfo.annotations().containsKey(DotName.createSimple((String)annotation.getName()));
    }

    protected String getEndpointConfigNameFromAnnotation() {
        return this.annotationConfigName;
    }

    protected String getEndpointConfigFileFromAnnotation() {
        return this.annotationConfigFile;
    }

    protected String getEndpointConfigNameOverride() {
        return this.descriptorConfigName;
    }

    protected String getEndpointConfigFileOverride() {
        return this.descriptorConfigFile;
    }

    protected URL getConfigFile(String configFileName) throws IOException {
        return this.root.getChild(configFileName).asFileURL();
    }

    protected URL getDefaultConfigFile(String defaultConfigFileName) {
        URL url = null;
        if (this.isWar) {
            url = this.asFileURL(this.root.getChild("/WEB-INF/classes/" + defaultConfigFileName));
        }
        if (url == null) {
            url = this.asFileURL(this.root.getChild("/" + defaultConfigFileName));
        }
        return url;
    }

    private URL asFileURL(VirtualFile vf) {
        URL url = null;
        if (vf != null && vf.exists()) {
            try {
                url = vf.asFileURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }
}

