/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.SimpleAddressManager;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class WildcardAddressManager
extends SimpleAddressManager {
    private final Map<SimpleString, Address> addresses = new ConcurrentHashMap<SimpleString, Address>();
    private final Map<SimpleString, Address> wildCardAddresses = new ConcurrentHashMap<SimpleString, Address>();

    public WildcardAddressManager(BindingsFactory bindingsFactory, WildcardConfiguration wildcardConfiguration, StorageManager storageManager, MetricsManager metricsManager) {
        super(bindingsFactory, wildcardConfiguration, storageManager, metricsManager);
    }

    public WildcardAddressManager(BindingsFactory bindingsFactory, StorageManager storageManager, MetricsManager metricsManager) {
        super(bindingsFactory, storageManager, metricsManager);
    }

    @Override
    public Bindings getBindingsForRoutingAddress(SimpleString address) throws Exception {
        Bindings bindings = super.getBindingsForRoutingAddress(address);
        if (bindings == null && !this.wildCardAddresses.isEmpty()) {
            Address add = this.addAndUpdateAddressMap(address);
            if (!add.containsWildCard()) {
                for (Address destAdd : add.getLinkedAddresses()) {
                    Bindings b = super.getBindingsForRoutingAddress(destAdd.getAddress());
                    if (b == null) continue;
                    super.addMappingsInternal(address, b.getBindings());
                    if (bindings == null) {
                        bindings = super.getBindingsForRoutingAddress(address);
                    }
                    bindings.setMessageLoadBalancingType(b.getMessageLoadBalancingType());
                }
            }
            if (bindings == null) {
                bindings = super.getBindingsForRoutingAddress(address);
            }
        }
        return bindings;
    }

    @Override
    public boolean addBinding(Binding binding) throws Exception {
        boolean exists;
        block4: {
            exists = super.addBinding(binding);
            if (exists) break block4;
            Address add = this.addAndUpdateAddressMap(binding.getAddress());
            if (add.containsWildCard()) {
                for (Address destAdd : add.getLinkedAddresses()) {
                    super.addMappingInternal(destAdd.getAddress(), binding);
                }
            } else {
                for (Address destAdd : add.getLinkedAddresses()) {
                    Bindings bindings = super.getBindingsForRoutingAddress(destAdd.getAddress());
                    if (bindings == null) continue;
                    super.addMappingsInternal(binding.getAddress(), bindings.getBindings());
                }
            }
        }
        return !exists;
    }

    @Override
    public void updateMessageLoadBalancingTypeForAddress(SimpleString address, MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        Address add = this.addAndUpdateAddressMap(address);
        Bindings bindingsForRoutingAddress = super.getBindingsForRoutingAddress(address);
        if (bindingsForRoutingAddress != null) {
            bindingsForRoutingAddress.setMessageLoadBalancingType(messageLoadBalancingType);
        }
        if (add.containsWildCard()) {
            for (Address destAdd : add.getLinkedAddresses()) {
                this.getBindingsForRoutingAddress(destAdd.getAddress()).setMessageLoadBalancingType(messageLoadBalancingType);
            }
        } else {
            for (Address destAdd : add.getLinkedAddresses()) {
                super.getBindingsForRoutingAddress(destAdd.getAddress()).setMessageLoadBalancingType(messageLoadBalancingType);
            }
        }
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName, Transaction tx) throws Exception {
        Binding binding = super.removeBinding(uniqueName, tx);
        if (binding != null) {
            Address address;
            SimpleString bindingAddress = binding.getAddress();
            boolean containsWildcard = bindingAddress.containsEitherOf(this.wildcardConfiguration.getAnyWords(), this.wildcardConfiguration.getSingleWord());
            Address address2 = address = containsWildcard ? this.wildCardAddresses.get(bindingAddress) : this.addresses.get(bindingAddress);
            if (address == null) {
                address = new AddressImpl(bindingAddress, this.wildcardConfiguration);
            } else if (containsWildcard) {
                for (Address linkedAddress : address.getLinkedAddresses()) {
                    super.removeBindingInternal(linkedAddress.getAddress(), uniqueName);
                }
            }
            this.removeAndUpdateAddressMap(address);
        }
        return binding;
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        AddressInfo removed = super.removeAddressInfo(address);
        if (removed != null) {
            this.mappings.remove(address);
            this.removeAndUpdateAddressMap(new AddressImpl(removed.getName(), this.wildcardConfiguration));
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.addresses.clear();
        this.wildCardAddresses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address addAndUpdateAddressMap(SimpleString address) {
        boolean containsWildCard = address.containsEitherOf(this.wildcardConfiguration.getAnyWords(), this.wildcardConfiguration.getSingleWord());
        Map<SimpleString, Address> addressMap = containsWildCard ? this.wildCardAddresses : this.addresses;
        Address actualAddress = addressMap.get(address);
        if (actualAddress == null) {
            WildcardAddressManager wildcardAddressManager = this;
            synchronized (wildcardAddressManager) {
                actualAddress = addressMap.get(address);
                if (actualAddress == null) {
                    actualAddress = new AddressImpl(address, this.wildcardConfiguration);
                    assert (actualAddress.containsWildCard() == containsWildCard);
                    if (containsWildCard) {
                        for (Address destAdd : this.addresses.values()) {
                            if (!destAdd.matches(actualAddress)) continue;
                            destAdd.addLinkedAddress(actualAddress);
                            actualAddress.addLinkedAddress(destAdd);
                        }
                    } else {
                        for (Address destAdd : this.wildCardAddresses.values()) {
                            if (!actualAddress.matches(destAdd)) continue;
                            destAdd.addLinkedAddress(actualAddress);
                            actualAddress.addLinkedAddress(destAdd);
                        }
                    }
                    addressMap.put(address, actualAddress);
                }
            }
        }
        return actualAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndUpdateAddressMap(Address address) throws Exception {
        Bindings bindings = super.getBindingsForRoutingAddress(address.getAddress());
        if (bindings == null || bindings.getBindings().isEmpty()) {
            WildcardAddressManager wildcardAddressManager = this;
            synchronized (wildcardAddressManager) {
                for (Address address1 : address.getLinkedAddresses()) {
                    address1.removeLinkedAddress(address);
                    Bindings linkedBindings = super.getBindingsForRoutingAddress(address1.getAddress());
                    if (linkedBindings != null && linkedBindings.getBindings().size() != 0) continue;
                    this.removeAddress(address1);
                }
                this.removeAddress(address);
            }
        }
    }

    private void removeAddress(Address add) {
        if (add.containsWildCard()) {
            this.wildCardAddresses.remove(add.getAddress());
        } else {
            this.addresses.remove(add.getAddress());
        }
    }
}

