/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class EnumMarshaller<E extends Enum<E>>
implements org.infinispan.protostream.EnumMarshaller<E>,
ProtoStreamMarshaller<E> {
    private static final int DEFAULT_ORDINAL = 0;
    private static final int ORDINAL_INDEX = 1;
    private final Class<E> enumClass;
    private final E[] values;

    public EnumMarshaller(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    @Override
    public Class<? extends E> getJavaClass() {
        return this.enumClass;
    }

    public E decode(int ordinal) {
        return this.values[ordinal];
    }

    public int encode(E value) {
        return ((Enum)value).ordinal();
    }

    @Override
    public E readFrom(ProtoStreamReader reader) throws IOException {
        E result = this.values[0];
        boolean reading = true;
        block3: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    result = reader.readEnum(this.enumClass);
                    continue block3;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, E value) throws IOException {
        if (((Enum)value).ordinal() != 0) {
            writer.writeEnum(1, value);
        }
    }
}

