/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class StatefulComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new StatefulComponentInstanceInterceptor());

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        SessionID sessionId = (SessionID)context.getPrivateData(SessionID.class);
        if (sessionId == null) {
            throw EjbLogger.ROOT_LOGGER.statefulSessionIdIsNull(component.getComponentName());
        }
        EjbLogger.ROOT_LOGGER.debugf("Looking for stateful component instance with session id: %s", sessionId);
        StatefulSessionComponentInstance instance = component.getCache().get(sessionId);
        if (instance == null) {
            throw EjbLogger.ROOT_LOGGER.couldNotFindEjb(sessionId.toString());
        }
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            return context.proceed();
        }
        catch (Exception ex) {
            if (component.shouldDiscard(ex, context.getMethod())) {
                EjbLogger.ROOT_LOGGER.tracef(ex, "Removing bean %s because of exception", sessionId);
                instance.discard();
            }
            throw ex;
        }
        catch (Error e) {
            EjbLogger.ROOT_LOGGER.tracef(e, "Removing bean %s because of error", sessionId);
            instance.discard();
            throw e;
        }
        catch (Throwable t) {
            EjbLogger.ROOT_LOGGER.tracef(t, "Removing bean %s because of Throwable", sessionId);
            instance.discard();
            throw new RuntimeException(t);
        }
    }

    static StatefulSessionComponentInstance getComponentInstance(InterceptorContext context) {
        return (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
    }
}

