/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.nio.file.Path;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContextImpl;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.Servers;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.JavaConsole;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SystemEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.report.SummaryReportWriter;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.TaskExecutionImpl;

public class ServerMigration {
    private static final String SOURCE = "SOURCE";
    private static final String TARGET = "TARGET";
    private Path from;
    private Path to;
    private ConsoleWrapper console;
    private boolean interactive = true;
    private MigrationEnvironment userEnvironment;

    public ServerMigration from(Path path) {
        this.from = path;
        return this;
    }

    public ServerMigration to(Path path) {
        this.to = path;
        return this;
    }

    public ServerMigration console(ConsoleWrapper console) {
        this.console = console;
        return this;
    }

    public ServerMigration interactive(boolean interactive) {
        this.interactive = interactive;
        return this;
    }

    public ServerMigration userEnvironment(MigrationEnvironment userEnvironment) {
        this.userEnvironment = userEnvironment;
        return this;
    }

    public MigrationData run() throws IllegalArgumentException, IllegalStateException, ServerMigrationFailureException {
        if (this.from == null) {
            throw ServerMigrationLogger.ROOT_LOGGER.serverBaseDirNotSet(SOURCE);
        }
        if (this.to == null) {
            throw ServerMigrationLogger.ROOT_LOGGER.serverBaseDirNotSet(TARGET);
        }
        if (this.userEnvironment == null) {
            this.userEnvironment = new MigrationEnvironment();
        }
        MigrationEnvironment migrationEnvironment = new MigrationEnvironment();
        migrationEnvironment.setProperties(this.userEnvironment);
        migrationEnvironment.setProperties(SystemEnvironment.INSTANCE);
        ConsoleWrapper console = this.console != null ? this.console : new JavaConsole();
        console.printf("%n", new Object[0]);
        console.printf("----------------------------------------------------------%n", new Object[0]);
        console.printf("----  JBoss Server Migration Tool  -----------------------%n", new Object[0]);
        console.printf("----------------------------------------------------------%n", new Object[0]);
        console.printf("%n", new Object[0]);
        console.printf("Retrieving servers...%n", new Object[0]);
        final Server sourceServer = this.getServer(SOURCE, this.from, migrationEnvironment);
        final Server targetServer = this.getServer(TARGET, this.to, migrationEnvironment);
        console.printf("%n", new Object[0]);
        console.printf("----------------------------------------------------------%n", new Object[0]);
        console.printf("----------------------------------------------------------%n", new Object[0]);
        console.printf("%n", new Object[0]);
        ServerMigrationContextImpl serverMigrationContext = new ServerMigrationContextImpl(console, this.interactive, migrationEnvironment);
        final ServerMigrationTaskName serverMigrationTaskName = new ServerMigrationTaskName.Builder("server").build();
        ServerMigrationTask serverMigrationTask = new ServerMigrationTask(){

            @Override
            public ServerMigrationTaskName getName() {
                return serverMigrationTaskName;
            }

            @Override
            public ServerMigrationTaskResult run(TaskContext context) {
                context.getConsoleWrapper().printf("Server migration starting...%n", new Object[0]);
                ServerMigrationTaskResult result = targetServer.migrate(sourceServer, context);
                context.getConsoleWrapper().printf("%nServer migration done.%n%n", new Object[0]);
                return result;
            }
        };
        TaskExecutionImpl taskExecutionImpl = new TaskExecutionImpl(serverMigrationTask, serverMigrationContext);
        try {
            taskExecutionImpl.run();
        }
        catch (Throwable t) {
            ServerMigrationLogger.ROOT_LOGGER.error("Migration failed", t);
        }
        MigrationData migrationData = new MigrationData(sourceServer, targetServer, taskExecutionImpl, migrationEnvironment);
        ServerMigrationLogger.ROOT_LOGGER.infof(SummaryReportWriter.INSTANCE.toString(migrationData), new Object[0]);
        return migrationData;
    }

    protected Server getServer(String name, Path baseDir, MigrationEnvironment migrationEnvironment) throws IllegalArgumentException {
        baseDir = baseDir.normalize();
        ServerMigrationLogger.ROOT_LOGGER.debugf("Processing %s server's base dir %s", name, baseDir);
        Server server = Servers.getServer(name.toLowerCase(), baseDir, migrationEnvironment);
        if (server == null) {
            throw ServerMigrationLogger.ROOT_LOGGER.failedToRetrieveServerFromBaseDir(name, baseDir.toString());
        }
        ServerMigrationLogger.ROOT_LOGGER.serverProductInfo(name, server.getProductInfo());
        return server;
    }
}

