/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;

public class CompositeTaskRunnable
implements TaskRunnable {
    private final TaskRunnable[] runnables;

    protected <T extends BaseBuilder<T>> CompositeTaskRunnable(BaseBuilder<T> builder) {
        this.runnables = (TaskRunnable[])((BaseBuilder)builder).runnables.stream().toArray(TaskRunnable[]::new);
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().skipped();
        block4: for (TaskRunnable runnable : this.runnables) {
            switch (runnable.run(context).getStatus()) {
                case FAIL: {
                    throw new ServerMigrationFailureException("the execution of a child runnable returned fail result");
                }
                case SUCCESS: {
                    resultBuilder.success();
                    continue block4;
                }
            }
        }
        return resultBuilder.build();
    }

    public static class Builder
    extends BaseBuilder<Builder> {
        @Override
        protected Builder getThis() {
            return this;
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        private final List<TaskRunnable> runnables = new ArrayList<TaskRunnable>();

        protected BaseBuilder() {
        }

        protected abstract T getThis();

        public T runnable(TaskRunnable runnable) {
            this.runnables.add(runnable);
            return this.getThis();
        }

        public T runnables(TaskRunnable ... runnables) {
            for (TaskRunnable runnable : runnables) {
                this.runnable(runnable);
            }
            return this.getThis();
        }

        public CompositeTaskRunnable build() {
            return new CompositeTaskRunnable(this);
        }
    }
}

