/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import java.util.Objects;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.AfterTaskRun;
import org.jboss.migration.core.task.component.BeforeTaskRun;
import org.jboss.migration.core.task.component.SimpleComponentTaskBuilder;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public class SimpleComponentTask
implements ServerMigrationTask {
    private final ServerMigrationTaskName name;
    private final TaskRunnable taskRunnable;

    protected SimpleComponentTask(ServerMigrationTaskName name, TaskRunnable taskRunnable) {
        this.name = Objects.requireNonNull(name);
        this.taskRunnable = Objects.requireNonNull(taskRunnable);
    }

    @Override
    public ServerMigrationTaskName getName() {
        return this.name;
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        return this.taskRunnable.run(context);
    }

    public static class Builder
    extends BaseBuilder<Builder> {
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        protected ServerMigrationTask buildTask(ServerMigrationTaskName name, TaskRunnable runnable) {
            return new SimpleComponentTask(name, runnable);
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder<T>>
    implements SimpleComponentTaskBuilder<T> {
        private ServerMigrationTaskName name;
        private TaskSkipPolicy skipPolicy;
        private BeforeTaskRun beforeRun;
        private TaskRunnable runnable;
        private AfterTaskRun afterRun;

        protected BaseBuilder() {
        }

        protected ServerMigrationTaskName getName() {
            return this.name;
        }

        @Override
        public T name(ServerMigrationTaskName name) {
            this.name = name;
            return this.getThis();
        }

        protected TaskSkipPolicy getSkipPolicy() {
            return this.skipPolicy;
        }

        @Override
        public T skipPolicy(TaskSkipPolicy skipPolicy) {
            this.skipPolicy = skipPolicy;
            return this.getThis();
        }

        protected BeforeTaskRun getBeforeRun() {
            return this.beforeRun;
        }

        @Override
        public T beforeRun(BeforeTaskRun beforeRun) {
            this.beforeRun = beforeRun;
            return this.getThis();
        }

        protected TaskRunnable getRunnable() {
            return this.runnable;
        }

        @Override
        public T runnable(TaskRunnable runnable) {
            this.runnable = runnable;
            return this.getThis();
        }

        protected AfterTaskRun getAfterRun() {
            return this.afterRun;
        }

        @Override
        public T afterRun(AfterTaskRun afterRun) {
            this.afterRun = afterRun;
            return this.getThis();
        }

        protected TaskRunnable buildRunnable() {
            Objects.requireNonNull(this.runnable);
            return context -> {
                if (this.skipPolicy != null && this.skipPolicy.isSkipped(context)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (this.beforeRun != null) {
                    this.beforeRun.beforeRun(context);
                }
                ServerMigrationTaskResult result = this.runnable.run(context);
                if (this.afterRun != null) {
                    this.afterRun.afterRun(context);
                }
                return result;
            };
        }

        @Override
        public ServerMigrationTask build() {
            return this.buildTask(Objects.requireNonNull(this.name), this.buildRunnable());
        }

        protected abstract T getThis();

        protected abstract ServerMigrationTask buildTask(ServerMigrationTaskName var1, TaskRunnable var2);
    }
}

