/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigProvider;
import org.jboss.resteasy.util.BasicAuthHelper;

public class ClientConfigProviderFilter
implements ClientRequestFilter {
    private final ClientConfigProvider clientConfigProvider;

    public ClientConfigProviderFilter(ClientConfigProvider clientConfigProvider) {
        this.clientConfigProvider = clientConfigProvider;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getHeaderString("Authorization") == null) {
            URI uri = requestContext.getUri();
            if (uri == null) {
                LogMessages.LOGGER.warn(Messages.MESSAGES.unableToLoadClientConfigProviderConfiguration());
                return;
            }
            String token = this.clientConfigProvider.getBearerToken(uri);
            if (token != null) {
                requestContext.getHeaders().putSingle((Object)"Authorization", (Object)("Bearer " + token));
            } else {
                String username = this.clientConfigProvider.getUsername(uri);
                String password = this.clientConfigProvider.getPassword(uri);
                if (username != null && password != null) {
                    requestContext.getHeaders().putSingle((Object)"Authorization", (Object)BasicAuthHelper.createHeader((String)username, (String)password));
                }
            }
        }
    }
}

