/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.util.HashSet;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="abstract-auth-disable", description="")
public abstract class AbstractDisableAuthenticationCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="no-reload", hasValue=false)
    boolean noReload;
    private final AuthFactorySpec factorySpec;

    public AbstractDisableAuthenticationCommand(AuthFactorySpec factorySpec) {
        this.factorySpec = factorySpec;
    }

    public AuthFactorySpec getFactorySpec() {
        return this.factorySpec;
    }

    public abstract String getEnabledFactory(CommandContext var1) throws Exception;

    protected abstract ModelNode disableFactory(CommandContext var1) throws Exception;

    protected abstract String getSecuredEndpoint(CommandContext var1);

    protected abstract String getMechanism();

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ModelNode request;
        CommandContext ctx = commandInvocation.getCommandContext();
        try {
            request = this.buildSecurityRequest(ctx);
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER, this.noReload);
        commandInvocation.getCommandContext().printLine("Command success.");
        if (this.getMechanism() == null) {
            commandInvocation.getCommandContext().printLine(this.factorySpec.getName() + " authentication disabled for " + this.getSecuredEndpoint(commandInvocation.getCommandContext()));
        } else {
            commandInvocation.getCommandContext().printLine("Mechanism removed from " + this.factorySpec.getName() + " for " + this.getSecuredEndpoint(commandInvocation.getCommandContext()));
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        try {
            return this.buildSecurityRequest(context);
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage());
        }
    }

    public ModelNode buildSecurityRequest(CommandContext context) throws Exception {
        String authFactory = this.validateOptions(context);
        ModelNode mn = ElytronUtil.getAuthFactoryResource(authFactory, this.factorySpec, context);
        if (mn == null) {
            throw new CommandException("Invalid factory " + authFactory);
        }
        if (this.getMechanism() == null) {
            return this.disableFactory(context);
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getMechanism());
        return ElytronUtil.removeMechanisms(context, mn, authFactory, this.factorySpec, set);
    }

    private String validateOptions(CommandContext ctx) throws Exception {
        String factory = this.getEnabledFactory(ctx);
        if (factory == null) {
            throw new CommandException(this.factorySpec.getName() + " authentication is not enabled.");
        }
        return factory;
    }
}

