/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitorNode;
import org.jboss.as.pojo.descriptor.CallbackConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ConstructorConfig;
import org.jboss.as.pojo.descriptor.DependsConfig;
import org.jboss.as.pojo.descriptor.InstallConfig;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.ModeConfig;
import org.jboss.as.pojo.descriptor.ModuleConfig;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.msc.service.ServiceName;

public class BeanMetaDataConfig
extends AbstractConfigVisitorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ServiceName JBOSS_POJO = ServiceName.JBOSS.append(new String[]{"pojo"});
    private String name;
    private String beanClass;
    private Set<String> aliases;
    private ModeConfig mode;
    private ModuleConfig module;
    private ConstructorConfig constructor;
    private Set<PropertyConfig> properties;
    private LifecycleConfig create;
    private LifecycleConfig start;
    private LifecycleConfig stop;
    private LifecycleConfig destroy;
    private List<InstallConfig> installs;
    private List<InstallConfig> uninstalls;
    private List<CallbackConfig> incallbacks;
    private List<CallbackConfig> uncallbacks;
    private Set<DependsConfig> depends;

    public static ServiceName toBeanName(String name, BeanState state) {
        if (state == null) {
            state = BeanState.INSTALLED;
        }
        return JBOSS_POJO.append(new String[]{name}).append(new String[]{state.name()});
    }

    public static ServiceName toInstancesName(Class<?> clazz, BeanState state) {
        ClassLoader classLoader = clazz.getClassLoader();
        String clName = classLoader != null ? classLoader.toString() : "SystemClassLoader";
        if (state == null) {
            state = BeanState.INSTALLED;
        }
        return JBOSS_POJO.append(new String[]{clName, clazz.getName(), state.name()});
    }

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.module == null) {
            this.module = new ModuleConfig();
        }
        super.visit(visitor);
    }

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        BeanState state = visitor.getState();
        if (state == BeanState.NOT_INSTALLED) {
            nodes.add(this.module);
        }
        if (this.constructor != null && state == BeanState.DESCRIBED) {
            nodes.add(this.constructor);
        }
        if (this.properties != null && state == BeanState.INSTANTIATED) {
            nodes.addAll(this.properties);
        }
        if (this.create != null && state == BeanState.CONFIGURED) {
            nodes.add(this.create);
        }
        if (this.destroy != null && state == BeanState.CONFIGURED) {
            nodes.add(this.destroy);
        }
        if (this.start != null && state == BeanState.CREATE) {
            nodes.add(this.start);
        }
        if (this.stop != null && state == BeanState.CREATE) {
            nodes.add(this.stop);
        }
        if (this.installs != null) {
            nodes.addAll(this.installs);
        }
        if (this.uninstalls != null) {
            nodes.addAll(this.uninstalls);
        }
        if (this.incallbacks != null) {
            nodes.addAll(this.incallbacks);
        }
        if (this.uncallbacks != null) {
            nodes.addAll(this.uncallbacks);
        }
        if (this.depends != null) {
            nodes.addAll(this.depends);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(String beanClass) {
        this.beanClass = beanClass;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public ModeConfig getMode() {
        if (this.mode == null) {
            this.mode = ModeConfig.PASSIVE;
        }
        return this.mode;
    }

    public void setMode(ModeConfig mode) {
        this.mode = mode;
    }

    public ModuleConfig getModule() {
        return this.module;
    }

    public void setModule(ModuleConfig module) {
        this.module = module;
    }

    public ConstructorConfig getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorConfig constructor) {
        this.constructor = constructor;
    }

    public Set<PropertyConfig> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<PropertyConfig> properties) {
        this.properties = properties;
    }

    public LifecycleConfig getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleConfig create) {
        this.create = create;
    }

    public LifecycleConfig getStart() {
        return this.start;
    }

    public void setStart(LifecycleConfig start) {
        this.start = start;
    }

    public LifecycleConfig getStop() {
        return this.stop;
    }

    public void setStop(LifecycleConfig stop) {
        this.stop = stop;
    }

    public LifecycleConfig getDestroy() {
        return this.destroy;
    }

    public void setDestroy(LifecycleConfig destroy) {
        this.destroy = destroy;
    }

    public List<InstallConfig> getInstalls() {
        return this.installs;
    }

    public void setInstalls(List<InstallConfig> installs) {
        this.installs = installs;
    }

    public List<InstallConfig> getUninstalls() {
        return this.uninstalls;
    }

    public void setUninstalls(List<InstallConfig> uninstalls) {
        this.uninstalls = uninstalls;
    }

    public List<CallbackConfig> getIncallbacks() {
        return this.incallbacks;
    }

    public void setIncallbacks(List<CallbackConfig> incallbacks) {
        this.incallbacks = incallbacks;
    }

    public List<CallbackConfig> getUncallbacks() {
        return this.uncallbacks;
    }

    public void setUncallbacks(List<CallbackConfig> uncallbacks) {
        this.uncallbacks = uncallbacks;
    }

    public Set<DependsConfig> getDepends() {
        return this.depends;
    }

    public void setDepends(Set<DependsConfig> depends) {
        this.depends = depends;
    }
}

