/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.field.UnstructuredField;
import org.apache.james.mime4j.util.ByteSequence;

public class DelegatingFieldParser
implements FieldParser {
    private Map<String, FieldParser> parsers = new HashMap<String, FieldParser>();
    private FieldParser defaultParser = UnstructuredField.PARSER;

    public void setFieldParser(String name, FieldParser parser) {
        this.parsers.put(name.toLowerCase(), parser);
    }

    public FieldParser getParser(String name) {
        FieldParser field = this.parsers.get(name.toLowerCase());
        if (field == null) {
            return this.defaultParser;
        }
        return field;
    }

    @Override
    public ParsedField parse(String name, String body, ByteSequence raw) {
        FieldParser parser = this.getParser(name);
        return parser.parse(name, body, raw);
    }
}

