/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.jboss.logging.Logger;

public class RoutingContextImpl
implements RoutingContext {
    private static final Logger logger = Logger.getLogger(RoutingContextImpl.class);
    private final Map<SimpleString, RouteContextList> map = new HashMap<SimpleString, RouteContextList>();
    private Transaction transaction;
    private int queueCount;
    private SimpleString address;
    private SimpleString previousAddress;
    private RoutingType previousRoutingType;
    private RoutingType routingType;
    Boolean reusable = null;
    volatile int version;
    private final Executor executor;
    private boolean duplicateDetection = true;

    @Override
    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    @Override
    public RoutingContextImpl setDuplicateDetection(boolean value) {
        this.duplicateDetection = value;
        return this;
    }

    public RoutingContextImpl(Transaction transaction) {
        this(transaction, null);
    }

    public RoutingContextImpl(Transaction transaction, Executor executor) {
        this.transaction = transaction;
        this.executor = executor;
    }

    @Override
    public boolean isMirrorController() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return this.reusable != null && this.reusable != false;
    }

    @Override
    public int getPreviousBindingsVersion() {
        return this.version;
    }

    @Override
    public SimpleString getPreviousAddress() {
        return this.previousAddress;
    }

    @Override
    public RoutingContext setReusable(boolean reusable) {
        if (this.reusable != null && !this.reusable.booleanValue()) {
            return this;
        }
        this.reusable = reusable;
        return this;
    }

    @Override
    public RoutingContext setReusable(boolean reusable, int previousBindings) {
        this.version = previousBindings;
        this.previousAddress = this.address;
        this.previousRoutingType = this.routingType;
        if (this.reusable != null && !this.reusable.booleanValue()) {
            return this;
        }
        this.reusable = reusable;
        return this;
    }

    @Override
    public RoutingContext clear() {
        this.map.clear();
        this.queueCount = 0;
        this.version = 0;
        this.reusable = null;
        return this;
    }

    @Override
    public void addQueue(SimpleString address, Queue queue) {
        RouteContextList listing = this.getContextListing(address);
        if (queue.isDurable()) {
            listing.getDurableQueues().add(queue);
        } else {
            listing.getNonDurableQueues().add(queue);
        }
        ++this.queueCount;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("RoutingContextImpl(Address=" + this.address + ", routingType=" + this.routingType + ", PreviousAddress=" + this.previousAddress + " previousRoute:" + this.previousRoutingType + ", reusable=" + this.reusable + ", version=" + this.version + ")");
        for (Map.Entry<SimpleString, RouteContextList> entry : this.map.entrySet()) {
            printWriter.println("..................................................");
            printWriter.println("***** durable queues " + entry.getKey() + ":");
            for (Queue queue : entry.getValue().getDurableQueues()) {
                printWriter.println("- queueID=" + queue.getID() + " address:" + queue.getAddress() + " name:" + queue.getName() + " filter:" + queue.getFilter());
            }
            printWriter.println("***** non durable for " + entry.getKey() + ":");
            for (Queue queue : entry.getValue().getNonDurableQueues()) {
                printWriter.println("- queueID=" + queue.getID() + " address:" + queue.getAddress() + " name:" + queue.getName() + " filter:" + queue.getFilter());
            }
        }
        printWriter.println("..................................................");
        return stringWriter.toString();
    }

    @Override
    public void processReferences(List<MessageReference> refs, boolean direct) {
        this.internalprocessReferences(refs, direct);
    }

    private void internalprocessReferences(List<MessageReference> refs, boolean direct) {
        for (MessageReference ref : refs) {
            ref.getQueue().addTail(ref, direct);
        }
    }

    @Override
    public void addQueueWithAck(SimpleString address, Queue queue) {
        this.addQueue(address, queue);
        RouteContextList listing = this.getContextListing(address);
        listing.addAckedQueue(queue);
    }

    @Override
    public boolean isAlreadyAcked(SimpleString address, Queue queue) {
        RouteContextList listing = this.map.get(address);
        return listing == null ? false : listing.isAlreadyAcked(queue);
    }

    @Override
    public boolean isReusable(Message message, int version) {
        if (this.getPreviousBindingsVersion() != version) {
            this.reusable = false;
        }
        return this.isReusable() && this.queueCount > 0 && this.address.equals((Object)this.previousAddress) && this.previousRoutingType == this.routingType;
    }

    @Override
    public void setAddress(SimpleString address) {
        if (this.address == null || !this.address.equals((Object)address)) {
            this.clear();
        }
        this.address = address;
    }

    @Override
    public RoutingContext setRoutingType(RoutingType routingType) {
        if (this.routingType == null && routingType != null || this.routingType != routingType) {
            this.clear();
        }
        this.routingType = routingType;
        return this;
    }

    @Override
    public SimpleString getAddress(Message message) {
        if (this.address == null && message != null) {
            return message.getAddressSimpleString();
        }
        return this.address;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public RoutingType getPreviousRoutingType() {
        return this.previousRoutingType;
    }

    @Override
    public RouteContextList getContextListing(SimpleString address) {
        RouteContextList listing = this.map.get(address);
        if (listing == null) {
            listing = new ContextListing();
            this.map.put(address, listing);
        }
        return listing;
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(Transaction tx) {
        this.transaction = tx;
    }

    @Override
    public List<Queue> getNonDurableQueues(SimpleString address) {
        return this.getContextListing(address).getNonDurableQueues();
    }

    @Override
    public List<Queue> getDurableQueues(SimpleString address) {
        return this.getContextListing(address).getDurableQueues();
    }

    @Override
    public int getQueueCount() {
        return this.queueCount;
    }

    @Override
    public Map<SimpleString, RouteContextList> getContexListing() {
        return this.map;
    }

    private static class ContextListing
    implements RouteContextList {
        private final List<Queue> durableQueue = new ArrayList<Queue>(1);
        private final List<Queue> nonDurableQueue = new ArrayList<Queue>(1);
        private final List<Queue> ackedQueues = new ArrayList<Queue>();

        private ContextListing() {
        }

        @Override
        public int getNumberOfDurableQueues() {
            return this.durableQueue.size();
        }

        @Override
        public int getNumberOfNonDurableQueues() {
            return this.nonDurableQueue.size();
        }

        @Override
        public List<Queue> getDurableQueues() {
            return this.durableQueue;
        }

        @Override
        public List<Queue> getNonDurableQueues() {
            return this.nonDurableQueue;
        }

        @Override
        public void addAckedQueue(Queue queue) {
            this.ackedQueues.add(queue);
        }

        @Override
        public boolean isAlreadyAcked(Queue queue) {
            return this.ackedQueues.contains(queue);
        }
    }
}

