/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.UndertowLogger;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PathTemplatePredicate
implements Predicate {
    private final ExchangeAttribute attribute;
    private final String template;
    private final PathTemplate value;
    private static final boolean traceEnabled = UndertowLogger.PREDICATE_LOGGER.isTraceEnabled();

    public PathTemplatePredicate(String template, ExchangeAttribute attribute) {
        this.attribute = attribute;
        this.template = template;
        this.value = PathTemplate.create(template);
    }

    @Override
    public boolean resolve(HttpServerExchange exchange) {
        HashMap<String, String> params = new HashMap<String, String>();
        String path = this.attribute.readAttribute(exchange);
        if (path == null) {
            return false;
        }
        boolean result = this.value.matches(path, params);
        if (traceEnabled) {
            UndertowLogger.PREDICATE_LOGGER.tracef("Path template [%s] %s input [%s] for %s.", this.template, result ? "MATCHES" : "DOES NOT MATCH", path, exchange);
        }
        if (result) {
            TreeMap<String, String> context = (TreeMap<String, String>)exchange.getAttachment(PREDICATE_CONTEXT);
            if (context == null) {
                context = new TreeMap<String, String>();
                exchange.putAttachment(PREDICATE_CONTEXT, context);
            }
            if (traceEnabled) {
                params.entrySet().forEach(param -> UndertowLogger.PREDICATE_LOGGER.tracef("Storing template match [%s=%s] for %s.", param.getKey(), param.getValue(), (Object)exchange));
            }
            context.putAll(params);
        }
        return result;
    }

    public String toString() {
        if (this.attribute == ExchangeAttributes.relativePath()) {
            return "path-template( '" + this.template + "' )";
        }
        return "path-template( value='" + this.template + "', match='" + this.attribute.toString() + "' )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-template";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String.class);
            params.put("match", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            return params;
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute match = (ExchangeAttribute)config.get("match");
            if (match == null) {
                match = ExchangeAttributes.relativePath();
            }
            String value = (String)config.get("value");
            return new PathTemplatePredicate(value, match);
        }
    }
}

