/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.TrustedAuthority;

final class EntitySaslClient
extends AbstractSaslClient {
    private static final int ST_CHALLENGE_RESPONSE = 1;
    private static final int ST_RESPONSE_SENT = 2;
    private final SecureRandom secureRandom;
    private final Signature signature;
    private final boolean mutual;
    private final String serverName;
    private byte[] randomA;
    private byte[] randomB;
    private X509Certificate[] clientCertChain;

    EntitySaslClient(String mechanismName, boolean mutual, Signature signature, SecureRandom secureRandom, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super(mechanismName, protocol, serverName, callbackHandler, authorizationId, false, ElytronMessages.saslEntity);
        this.signature = signature;
        this.secureRandom = secureRandom;
        this.mutual = mutual;
        this.serverName = serverName;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] challenge) throws SaslException {
        switch (state) {
            case 1: {
                DERDecoder decoder = new DERDecoder(challenge);
                List<TrustedAuthority> trustedAuthorities = null;
                ArrayList<GeneralName> entityB = null;
                try {
                    decoder.startSequence();
                    this.randomB = decoder.decodeOctetString();
                    if (this.serverName != null && !this.serverName.isEmpty()) {
                        entityB = new ArrayList<GeneralName>(1);
                        entityB.add(new GeneralName.DNSName(this.serverName));
                    }
                    if (decoder.isNextType(128, 0, true)) {
                        decoder.decodeImplicit(0);
                        List<GeneralName> decodedEntityB = EntityUtil.decodeGeneralNames(decoder);
                        if (entityB != null && !EntityUtil.matchGeneralNames(decodedEntityB, entityB)) {
                            throw ElytronMessages.saslEntity.mechServerIdentifierMismatch().toSaslException();
                        }
                    }
                    if (decoder.isNextType(128, 1, true)) {
                        decoder.decodeImplicit(1);
                        trustedAuthorities = EntityUtil.decodeTrustedAuthorities(decoder);
                    }
                    decoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.saslEntity.mechInvalidServerMessageWithCause(e).toSaslException();
                }
                DEREncoder encoder = new DEREncoder();
                try {
                    byte[] signatureBytes;
                    PrivateKey privateKey;
                    encoder.startSequence();
                    this.randomA = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    if (entityB != null) {
                        encoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(encoder, entityB);
                    }
                    encoder.startExplicit(1);
                    TrustedAuthoritiesCallback trustedAuthoritiesCallback = new TrustedAuthoritiesCallback();
                    trustedAuthoritiesCallback.setTrustedAuthorities(trustedAuthorities);
                    CredentialCallback credentialCallback = new CredentialCallback(X509CertificateChainPrivateCredential.class, Entity.keyType(this.signature.getAlgorithm()));
                    try {
                        this.tryHandleCallbacks(trustedAuthoritiesCallback, credentialCallback);
                        X509CertificateChainPrivateCredential clientCertChainPrivateCredential = credentialCallback.getCredential(X509CertificateChainPrivateCredential.class);
                        if (clientCertChainPrivateCredential != null) {
                            this.clientCertChain = clientCertChainPrivateCredential.getCertificateChain();
                            if (this.clientCertChain == null || this.clientCertChain.length <= 0) {
                                throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedClientCertificate().toSaslException();
                            }
                            EntityUtil.encodeX509CertificateChain(encoder, this.clientCertChain);
                        } else {
                            throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedClientCertificate().toSaslException();
                        }
                        privateKey = clientCertChainPrivateCredential.getPrivateKey();
                    }
                    catch (UnsupportedCallbackException e) {
                        throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedClientCertificate().toSaslException();
                    }
                    encoder.endExplicit();
                    String authorizationId = this.getAuthorizationId();
                    ArrayList<GeneralName> authId = null;
                    if (authorizationId != null) {
                        encoder.encodeImplicit(2);
                        authId = new ArrayList<GeneralName>(1);
                        authId.add(new GeneralName.DirectoryName(authorizationId));
                        EntityUtil.encodeGeneralNames(encoder, authId);
                    }
                    if (privateKey == null) {
                        throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedPrivateKey().toSaslException();
                    }
                    DEREncoder tbsEncoder = new DEREncoder();
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(this.randomA);
                    tbsEncoder.encodeOctetString(this.randomB);
                    if (entityB != null) {
                        tbsEncoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(tbsEncoder, entityB);
                    }
                    if (authId != null) {
                        tbsEncoder.encodeImplicit(1);
                        EntityUtil.encodeGeneralNames(tbsEncoder, authId);
                    }
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initSign(privateKey);
                        this.signature.update(tbsEncoder.getEncoded());
                        signatureBytes = this.signature.sign();
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.saslEntity.mechUnableToCreateSignature(e).toSaslException();
                    }
                    encoder.startSequence();
                    EntityUtil.encodeAlgorithmIdentifier(encoder, this.signature.getAlgorithm());
                    encoder.encodeBitString(signatureBytes);
                    encoder.endSequence();
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.saslEntity.mechUnableToCreateResponseToken(e).toSaslException();
                }
                this.setNegotiationState(2);
                return encoder.getEncoded();
            }
            case 2: {
                if (this.mutual) {
                    DERDecoder decoder = new DERDecoder(challenge);
                    List<GeneralName> entityA = null;
                    try {
                        decoder.startSequence();
                        byte[] randomC = decoder.decodeOctetString();
                        if (decoder.isNextType(128, 0, true)) {
                            decoder.decodeImplicit(0);
                            entityA = EntityUtil.decodeGeneralNames(decoder);
                            if (!EntityUtil.matchGeneralNames(entityA, this.getClientCertificate())) {
                                throw ElytronMessages.saslEntity.mechClientIdentifierMismatch().toSaslException();
                            }
                        }
                        decoder.startExplicit(1);
                        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(EntityUtil.decodeCertificateData(decoder));
                        decoder.endExplicit();
                        X509Certificate serverCert = evidence.getFirstCertificate();
                        EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
                        this.handleCallbacks(evidenceVerifyCallback);
                        if (!evidenceVerifyCallback.isVerified()) {
                            throw ElytronMessages.saslEntity.mechServerAuthenticityCannotBeVerified().toSaslException();
                        }
                        decoder.startSequence();
                        decoder.skipElement();
                        byte[] serverSignature = decoder.decodeBitString();
                        decoder.endSequence();
                        DEREncoder tbsEncoder = new DEREncoder();
                        tbsEncoder.startSequence();
                        tbsEncoder.encodeOctetString(this.randomB);
                        tbsEncoder.encodeOctetString(this.randomA);
                        tbsEncoder.encodeOctetString(randomC);
                        if (entityA != null) {
                            EntityUtil.encodeGeneralNames(tbsEncoder, entityA);
                        }
                        tbsEncoder.endSequence();
                        try {
                            this.signature.initVerify(serverCert);
                            this.signature.update(tbsEncoder.getEncoded());
                            if (!this.signature.verify(serverSignature)) {
                                this.setNegotiationState(-1);
                                throw ElytronMessages.saslEntity.mechServerAuthenticityCannotBeVerified().toSaslException();
                            }
                        }
                        catch (InvalidKeyException | SignatureException e) {
                            throw ElytronMessages.saslEntity.mechUnableToVerifyServerSignature(e).toSaslException();
                        }
                        decoder.endSequence();
                    }
                    catch (ASN1Exception e) {
                        throw ElytronMessages.saslEntity.mechInvalidServerMessageWithCause(e).toSaslException();
                    }
                }
                if (challenge != null && challenge.length != 0) {
                    throw ElytronMessages.saslEntity.mechServerSentExtraMessage().toSaslException();
                }
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase(state);
    }

    @Override
    public void dispose() throws SaslException {
        this.clientCertChain = null;
    }

    private X509Certificate getClientCertificate() throws SaslException {
        if (this.clientCertChain == null || this.clientCertChain.length == 0) {
            throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedServerCertificate().toSaslException();
        }
        return this.clientCertChain[0];
    }
}

