/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.util.HashMap;
import java.util.HashSet;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.Sentence;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbProcedure;
import org.h2.bnf.context.DbSchema;
import org.h2.bnf.context.DbTableOrView;
import org.h2.message.DbException;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;

public class DbContextRule
implements Rule {
    public static final int COLUMN = 0;
    public static final int TABLE = 1;
    public static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    public static final int SCHEMA = 5;
    public static final int PROCEDURE = 6;
    private final DbContents contents;
    private final int type;
    private String columnType;

    public DbContextRule(DbContents contents, int type) {
        this.contents = contents;
        this.type = type;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
    }

    @Override
    public void accept(BnfVisitor visitor) {
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        String query;
        String s = query = sentence.getQuery();
        String up = sentence.getQueryUpper();
        switch (this.type) {
            case 5: {
                DbSchema[] schemas = this.contents.getSchemas();
                String best = null;
                DbSchema bestSchema = null;
                for (DbSchema schema : schemas) {
                    String name = StringUtils.toUpperEnglish(schema.name);
                    if (up.startsWith(name)) {
                        if (best != null && name.length() <= best.length()) continue;
                        best = name;
                        bestSchema = schema;
                        continue;
                    }
                    if (s.length() != 0 && !name.startsWith(up) || s.length() >= name.length()) continue;
                    sentence.add(name, name.substring(s.length()), this.type);
                    sentence.add(schema.quotedName + ".", schema.quotedName.substring(s.length()) + ".", 0);
                }
                if (best == null) break;
                sentence.setLastMatchedSchema(bestSchema);
                s = s.substring(best.length());
                break;
            }
            case 1: {
                DbSchema schema = sentence.getLastMatchedSchema();
                if (schema == null) {
                    schema = this.contents.getDefaultSchema();
                }
                DbTableOrView[] tables = schema.getTables();
                String best = null;
                DbTableOrView bestTable = null;
                for (DbTableOrView table : tables) {
                    String compare = up;
                    String name = StringUtils.toUpperEnglish(table.getName());
                    if (table.getQuotedName().length() > name.length()) {
                        name = table.getQuotedName();
                        compare = query;
                    }
                    if (compare.startsWith(name)) {
                        if (best != null && name.length() <= best.length()) continue;
                        best = name;
                        bestTable = table;
                        continue;
                    }
                    if (s.length() != 0 && !name.startsWith(compare) || s.length() >= name.length()) continue;
                    sentence.add(table.getQuotedName(), table.getQuotedName().substring(s.length()), 0);
                }
                if (best == null) break;
                sentence.setLastMatchedTable(bestTable);
                sentence.addTable(bestTable);
                s = s.substring(best.length());
                break;
            }
            case 3: {
                s = DbContextRule.autoCompleteTableAlias(sentence, true);
                break;
            }
            case 2: {
                s = DbContextRule.autoCompleteTableAlias(sentence, false);
                break;
            }
            case 4: {
                String alias;
                char ch;
                int i;
                if (query.indexOf(32) < 0) break;
                for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
                }
                if (i == 0 || ParserUtil.isKeyword(alias = up.substring(0, i))) break;
                s = s.substring(alias.length());
                break;
            }
            case 0: {
                HashSet<DbTableOrView> set = sentence.getTables();
                String best = null;
                DbTableOrView last = sentence.getLastMatchedTable();
                if (last != null && last.getColumns() != null) {
                    for (DbColumn column : last.getColumns()) {
                        String compare = up;
                        String name = StringUtils.toUpperEnglish(column.getName());
                        if (column.getQuotedName().length() > name.length()) {
                            name = column.getQuotedName();
                            compare = query;
                        }
                        if (!compare.startsWith(name) || this.columnType != null && !column.getDataType().contains(this.columnType)) continue;
                        String b = s.substring(name.length());
                        if (best == null || b.length() < best.length()) {
                            best = b;
                            continue;
                        }
                        if (s.length() != 0 && !name.startsWith(compare) || s.length() >= name.length()) continue;
                        sentence.add(column.getName(), column.getName().substring(s.length()), 0);
                    }
                }
                for (DbSchema schema : this.contents.getSchemas()) {
                    for (DbTableOrView table : schema.getTables()) {
                        if (table != last && set != null && !set.contains(table) || table == null || table.getColumns() == null) continue;
                        for (DbColumn column : table.getColumns()) {
                            String name = StringUtils.toUpperEnglish(column.getName());
                            if (this.columnType != null && !column.getDataType().contains(this.columnType)) continue;
                            if (up.startsWith(name)) {
                                String b = s.substring(name.length());
                                if (best != null && b.length() >= best.length()) continue;
                                best = b;
                                continue;
                            }
                            if (s.length() != 0 && !name.startsWith(up) || s.length() >= name.length()) continue;
                            sentence.add(column.getName(), column.getName().substring(s.length()), 0);
                        }
                    }
                }
                if (best == null) break;
                s = best;
                break;
            }
            case 6: {
                this.autoCompleteProcedure(sentence);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        if (!s.equals(query)) {
            while (Bnf.startWithSpace(s)) {
                s = s.substring(1);
            }
            sentence.setQuery(s);
            return true;
        }
        return false;
    }

    private void autoCompleteProcedure(Sentence sentence) {
        String incompleteSentence;
        DbSchema schema = sentence.getLastMatchedSchema();
        if (schema == null) {
            schema = this.contents.getDefaultSchema();
        }
        String incompleteFunctionName = incompleteSentence = sentence.getQueryUpper();
        if (incompleteSentence.contains("(")) {
            incompleteFunctionName = incompleteSentence.substring(0, incompleteSentence.indexOf(40)).trim();
        }
        RuleElement openBracket = new RuleElement("(", "Function");
        RuleElement closeBracket = new RuleElement(")", "Function");
        RuleElement comma = new RuleElement(",", "Function");
        for (DbProcedure procedure : schema.getProcedures()) {
            String procName = procedure.getName();
            if (!procName.startsWith(incompleteFunctionName)) continue;
            RuleElement procedureElement = new RuleElement(procName, "Function");
            RuleList rl = new RuleList(procedureElement, openBracket, false);
            if (incompleteSentence.contains("(")) {
                for (DbColumn parameter : procedure.getParameters()) {
                    if (parameter.getPosition() > 1) {
                        rl = new RuleList(rl, comma, false);
                    }
                    DbContextRule columnRule = new DbContextRule(this.contents, 0);
                    String parameterType = parameter.getDataType();
                    if (parameterType.contains("(")) {
                        parameterType = parameterType.substring(0, parameterType.indexOf(40));
                    }
                    columnRule.setColumnType(parameterType);
                    rl = new RuleList(rl, columnRule, false);
                }
                rl = new RuleList(rl, closeBracket, false);
            }
            rl.autoComplete(sentence);
        }
    }

    private static String autoCompleteTableAlias(Sentence sentence, boolean newAlias) {
        HashMap<String, DbTableOrView> map;
        char ch;
        int i;
        String s = sentence.getQuery();
        String up = sentence.getQueryUpper();
        for (i = 0; i < up.length() && ((ch = up.charAt(i)) == '_' || Character.isLetterOrDigit(ch)); ++i) {
        }
        if (i == 0) {
            return s;
        }
        String alias = up.substring(0, i);
        if ("SET".equals(alias) || ParserUtil.isKeyword(alias)) {
            return s;
        }
        if (newAlias) {
            sentence.addAlias(alias, sentence.getLastTable());
        }
        if ((map = sentence.getAliases()) != null && map.containsKey(alias) || sentence.getLastTable() == null) {
            if (newAlias && s.length() == alias.length()) {
                return s;
            }
            if ((s = s.substring(alias.length())).length() == 0) {
                sentence.add(alias + ".", ".", 0);
            }
            return s;
        }
        HashSet<DbTableOrView> tables = sentence.getTables();
        if (tables != null) {
            String best = null;
            for (DbTableOrView table : tables) {
                String tableName = StringUtils.toUpperEnglish(table.getName());
                if (alias.startsWith(tableName) && (best == null || tableName.length() > best.length())) {
                    sentence.setLastMatchedTable(table);
                    best = tableName;
                    continue;
                }
                if (s.length() != 0 && !tableName.startsWith(alias)) continue;
                sentence.add(tableName + ".", tableName.substring(s.length()) + ".", 0);
            }
            if (best != null) {
                if ((s = s.substring(best.length())).length() == 0) {
                    sentence.add(alias + ".", ".", 0);
                }
                return s;
            }
        }
        return s;
    }
}

