/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.IOException;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.engine.GeneratedKeysMode;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.result.ResultRemote;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.util.New;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class CommandRemote
implements CommandInterface {
    private final ArrayList<Transfer> transferList;
    private final ArrayList<ParameterInterface> parameters;
    private final Trace trace;
    private final String sql;
    private final int fetchSize;
    private SessionRemote session;
    private int id;
    private boolean isQuery;
    private int cmdType = 0;
    private boolean readonly;
    private final int created;

    public CommandRemote(SessionRemote session, ArrayList<Transfer> transferList, String sql, int fetchSize) {
        this.transferList = transferList;
        this.trace = session.getTrace();
        this.sql = sql;
        this.parameters = New.arrayList();
        this.prepare(session, true);
        this.session = session;
        this.fetchSize = fetchSize;
        this.created = session.getLastReconnect();
    }

    @Override
    public void stop() {
        throw DbException.throwInternalError();
    }

    private void prepare(SessionRemote s, boolean createParams) {
        this.id = s.getNextId();
        int count = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            try {
                boolean v16;
                Transfer transfer = this.transferList.get(i);
                boolean bl = v16 = s.getClientVersion() >= 16;
                if (createParams) {
                    s.traceOperation(v16 ? "SESSION_PREPARE_READ_PARAMS2" : "SESSION_PREPARE_READ_PARAMS", this.id);
                    transfer.writeInt(v16 ? 18 : 11).writeInt(this.id).writeString(this.sql);
                } else {
                    s.traceOperation("SESSION_PREPARE", this.id);
                    transfer.writeInt(0).writeInt(this.id).writeString(this.sql);
                }
                s.done(transfer);
                this.isQuery = transfer.readBoolean();
                this.readonly = transfer.readBoolean();
                this.cmdType = v16 && createParams ? transfer.readInt() : 0;
                int paramCount = transfer.readInt();
                if (!createParams) continue;
                this.parameters.clear();
                for (int j = 0; j < paramCount; ++j) {
                    ParameterRemote p = new ParameterRemote(j);
                    p.readMetaData(transfer);
                    this.parameters.add(p);
                }
                continue;
            }
            catch (IOException e) {
                s.removeServer(e, i--, ++count);
            }
        }
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    public ArrayList<ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void prepareIfRequired() {
        if (this.session.getLastReconnect() != this.created) {
            this.id = Integer.MIN_VALUE;
        }
        this.session.checkClosed();
        if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
            this.prepare(this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface getMetaData() {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            if (!this.isQuery) {
                return null;
            }
            int objectId = this.session.getNextId();
            ResultRemote result = null;
            int count = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_GET_META_DATA", this.id);
                    transfer.writeInt(10).writeInt(this.id).writeInt(objectId);
                    this.session.done(transfer);
                    int columnCount = transfer.readInt();
                    result = new ResultRemote(this.session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                    break;
                }
                catch (IOException e) {
                    this.session.removeServer(e, i--, ++count);
                    continue;
                }
            }
            this.session.autoCommitIfCluster();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface executeQuery(int maxRows, boolean scrollable) {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int objectId = this.session.getNextId();
            ResultRemote result = null;
            int count = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_QUERY", this.id);
                    transfer.writeInt(2).writeInt(this.id).writeInt(objectId).writeInt(maxRows);
                    int fetch = this.session.isClustered() || scrollable ? Integer.MAX_VALUE : this.fetchSize;
                    transfer.writeInt(fetch);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    int columnCount = transfer.readInt();
                    if (result != null) {
                        result.close();
                        result = null;
                    }
                    result = new ResultRemote(this.session, transfer, objectId, columnCount, fetch);
                    if (!this.readonly) continue;
                    break;
                }
                catch (IOException e) {
                    this.session.removeServer(e, i--, ++count);
                }
            }
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultWithGeneratedKeys executeUpdate(Object generatedKeysRequest) {
        this.checkParameters();
        boolean supportsGeneratedKeys = this.session.isSupportsGeneratedKeys();
        boolean readGeneratedKeys = supportsGeneratedKeys && !Boolean.FALSE.equals(generatedKeysRequest);
        int objectId = readGeneratedKeys ? this.session.getNextId() : 0;
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int updateCount = 0;
            ResultRemote generatedKeys = null;
            boolean autoCommit = false;
            int count = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                    transfer.writeInt(3).writeInt(this.id);
                    this.sendParameters(transfer);
                    if (supportsGeneratedKeys) {
                        int mode = GeneratedKeysMode.valueOf(generatedKeysRequest);
                        transfer.writeInt(mode);
                        switch (mode) {
                            case 2: {
                                Object[] keys = (int[])generatedKeysRequest;
                                transfer.writeInt(keys.length);
                                for (int key : keys) {
                                    transfer.writeInt(key);
                                }
                                break;
                            }
                            case 3: {
                                Object[] keys = (String[])generatedKeysRequest;
                                transfer.writeInt(keys.length);
                                for (int key : keys) {
                                    transfer.writeString((String)key);
                                }
                                break;
                            }
                        }
                    }
                    this.session.done(transfer);
                    updateCount = transfer.readInt();
                    autoCommit = transfer.readBoolean();
                    if (!readGeneratedKeys) continue;
                    int columnCount = transfer.readInt();
                    if (generatedKeys != null) {
                        generatedKeys.close();
                        generatedKeys = null;
                    }
                    generatedKeys = new ResultRemote(this.session, transfer, objectId, columnCount, Integer.MAX_VALUE);
                    continue;
                }
                catch (IOException e) {
                    this.session.removeServer(e, i--, ++count);
                }
            }
            this.session.setAutoCommitFromServer(autoCommit);
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            if (generatedKeys != null) {
                return new ResultWithGeneratedKeys.WithKeys(updateCount, generatedKeys);
            }
            return ResultWithGeneratedKeys.of(updateCount);
        }
    }

    private void checkParameters() {
        if (this.cmdType != 60) {
            for (ParameterInterface p : this.parameters) {
                p.checkSet();
            }
        }
    }

    private void sendParameters(Transfer transfer) throws IOException {
        int len = this.parameters.size();
        transfer.writeInt(len);
        for (ParameterInterface p : this.parameters) {
            Value pVal = p.getParamValue();
            if (pVal == null && this.cmdType == 60) {
                pVal = ValueNull.INSTANCE;
            }
            transfer.writeValue(pVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.traceOperation("COMMAND_CLOSE", this.id);
            for (Transfer transfer : this.transferList) {
                try {
                    transfer.writeInt(4).writeInt(this.id);
                }
                catch (IOException e) {
                    this.trace.error(e, "close");
                }
            }
        }
        this.session = null;
        try {
            for (ParameterInterface p : this.parameters) {
                Value v = p.getParamValue();
                if (v == null) continue;
                v.remove();
            }
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
        this.parameters.clear();
    }

    @Override
    public void cancel() {
        this.session.cancelStatement(this.id);
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    @Override
    public int getCommandType() {
        return this.cmdType;
    }
}

