/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.New;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        boolean runLoopAgain;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        db.lockMeta(this.session);
        do {
            Table t2;
            ArrayList<Table> tables = db.getAllTablesAndViews(false);
            ArrayList<Table> arrayList = New.arrayList();
            Iterator<DbObject> iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table t2 = iterator.next();
                if (t2.getName() == null || TableType.VIEW != t2.getTableType()) continue;
                arrayList.add(t2);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                if (t2.getName() == null || TableType.TABLE_LINK != t2.getTableType()) continue;
                arrayList.add(t2);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                if (t2.getName() == null || TableType.TABLE != t2.getTableType() || t2.isHidden()) continue;
                arrayList.add(t2);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                if (t2.getName() == null || TableType.EXTERNAL_TABLE_ENGINE != t2.getTableType() || t2.isHidden()) continue;
                arrayList.add(t2);
            }
            runLoopAgain = false;
            for (Table t2 : arrayList) {
                if (t2.getName() == null) continue;
                if (db.getDependentTable(t2, t2) == null) {
                    db.removeSchemaObject(this.session, t2);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        for (Schema schema : db.getAllSchemas()) {
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        ArrayList<SchemaObject> list = New.arrayList();
        for (SchemaObject obj : db.getAllSchemaObjects(3)) {
            if (((Sequence)obj).getBelongsToTable()) continue;
            list.add(obj);
        }
        list.addAll(db.getAllSchemaObjects(5));
        list.addAll(db.getAllSchemaObjects(4));
        list.addAll(db.getAllSchemaObjects(11));
        list.addAll(db.getAllSchemaObjects(9));
        for (SchemaObject obj : list) {
            if (obj.isHidden()) continue;
            db.removeSchemaObject(this.session, obj);
        }
        for (User user : db.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            db.removeDatabaseObject(this.session, user);
        }
        for (Role role : db.getAllRoles()) {
            String sql = role.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, role);
        }
        ArrayList<DbObject> arrayList = New.arrayList();
        arrayList.addAll(db.getAllRights());
        arrayList.addAll(db.getAllAggregates());
        arrayList.addAll(db.getAllUserDataTypes());
        for (DbObject obj : arrayList) {
            String sql = obj.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, obj);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }

    @Override
    public int getType() {
        return 38;
    }
}

