/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.TableSynonym;

public class DropSynonym
extends SchemaCommand {
    private String synonymName;
    private boolean ifExists;

    public DropSynonym(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSynonymName(String name) {
        this.synonymName = name;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        TableSynonym synonym = this.getSchema().getSynonym(this.synonymName);
        if (synonym == null) {
            if (!this.ifExists) {
                throw DbException.get(42102, this.synonymName);
            }
        } else {
            this.session.getDatabase().removeSchemaObject(this.session, synonym);
        }
        return 0;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 89;
    }
}

