/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private Expression limitExpr;
    private TableFilter sourceTableFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Value v;
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        RowList rows = new RowList(this.session);
        int limitRows = -1;
        if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            limitRows = v.getInt();
        }
        try {
            this.setCurrentRowNumber(0);
            int count = 0;
            while (limitRows != 0 && this.targetTableFilter.next()) {
                this.setCurrentRowNumber(rows.size() + 1);
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                Row row = this.targetTableFilter.get();
                boolean done = false;
                if (table.fireRow()) {
                    done = table.fireBeforeRow(this.session, row, null);
                }
                if (!done) {
                    rows.add(row);
                }
                if (limitRows < 0 || ++count < limitRows) continue;
                break;
            }
            int rowScanCount = 0;
            rows.reset();
            while (rows.hasNext()) {
                if ((++rowScanCount & 0x7F) == 0) {
                    this.checkCanceled();
                }
                Row row = rows.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rows.reset();
                while (rows.hasNext()) {
                    Row row = rows.next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            int n = count;
            return n;
        }
        finally {
            rows.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("DELETE ");
        buff.append("FROM ").append(this.targetTableFilter.getPlanSQL(false));
        if (this.condition != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            buff.append("\nLIMIT (").append(StringUtils.unEnclose(this.limitExpr.getSQL())).append(')');
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0);
            if (this.sourceTableFilter != null) {
                this.condition.mapColumns(this.sourceTableFilter, 0);
            }
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        TableFilter[] filters = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, ExpressionVisitor.allColumnsForTableFilters(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }

    public TableFilter getTableFilter() {
        return this.targetTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }
}

