/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.GeneratedKeys;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.expression.SequenceValue;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Insert
extends Prepared
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private TableFilter sourceTableFilter;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private boolean ignore;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        generatedKeys.initialize(this.table);
        int listSize = this.list.size();
        if (listSize > 0) {
            int columnLen = this.columns.length;
            for (int x = 0; x < listSize; ++x) {
                Row newRow;
                block11: {
                    this.session.startStatementWithinTransaction();
                    generatedKeys.nextRow();
                    newRow = this.table.getTemplateRow();
                    Expression[] expr = this.list.get(x);
                    this.setCurrentRowNumber(x + 1);
                    for (int i = 0; i < columnLen; ++i) {
                        Column c = this.columns[i];
                        int index = c.getColumnId();
                        Expression e = expr[i];
                        if (e == null) continue;
                        e = e.optimize(this.session);
                        try {
                            Value v = c.convert(e.getValue(this.session), this.session.getDatabase().getMode());
                            newRow.setValue(index, v);
                            if (!(e instanceof SequenceValue)) continue;
                            generatedKeys.add(c);
                            continue;
                        }
                        catch (DbException ex) {
                            throw this.setRow(ex, x, Insert.getSQL(expr));
                        }
                    }
                    ++this.rowNumber;
                    this.table.validateConvertUpdateSequence(this.session, newRow);
                    boolean done = this.table.fireBeforeRow(this.session, null, newRow);
                    if (done) continue;
                    this.table.lock(this.session, true, false);
                    try {
                        this.table.addRow(this.session, newRow);
                    }
                    catch (DbException de) {
                        if (this.handleOnDuplicate(de)) break block11;
                        --this.rowNumber;
                        continue;
                    }
                }
                generatedKeys.confirmRow(newRow);
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfterRow(this.session, null, newRow, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                ResultInterface rows = this.query.query(0);
                while (rows.next()) {
                    generatedKeys.nextRow();
                    Value[] r = rows.currentRow();
                    Row newRow = this.addRowImpl(r);
                    if (newRow == null) continue;
                    generatedKeys.confirmRow(newRow);
                }
                rows.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] values) {
        this.addRowImpl(values);
    }

    private Row addRowImpl(Value[] values) {
        Row newRow = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int len = this.columns.length;
        for (int j = 0; j < len; ++j) {
            Column c = this.columns[j];
            int index = c.getColumnId();
            try {
                Value v = c.convert(values[j], this.session.getDatabase().getMode());
                newRow.setValue(index, v);
                continue;
            }
            catch (DbException ex) {
                throw this.setRow(ex, this.rowNumber, Insert.getSQL(values));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, newRow);
        boolean done = this.table.fireBeforeRow(this.session, null, newRow);
        if (!done) {
            this.table.addRow(this.session, newRow);
            this.session.log(this.table, (short)0, newRow);
            this.table.fireAfterRow(this.session, null, newRow, false);
            return newRow;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
        buff.append(this.table.getSQL()).append('(');
        for (Column c : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        buff.append(")\n");
        if (this.insertFromSelect) {
            buff.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            buff.append("SORTED ");
        }
        if (!this.list.isEmpty()) {
            buff.append("VALUES ");
            int row = 0;
            if (this.list.size() > 1) {
                buff.append('\n');
            }
            for (Expression[] expr : this.list) {
                if (row++ > 0) {
                    buff.append(",\n");
                }
                buff.append('(');
                buff.resetCount();
                for (Expression e : expr) {
                    buff.appendExceptFirst(", ");
                    if (e == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.list.isEmpty() && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.list.isEmpty()) {
            for (Expression[] expr : this.list) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int len = expr.length;
                for (int i = 0; i < len; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    if (this.sourceTableFilter != null) {
                        e.mapColumns(this.sourceTableFilter, 0);
                    }
                    if ((e = e.optimize(this.session)) instanceof Parameter) {
                        Parameter p = (Parameter)e;
                        p.setColumn(this.columns[i]);
                    }
                    expr[i] = e;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.sortedInsertMode = sortedInsertMode;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean value) {
        this.insertFromSelect = value;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    private boolean handleOnDuplicate(DbException de) {
        if (de.getErrorCode() != 23505) {
            throw de;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            if (this.ignore) {
                return false;
            }
            throw de;
        }
        ArrayList<Object> variableNames = new ArrayList<Object>(this.duplicateKeyAssignmentMap.size());
        Expression[] row = this.list.get(this.getCurrentRowNumber() - 1);
        for (int i = 0; i < this.columns.length; ++i) {
            String key = this.table.getSchema().getName() + "." + this.table.getName() + "." + this.columns[i].getName();
            variableNames.add(key);
            this.session.setVariable(key, row[i].getValue(this.session));
        }
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.table.getSQL()).append(" SET ");
        for (Column column : this.duplicateKeyAssignmentMap.keySet()) {
            buff.appendExceptFirst(", ");
            Expression ex = this.duplicateKeyAssignmentMap.get(column);
            buff.append(column.getSQL()).append("=").append(ex.getSQL());
        }
        buff.append(" WHERE ");
        Index foundIndex = (Index)de.getSource();
        if (foundIndex == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        buff.append(this.prepareUpdateCondition(foundIndex).getSQL());
        String sql = buff.toString();
        Prepared command = this.session.prepare(sql);
        for (Parameter parameter : command.getParameters()) {
            Parameter insertParam = (Parameter)this.parameters.get(parameter.getIndex());
            parameter.setValue(insertParam.getValue(this.session));
        }
        command.update();
        for (String string : variableNames) {
            this.session.setVariable(string, ValueNull.INSTANCE);
        }
        return true;
    }

    private Expression prepareUpdateCondition(Index foundIndex) {
        Column[] indexedColumns;
        if (foundIndex instanceof MVPrimaryIndex) {
            MVPrimaryIndex foundMV = (MVPrimaryIndex)foundIndex;
            indexedColumns = new Column[]{foundMV.getIndexColumns()[foundMV.getMainIndexColumn()].column};
        } else {
            indexedColumns = foundIndex.getColumns();
        }
        Expression[] row = this.list.get(this.getCurrentRowNumber() - 1);
        Condition condition = null;
        block0: for (Column column : indexedColumns) {
            ExpressionColumn expr = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName());
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expr.getColumnName().equals(this.columns[i].getName())) continue;
                if (condition == null) {
                    condition = new Comparison(this.session, 0, expr, row[i]);
                    continue block0;
                }
                condition = new ConditionAndOr(0, condition, new Comparison(this.session, 0, expr, row[i]));
                continue block0;
            }
        }
        return condition;
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }
}

