/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.Update;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowImpl;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class MergeUsing
extends Prepared {
    private Table targetTable;
    private TableFilter targetTableFilter;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> valuesExpressionList = New.arrayList();
    private Query query;
    private TableFilter sourceTableFilter;
    private Expression onCondition;
    private Update updateCommand;
    private Delete deleteCommand;
    private Insert insertCommand;
    private String queryAlias;
    private int countUpdatedRows;
    private Column[] sourceKeys;
    private Select targetMatchQuery;
    private final HashMap<Value, Integer> targetRowidsRemembered = new HashMap();
    private int sourceQueryRowNumber;

    public MergeUsing(Merge merge) {
        super(merge.getSession());
        this.targetTable = merge.getTargetTable();
        this.targetTableFilter = merge.getTargetTableFilter();
    }

    @Override
    public int update() {
        this.targetRowidsRemembered.clear();
        if (this.targetTableFilter != null) {
            this.targetTableFilter.startQuery(this.session);
            this.targetTableFilter.reset();
        }
        if (this.sourceTableFilter != null) {
            this.sourceTableFilter.startQuery(this.session);
            this.sourceTableFilter.reset();
        }
        this.sourceQueryRowNumber = 0;
        this.checkRights();
        this.setCurrentRowNumber(0);
        ResultInterface rows = this.query.query(0);
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), true);
        this.targetTable.lock(this.session, true, false);
        while (rows.next()) {
            ++this.sourceQueryRowNumber;
            Value[] sourceRowValues = rows.currentRow();
            RowImpl sourceRow = new RowImpl(sourceRowValues, 0);
            this.setCurrentRowNumber(this.sourceQueryRowNumber);
            this.merge(sourceRow);
        }
        rows.close();
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), false);
        return this.countUpdatedRows;
    }

    private int evaluateTriggerMasks() {
        int masks = 0;
        if (this.insertCommand != null) {
            masks |= 1;
        }
        if (this.updateCommand != null) {
            masks |= 2;
        }
        if (this.deleteCommand != null) {
            masks |= 4;
        }
        return masks;
    }

    private void checkRights() {
        if (this.insertCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 4);
        }
        if (this.updateCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 8);
        }
        if (this.deleteCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 2);
        }
        this.session.getUser().checkRight(this.targetTable, 1);
        this.session.getUser().checkRight(this.sourceTableFilter.getTable(), 1);
    }

    protected void merge(Row sourceRow) {
        this.sourceTableFilter.set(sourceRow);
        boolean rowFound = this.isTargetRowFound();
        int rowUpdateCount = 0;
        if (rowFound) {
            if (this.updateCommand != null) {
                rowUpdateCount += this.updateCommand.update();
            }
            if (this.deleteCommand != null) {
                int deleteRowUpdateCount = this.deleteCommand.update();
                if (rowUpdateCount == 1 && deleteRowUpdateCount == 1) {
                    this.countUpdatedRows += deleteRowUpdateCount;
                    deleteRowUpdateCount = 0;
                } else {
                    rowUpdateCount += deleteRowUpdateCount;
                }
            }
        } else if (rowUpdateCount == 0) {
            rowUpdateCount += this.addRowByCommandInsert(sourceRow);
        } else if (rowUpdateCount != 1) {
            throw DbException.get(23505, "Duplicate key inserted " + rowUpdateCount + " rows at once, only 1 expected:" + this.targetTable.getSQL());
        }
        this.countUpdatedRows += rowUpdateCount;
    }

    private boolean isTargetRowFound() {
        ResultInterface rows = this.targetMatchQuery.query(0);
        int countTargetRowsFound = 0;
        Value[] targetRowIdValue = null;
        while (rows.next()) {
            ++countTargetRowsFound;
            targetRowIdValue = rows.currentRow();
            if (this.targetRowidsRemembered.containsKey(targetRowIdValue[0])) {
                throw DbException.get(23505, "Merge using ON column expression, duplicate _ROWID_ target record already updated, deleted or inserted:_ROWID_=" + targetRowIdValue[0].toString() + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + this.targetRowidsRemembered.get(targetRowIdValue[0]));
            }
            this.targetRowidsRemembered.put(targetRowIdValue[0], this.sourceQueryRowNumber);
        }
        rows.close();
        if (countTargetRowsFound > 1) {
            throw DbException.get(23505, "Duplicate key updated " + countTargetRowsFound + " rows at once, only 1 expected:_ROWID_=" + targetRowIdValue[0].toString() + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + this.targetRowidsRemembered.get(targetRowIdValue[0]));
        }
        return countTargetRowsFound > 0;
    }

    private int addRowByCommandInsert(Row sourceRow) {
        int localCount = 0;
        if (this.insertCommand != null) {
            localCount += this.insertCommand.update();
            if (!this.isTargetRowFound()) {
                throw DbException.get(50000, "Expected to find key after row inserted, but none found. Insert does not match ON condition.:" + this.targetTable.getSQL() + ":source row=" + Arrays.asList(sourceRow.getValueList()));
            }
        }
        return localCount;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("MERGE INTO ");
        buff.append(this.targetTable.getSQL()).append('(');
        for (Column c : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        buff.append(')');
        if (this.keys != null) {
            buff.append(" KEY(");
            buff.resetCount();
            for (Column c : this.keys) {
                buff.appendExceptFirst(", ");
                buff.append(c.getSQL());
            }
            buff.append(')');
        }
        buff.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            buff.append("VALUES ");
            int row = 0;
            for (Expression[] expr : this.valuesExpressionList) {
                if (row++ > 0) {
                    buff.append(", ");
                }
                buff.append('(');
                buff.resetCount();
                for (Expression e : expr) {
                    buff.appendExceptFirst(", ");
                    if (e == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        this.onCondition.addFilterConditions(this.sourceTableFilter, true);
        this.onCondition.addFilterConditions(this.targetTableFilter, true);
        this.onCondition.mapColumns(this.sourceTableFilter, 2);
        this.onCondition.mapColumns(this.targetTableFilter, 1);
        if (this.keys == null) {
            HashSet<Column> targetColumns = this.buildColumnListFromOnCondition(this.targetTableFilter);
            this.keys = targetColumns.toArray(new Column[0]);
        }
        if (this.keys.length == 0) {
            throw DbException.get(42122, "No references to target columns found in ON clause:" + this.targetTableFilter.toString());
        }
        if (this.sourceKeys == null) {
            HashSet<Column> sourceColumns = this.buildColumnListFromOnCondition(this.sourceTableFilter);
            this.sourceKeys = sourceColumns.toArray(new Column[0]);
        }
        if (this.sourceKeys.length == 0) {
            throw DbException.get(42122, "No references to source columns found in ON clause:" + this.sourceTableFilter.toString());
        }
        this.onCondition = this.onCondition.optimize(this.session);
        this.onCondition.createIndexConditions(this.session, this.sourceTableFilter);
        this.onCondition.createIndexConditions(this.session, this.targetTableFilter);
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && this.valuesExpressionList.get(0).length == 0 ? new Column[0] : this.targetTable.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expr : this.valuesExpressionList) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expr.length; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    expr[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        int embeddedStatementsCount = 0;
        if (this.updateCommand != null) {
            this.updateCommand.setSourceTableFilter(this.sourceTableFilter);
            this.updateCommand.setCondition(this.appendOnCondition(this.updateCommand));
            this.updateCommand.prepare();
            ++embeddedStatementsCount;
        }
        if (this.deleteCommand != null) {
            this.deleteCommand.setSourceTableFilter(this.sourceTableFilter);
            this.deleteCommand.setCondition(this.appendOnCondition(this.deleteCommand));
            this.deleteCommand.prepare();
            ++embeddedStatementsCount;
        }
        if (this.insertCommand != null) {
            this.insertCommand.setSourceTableFilter(this.sourceTableFilter);
            this.insertCommand.prepare();
            ++embeddedStatementsCount;
        }
        if (embeddedStatementsCount == 0) {
            throw DbException.get(42000, "At least UPDATE, DELETE or INSERT embedded statement must be supplied.");
        }
        Expression targetMatchCondition = this.targetMatchQuery.getCondition();
        targetMatchCondition.addFilterConditions(this.sourceTableFilter, true);
        targetMatchCondition.mapColumns(this.sourceTableFilter, 2);
        targetMatchCondition = targetMatchCondition.optimize(this.session);
        targetMatchCondition.createIndexConditions(this.session, this.sourceTableFilter);
        this.targetMatchQuery.prepare();
    }

    private HashSet<Column> buildColumnListFromOnCondition(TableFilter anyTableFilter) {
        HashSet<Column> filteredColumns = new HashSet<Column>();
        HashSet<Column> columns = new HashSet<Column>();
        ExpressionVisitor visitor = ExpressionVisitor.getColumnsVisitor(columns);
        this.onCondition.isEverything(visitor);
        for (Column c : columns) {
            if (c == null || c.getTable() != anyTableFilter.getTable()) continue;
            filteredColumns.add(c);
        }
        return filteredColumns;
    }

    private Expression appendOnCondition(Update updateCommand) {
        if (updateCommand.getCondition() == null) {
            return this.onCondition;
        }
        return new ConditionAndOr(0, updateCommand.getCondition(), this.onCondition);
    }

    private Expression appendOnCondition(Delete deleteCommand) {
        if (deleteCommand.getCondition() == null) {
            return this.onCondition;
        }
        return new ConditionAndOr(0, deleteCommand.getCondition(), this.onCondition);
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setOnCondition(Expression condition) {
        this.onCondition = condition;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public Prepared getUpdateCommand() {
        return this.updateCommand;
    }

    public void setUpdateCommand(Update updateCommand) {
        this.updateCommand = updateCommand;
    }

    public Prepared getDeleteCommand() {
        return this.deleteCommand;
    }

    public void setDeleteCommand(Delete deleteCommand) {
        this.deleteCommand = deleteCommand;
    }

    public Insert getInsertCommand() {
        return this.insertCommand;
    }

    public void setInsertCommand(Insert insertCommand) {
        this.insertCommand = insertCommand;
    }

    public void setQueryAlias(String alias) {
        this.queryAlias = alias;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setTargetTableFilter(TableFilter targetTableFilter) {
        this.targetTableFilter = targetTableFilter;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public Select getTargetMatchQuery() {
        return this.targetMatchQuery;
    }

    public void setTargetMatchQuery(Select targetMatchQuery) {
        this.targetMatchQuery = targetMatchQuery;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }
}

