/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.command.dml.SetTypes;
import org.h2.engine.DbSettings;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.fs.FilePathEncrypt;
import org.h2.store.fs.FilePathRec;
import org.h2.store.fs.FileUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class ConnectionInfo
implements Cloneable {
    private static final HashSet<String> KNOWN_SETTINGS;
    private Properties prop = new Properties();
    private String originalURL;
    private String url;
    private String user;
    private byte[] filePasswordHash;
    private byte[] fileEncryptionKey;
    private byte[] userPasswordHash;
    private String name;
    private String nameNormalized;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;
    private boolean unnamed;

    public ConnectionInfo(String name) {
        this.name = name;
        this.url = "jdbc:h2:" + name;
        this.parseName();
    }

    public ConnectionInfo(String u, Properties info) {
        this.originalURL = u = ConnectionInfo.remapURL(u);
        if (!u.startsWith("jdbc:h2:")) {
            throw DbException.getInvalidValueException("url", u);
        }
        this.url = u;
        this.readProperties(info);
        this.readSettingsFromURL();
        this.setUserName(this.removeProperty("USER", ""));
        this.convertPasswords();
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
        String recoverTest = this.removeProperty("RECOVER_TEST", null);
        if (recoverTest != null) {
            FilePathRec.register();
            try {
                Utils.callStaticMethod("org.h2.store.RecoverTester.init", recoverTest);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
            this.name = "rec:" + this.name;
        }
    }

    private static boolean isKnownSetting(String s) {
        return KNOWN_SETTINGS.contains(s);
    }

    public ConnectionInfo clone() throws CloneNotSupportedException {
        ConnectionInfo clone = (ConnectionInfo)super.clone();
        clone.prop = (Properties)this.prop.clone();
        clone.filePasswordHash = Utils.cloneByteArray(this.filePasswordHash);
        clone.fileEncryptionKey = Utils.cloneByteArray(this.fileEncryptionKey);
        clone.userPasswordHash = Utils.cloneByteArray(this.userPasswordHash);
        return clone;
    }

    private void parseName() {
        if (".".equals(this.name)) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
            if ("mem:".equals(this.name)) {
                this.unnamed = true;
            }
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
        if (this.persistent && !this.remote) {
            this.name = "/".equals(SysProperties.FILE_SEPARATOR) ? this.name.replace('\\', '/') : this.name.replace('/', '\\');
        }
    }

    public void setBaseDir(String dir) {
        if (this.persistent) {
            String n;
            String absDir = FileUtils.unwrap(FileUtils.toRealPath(dir));
            boolean absolute = FileUtils.isAbsolute(this.name);
            String prefix = null;
            if (dir.endsWith(SysProperties.FILE_SEPARATOR)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            if (absolute) {
                n = this.name;
            } else {
                n = FileUtils.unwrap(this.name);
                prefix = this.name.substring(0, this.name.length() - n.length());
                n = dir + SysProperties.FILE_SEPARATOR + n;
            }
            String normalizedName = FileUtils.unwrap(FileUtils.toRealPath(n));
            if (normalizedName.equals(absDir) || !normalizedName.startsWith(absDir)) {
                throw DbException.get(90028, normalizedName + " outside " + absDir);
            }
            if (!absDir.endsWith("/") && !absDir.endsWith("\\") && normalizedName.charAt(absDir.length()) != '/') {
                throw DbException.get(90028, normalizedName + " outside " + absDir);
            }
            if (!absolute) {
                this.name = prefix + dir + SysProperties.FILE_SEPARATOR + FileUtils.unwrap(this.name);
            }
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    boolean isUnnamedInMemory() {
        return this.unnamed;
    }

    private void readProperties(Properties info) {
        Object[] list = info.keySet().toArray();
        DbSettings s = null;
        for (Object k : list) {
            String key = StringUtils.toUpperEnglish(k.toString());
            if (this.prop.containsKey(key)) {
                throw DbException.get(90066, key);
            }
            Object value = info.get(k);
            if (ConnectionInfo.isKnownSetting(key)) {
                this.prop.put(key, value);
                continue;
            }
            if (s == null) {
                s = this.getDbSettings();
            }
            if (!s.containsKey(key)) continue;
            this.prop.put(key, value);
        }
    }

    private void readSettingsFromURL() {
        DbSettings defaultSettings = DbSettings.getDefaultSettings();
        int idx = this.url.indexOf(59);
        if (idx >= 0) {
            String[] list;
            String settings = this.url.substring(idx + 1);
            this.url = this.url.substring(0, idx);
            for (String setting : list = StringUtils.arraySplit(settings, ';', false)) {
                if (setting.length() == 0) continue;
                int equal = setting.indexOf(61);
                if (equal < 0) {
                    throw this.getFormatException();
                }
                String value = setting.substring(equal + 1);
                String key = setting.substring(0, equal);
                if (!ConnectionInfo.isKnownSetting(key = StringUtils.toUpperEnglish(key)) && !defaultSettings.containsKey(key)) {
                    throw DbException.get(90113, key);
                }
                String old = this.prop.getProperty(key);
                if (old != null && !old.equals(value)) {
                    throw DbException.get(90066, key);
                }
                this.prop.setProperty(key, value);
            }
        }
    }

    private char[] removePassword() {
        Object p = this.prop.remove("PASSWORD");
        if (p == null) {
            return new char[0];
        }
        if (p instanceof char[]) {
            return (char[])p;
        }
        return p.toString().toCharArray();
    }

    private void convertPasswords() {
        char[] password = this.removePassword();
        boolean passwordHash = this.removeProperty("PASSWORD_HASH", false);
        if (this.getProperty("CIPHER", null) != null) {
            int space = -1;
            int len = password.length;
            for (int i = 0; i < len; ++i) {
                if (password[i] != ' ') continue;
                space = i;
                break;
            }
            if (space < 0) {
                throw DbException.get(90050);
            }
            char[] np = Arrays.copyOfRange(password, space + 1, password.length);
            char[] filePassword = Arrays.copyOf(password, space);
            Arrays.fill(password, '\u0000');
            password = np;
            this.fileEncryptionKey = FilePathEncrypt.getPasswordBytes(filePassword);
            this.filePasswordHash = ConnectionInfo.hashPassword(passwordHash, "file", filePassword);
        }
        this.userPasswordHash = ConnectionInfo.hashPassword(passwordHash, this.user, password);
    }

    private static byte[] hashPassword(boolean passwordHash, String userName, char[] password) {
        if (passwordHash) {
            return StringUtils.convertHexToBytes(new String(password));
        }
        if (userName.length() == 0 && password.length == 0) {
            return new byte[0];
        }
        return SHA256.getKeyPasswordHash(userName, password);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(this.getProperty(key, null), defaultValue, false);
    }

    public boolean removeProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(this.removeProperty(key, null), defaultValue, false);
    }

    String removeProperty(String key, String defaultValue) {
        Object x;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            DbException.throwInternalError(key);
        }
        return (x = this.prop.remove(key)) == null ? defaultValue : x.toString();
    }

    public String getName() {
        if (!this.persistent) {
            return this.name;
        }
        if (this.nameNormalized == null) {
            String n;
            if (!(SysProperties.IMPLICIT_RELATIVE_PATH || FileUtils.isAbsolute(this.name) || this.name.contains("./") || this.name.contains(".\\") || this.name.contains(":/") || this.name.contains(":\\"))) {
                throw DbException.get(90011, this.originalURL);
            }
            String suffix = ".h2.db";
            if (FileUtils.exists(this.name + suffix)) {
                n = FileUtils.toRealPath(this.name + suffix);
            } else {
                suffix = ".mv.db";
                n = FileUtils.toRealPath(this.name + suffix);
            }
            String fileName = FileUtils.getName(n);
            if (fileName.length() < suffix.length() + 1) {
                throw DbException.get(90138, this.name);
            }
            this.nameNormalized = n.substring(0, n.length() - suffix.length());
        }
        return this.nameNormalized;
    }

    public byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    byte[] getFileEncryptionKey() {
        return this.fileEncryptionKey;
    }

    public String getUserName() {
        return this.user;
    }

    byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    String[] getKeys() {
        return this.prop.keySet().toArray(new String[this.prop.size()]);
    }

    String getProperty(String key) {
        Object value = this.prop.get(key);
        if (!(value instanceof String)) {
            return null;
        }
        return value.toString();
    }

    int getProperty(String key, int defaultValue) {
        String s;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            DbException.throwInternalError(key);
        }
        return (s = this.getProperty(key)) == null ? defaultValue : Integer.parseInt(s);
    }

    public String getProperty(String key, String defaultValue) {
        String s;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(key)) {
            DbException.throwInternalError(key);
        }
        return (s = this.getProperty(key)) == null ? defaultValue : s;
    }

    String getProperty(int setting, String defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key);
        return s == null ? defaultValue : s;
    }

    int getIntProperty(int setting, int defaultValue) {
        String key = SetTypes.getTypeName(setting);
        String s = this.getProperty(key, null);
        try {
            return s == null ? defaultValue : Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String name) {
        this.user = StringUtils.toUpperEnglish(name);
    }

    public void setUserPasswordHash(byte[] hash) {
        this.userPasswordHash = hash;
    }

    public void setFilePasswordHash(byte[] hash) {
        this.filePasswordHash = hash;
    }

    public void setFileEncryptionKey(byte[] key) {
        this.fileEncryptionKey = key;
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.prop.setProperty(key, value);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String url) {
        this.originalURL = url;
    }

    DbException getFormatException() {
        String format = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
        return DbException.get(90046, format, this.url);
    }

    public void setServerKey(String serverKey) {
        this.remote = true;
        this.persistent = false;
        this.name = serverKey;
    }

    public DbSettings getDbSettings() {
        DbSettings defaultSettings = DbSettings.getDefaultSettings();
        HashMap<String, String> s = new HashMap<String, String>();
        for (Object k : this.prop.keySet()) {
            String key = k.toString();
            if (ConnectionInfo.isKnownSetting(key) || !defaultSettings.containsKey(key)) continue;
            s.put(key, this.prop.getProperty(key));
        }
        return DbSettings.getInstance(s);
    }

    private static String remapURL(String url) {
        String urlMap = SysProperties.URL_MAP;
        if (urlMap != null && urlMap.length() > 0) {
            try {
                SortedProperties prop = SortedProperties.loadProperties(urlMap);
                String url2 = prop.getProperty(url);
                if (url2 == null) {
                    prop.put(url, "");
                    prop.store(urlMap);
                } else if ((url2 = url2.trim()).length() > 0) {
                    return url2;
                }
            }
            catch (IOException e) {
                throw DbException.convert(e);
            }
        }
        return url;
    }

    static {
        ArrayList<String> list = SetTypes.getTypes();
        String[] connectionTime = new String[]{"ACCESS_MODE_DATA", "AUTOCOMMIT", "CIPHER", "CREATE", "CACHE_TYPE", "FILE_LOCK", "IGNORE_UNKNOWN_SETTINGS", "IFEXISTS", "INIT", "PASSWORD", "RECOVER", "RECOVER_TEST", "USER", "AUTO_SERVER", "AUTO_SERVER_PORT", "NO_UPGRADE", "AUTO_RECONNECT", "OPEN_NEW", "PAGE_SIZE", "PASSWORD_HASH", "JMX", "SCOPE_GENERATED_KEYS"};
        HashSet<String> set = new HashSet<String>(list.size() + connectionTime.length);
        set.addAll(list);
        for (String key : connectionTime) {
            if (set.add(key) || !SysProperties.CHECK) continue;
            DbException.throwInternalError(key);
        }
        KNOWN_SETTINGS = set;
    }
}

