/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.api.Aggregate;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;
import org.h2.util.JdbcUtils;
import org.h2.value.DataType;

public class UserAggregate
extends DbObjectBase {
    private String className;
    private Class<?> javaClass;

    public UserAggregate(Database db, int id, String name, String className, boolean force) {
        this.initDbObjectBase(db, id, name, 3);
        this.className = className;
        if (!force) {
            this.getInstance();
        }
    }

    public Aggregate getInstance() {
        if (this.javaClass == null) {
            this.javaClass = JdbcUtils.loadUserClass(this.className);
        }
        try {
            Object obj = this.javaClass.newInstance();
            Aggregate agg = obj instanceof Aggregate ? (Aggregate)obj : new AggregateWrapper((AggregateFunction)obj);
            return agg;
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return "DROP AGGREGATE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        return "CREATE FORCE AGGREGATE " + this.getSQL() + " FOR " + Parser.quoteIdentifier(this.className);
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("AGGREGATE");
    }

    public String getJavaClassName() {
        return this.className;
    }

    private static class AggregateWrapper
    implements Aggregate {
        private final AggregateFunction aggregateFunction;

        AggregateWrapper(AggregateFunction aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }

        @Override
        public void init(Connection conn) throws SQLException {
            this.aggregateFunction.init(conn);
        }

        @Override
        public int getInternalType(int[] inputTypes) throws SQLException {
            int[] sqlTypes = new int[inputTypes.length];
            for (int i = 0; i < inputTypes.length; ++i) {
                sqlTypes[i] = DataType.convertTypeToSQLType(inputTypes[i]);
            }
            return DataType.convertSQLTypeToValueType(this.aggregateFunction.getType(sqlTypes));
        }

        @Override
        public void add(Object value) throws SQLException {
            this.aggregateFunction.add(value);
        }

        @Override
        public Object getResult() throws SQLException {
            return this.aggregateFunction.getResult();
        }
    }
}

