/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.AggregateDataArrayCollecting;
import org.h2.expression.AggregateDataMedian;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Aggregate
extends Expression {
    private static final HashMap<String, AggregateType> AGGREGATES = new HashMap(26);
    private final AggregateType type;
    private final Select select;
    private final boolean distinct;
    private Expression on;
    private Expression groupConcatSeparator;
    private ArrayList<SelectOrderBy> groupConcatOrderList;
    private ArrayList<SelectOrderBy> arrayAggOrderList;
    private SortOrder groupConcatSort;
    private SortOrder arrayOrderSort;
    private int dataType;
    private int scale;
    private long precision;
    private int displaySize;
    private int lastGroupRowId;
    private Expression filterCondition;

    public Aggregate(AggregateType type, Expression on, Select select, boolean distinct) {
        this.type = type;
        this.on = on;
        this.select = select;
        this.distinct = distinct;
    }

    private static void addAggregate(String name, AggregateType type) {
        AGGREGATES.put(name, type);
    }

    public static AggregateType getAggregateType(String name) {
        return AGGREGATES.get(name);
    }

    public void setGroupConcatOrder(ArrayList<SelectOrderBy> orderBy) {
        this.groupConcatOrderList = orderBy;
    }

    public void setArrayAggOrder(ArrayList<SelectOrderBy> orderBy) {
        this.arrayAggOrderList = orderBy;
    }

    public void setGroupConcatSeparator(Expression separator) {
        this.groupConcatSeparator = separator;
    }

    public void setFilterCondition(Expression filterCondition) {
        this.filterCondition = filterCondition;
    }

    private SortOrder initOrder(ArrayList<SelectOrderBy> orderList, Session session) {
        int size = orderList.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        for (int i = 0; i < size; ++i) {
            int order;
            SelectOrderBy o = orderList.get(i);
            index[i] = i + 1;
            sortType[i] = order = o.descending ? 1 : 0;
        }
        return new SortOrder(session.getDatabase(), index, sortType, null);
    }

    @Override
    public void updateAggregate(Session session) {
        SelectOrderBy o;
        int i;
        Value[] array;
        int size;
        Value v;
        HashMap<Expression, Object> group = this.select.getCurrentGroup();
        if (group == null) {
            return;
        }
        int groupRowId = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == groupRowId) {
            return;
        }
        this.lastGroupRowId = groupRowId;
        AggregateData data = (AggregateData)group.get(this);
        if (data == null) {
            data = AggregateData.create(this.type);
            group.put(this, data);
        }
        Value value = v = this.on == null ? null : this.on.getValue(session);
        if (this.type == AggregateType.GROUP_CONCAT && v != ValueNull.INSTANCE) {
            v = v.convertTo(13);
            if (this.groupConcatOrderList != null) {
                size = this.groupConcatOrderList.size();
                array = new Value[1 + size];
                array[0] = v;
                for (i = 0; i < size; ++i) {
                    o = this.groupConcatOrderList.get(i);
                    array[i + 1] = o.expression.getValue(session);
                }
                v = ValueArray.get(array);
            }
        }
        if (this.type == AggregateType.ARRAY_AGG && v != ValueNull.INSTANCE && this.arrayAggOrderList != null) {
            size = this.arrayAggOrderList.size();
            array = new Value[1 + size];
            array[0] = v;
            for (i = 0; i < size; ++i) {
                o = this.arrayAggOrderList.get(i);
                array[i + 1] = o.expression.getValue(session);
            }
            v = ValueArray.get(array);
        }
        if (this.filterCondition != null && !this.filterCondition.getBooleanValue(session)) {
            return;
        }
        data.add(session.getDatabase(), this.dataType, this.distinct, v);
    }

    @Override
    public Value getValue(Session session) {
        HashMap<Expression, Object> group;
        if (this.select.isQuickAggregateQuery()) {
            switch (this.type) {
                case COUNT: 
                case COUNT_ALL: {
                    Table table = this.select.getTopTableFilter().getTable();
                    return ValueLong.get(table.getRowCount(session));
                }
                case MIN: 
                case MAX: {
                    Cursor cursor;
                    SearchRow row;
                    boolean first = this.type == AggregateType.MIN;
                    Index index = this.getMinMaxColumnIndex();
                    int sortType = index.getIndexColumns()[0].sortType;
                    if ((sortType & 1) != 0) {
                        first = !first;
                    }
                    Value v = (row = (cursor = index.findFirstOrLast(session, first)).getSearchRow()) == null ? ValueNull.INSTANCE : row.getValue(index.getColumns()[0].getColumnId());
                    return v;
                }
                case MEDIAN: {
                    return AggregateDataMedian.getResultFromIndex(session, this.on, this.dataType);
                }
            }
            DbException.throwInternalError("type=" + (Object)((Object)this.type));
        }
        if ((group = this.select.getCurrentGroup()) == null) {
            throw DbException.get(90054, this.getSQL());
        }
        AggregateData data = (AggregateData)group.get(this);
        if (data == null) {
            data = AggregateData.create(this.type);
        }
        Value v = data.getValue(session.getDatabase(), this.dataType, this.distinct);
        if (this.type == AggregateType.GROUP_CONCAT) {
            ArrayList<Value> list = ((AggregateDataArrayCollecting)data).getList();
            if (list == null || list.isEmpty()) {
                return ValueNull.INSTANCE;
            }
            if (this.groupConcatOrderList != null) {
                final SortOrder sortOrder = this.groupConcatSort;
                Collections.sort(list, new Comparator<Value>(){

                    @Override
                    public int compare(Value v1, Value v2) {
                        Value[] a1 = ((ValueArray)v1).getList();
                        Value[] a2 = ((ValueArray)v2).getList();
                        return sortOrder.compare(a1, a2);
                    }
                });
            }
            StatementBuilder buff = new StatementBuilder();
            String sep = this.groupConcatSeparator == null ? "," : this.groupConcatSeparator.getValue(session).getString();
            for (Value val : list) {
                String s = val.getType() == 17 ? ((ValueArray)val).getList()[0].getString() : val.getString();
                if (s == null) continue;
                if (sep != null) {
                    buff.appendExceptFirst(sep);
                }
                buff.append(s);
            }
            v = ValueString.get(buff.toString());
        } else if (this.type == AggregateType.ARRAY_AGG) {
            ArrayList<Value> list = ((AggregateDataArrayCollecting)data).getList();
            if (list == null || list.isEmpty()) {
                return ValueNull.INSTANCE;
            }
            if (this.arrayAggOrderList != null) {
                final SortOrder sortOrder = this.arrayOrderSort;
                Collections.sort(list, new Comparator<Value>(){

                    @Override
                    public int compare(Value v1, Value v2) {
                        Value[] a1 = ((ValueArray)v1).getList();
                        Value[] a2 = ((ValueArray)v2).getList();
                        return sortOrder.compare(a1, a2);
                    }
                });
            }
            v = ValueArray.get(list.toArray(new Value[list.size()]));
        }
        return v;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        if (this.on != null) {
            this.on.mapColumns(resolver, level);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy o : this.groupConcatOrderList) {
                o.expression.mapColumns(resolver, level);
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy o : this.arrayAggOrderList) {
                o.expression.mapColumns(resolver, level);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.mapColumns(resolver, level);
        }
        if (this.filterCondition != null) {
            this.filterCondition.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.on != null) {
            this.on = this.on.optimize(session);
            this.dataType = this.on.getType();
            this.scale = this.on.getScale();
            this.precision = this.on.getPrecision();
            this.displaySize = this.on.getDisplaySize();
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy o : this.groupConcatOrderList) {
                o.expression = o.expression.optimize(session);
            }
            this.groupConcatSort = this.initOrder(this.groupConcatOrderList, session);
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy o : this.arrayAggOrderList) {
                o.expression = o.expression.optimize(session);
            }
            this.arrayOrderSort = this.initOrder(this.arrayAggOrderList, session);
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator = this.groupConcatSeparator.optimize(session);
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(session);
        }
        switch (this.type) {
            case GROUP_CONCAT: {
                this.dataType = 13;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case COUNT: 
            case COUNT_ALL: {
                this.dataType = 5;
                this.scale = 0;
                this.precision = 19L;
                this.displaySize = 20;
                break;
            }
            case SELECTIVITY: {
                this.dataType = 4;
                this.scale = 0;
                this.precision = 10L;
                this.displaySize = 11;
                break;
            }
            case HISTOGRAM: {
                this.dataType = 17;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case SUM: {
                if (this.dataType == 1) {
                    this.dataType = 5;
                    break;
                }
                if (!DataType.supportsAdd(this.dataType)) {
                    throw DbException.get(90015, this.getSQL());
                }
                this.dataType = DataType.getAddProofType(this.dataType);
                break;
            }
            case AVG: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case MIN: 
            case MAX: 
            case MEDIAN: {
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                this.dataType = 7;
                this.precision = 17L;
                this.displaySize = 24;
                this.scale = 0;
                break;
            }
            case BOOL_AND: 
            case BOOL_OR: {
                this.dataType = 1;
                this.precision = 1L;
                this.displaySize = 5;
                this.scale = 0;
                break;
            }
            case BIT_AND: 
            case BIT_OR: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case ARRAY_AGG: {
                this.dataType = 17;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.type));
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.on != null) {
            this.on.setEvaluatable(tableFilter, b);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy o : this.groupConcatOrderList) {
                o.expression.setEvaluatable(tableFilter, b);
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy o : this.arrayAggOrderList) {
                o.expression.setEvaluatable(tableFilter, b);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.setEvaluatable(tableFilter, b);
        }
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        return this.displaySize;
    }

    private String getSQLGroupConcat() {
        StatementBuilder buff = new StatementBuilder("GROUP_CONCAT(");
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        buff.append(this.on.getSQL());
        if (this.groupConcatOrderList != null) {
            buff.append(" ORDER BY ");
            for (SelectOrderBy o : this.groupConcatOrderList) {
                buff.appendExceptFirst(", ");
                buff.append(o.expression.getSQL());
                if (!o.descending) continue;
                buff.append(" DESC");
            }
        }
        if (this.groupConcatSeparator != null) {
            buff.append(" SEPARATOR ").append(this.groupConcatSeparator.getSQL());
        }
        buff.append(')');
        if (this.filterCondition != null) {
            buff.append(" FILTER (WHERE ").append(this.filterCondition.getSQL()).append(')');
        }
        return buff.toString();
    }

    private String getSQLArrayAggregate() {
        StatementBuilder buff = new StatementBuilder("ARRAY_AGG(");
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        buff.append(this.on.getSQL());
        if (this.arrayAggOrderList != null) {
            buff.append(" ORDER BY ");
            for (SelectOrderBy o : this.arrayAggOrderList) {
                buff.appendExceptFirst(", ");
                buff.append(o.expression.getSQL());
                if (!o.descending) continue;
                buff.append(" DESC");
            }
        }
        buff.append(')');
        if (this.filterCondition != null) {
            buff.append(" FILTER (WHERE ").append(this.filterCondition.getSQL()).append(')');
        }
        return buff.toString();
    }

    @Override
    public String getSQL() {
        String text;
        switch (this.type) {
            case GROUP_CONCAT: {
                return this.getSQLGroupConcat();
            }
            case COUNT_ALL: {
                return "COUNT(*)";
            }
            case COUNT: {
                text = "COUNT";
                break;
            }
            case SELECTIVITY: {
                text = "SELECTIVITY";
                break;
            }
            case HISTOGRAM: {
                text = "HISTOGRAM";
                break;
            }
            case SUM: {
                text = "SUM";
                break;
            }
            case MIN: {
                text = "MIN";
                break;
            }
            case MAX: {
                text = "MAX";
                break;
            }
            case AVG: {
                text = "AVG";
                break;
            }
            case STDDEV_POP: {
                text = "STDDEV_POP";
                break;
            }
            case STDDEV_SAMP: {
                text = "STDDEV_SAMP";
                break;
            }
            case VAR_POP: {
                text = "VAR_POP";
                break;
            }
            case VAR_SAMP: {
                text = "VAR_SAMP";
                break;
            }
            case BOOL_AND: {
                text = "BOOL_AND";
                break;
            }
            case BOOL_OR: {
                text = "BOOL_OR";
                break;
            }
            case BIT_AND: {
                text = "BIT_AND";
                break;
            }
            case BIT_OR: {
                text = "BIT_OR";
                break;
            }
            case MEDIAN: {
                text = "MEDIAN";
                break;
            }
            case ARRAY_AGG: {
                return this.getSQLArrayAggregate();
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.type));
            }
        }
        text = this.distinct ? text + "(DISTINCT " + this.on.getSQL() + ')' : text + StringUtils.enclose(this.on.getSQL());
        if (this.filterCondition != null) {
            text = text + " FILTER (WHERE " + this.filterCondition.getSQL() + ')';
        }
        return text;
    }

    private Index getMinMaxColumnIndex() {
        if (this.on instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)this.on;
            Column column = col.getColumn();
            TableFilter filter = col.getTableFilter();
            if (filter != null) {
                Table table = filter.getTable();
                return table.getIndexForColumn(column, true, false);
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (this.filterCondition != null && !this.filterCondition.isEverything(visitor)) {
            return false;
        }
        if (visitor.getType() == 1) {
            switch (this.type) {
                case COUNT: {
                    if (!this.distinct && this.on.getNullable() == 0) {
                        return visitor.getTable().canGetRowCount();
                    }
                    return false;
                }
                case COUNT_ALL: {
                    return visitor.getTable().canGetRowCount();
                }
                case MIN: 
                case MAX: {
                    Index index = this.getMinMaxColumnIndex();
                    return index != null;
                }
                case MEDIAN: {
                    if (this.distinct) {
                        return false;
                    }
                    return AggregateDataMedian.getMedianColumnIndex(this.on) != null;
                }
            }
            return false;
        }
        if (this.on != null && !this.on.isEverything(visitor)) {
            return false;
        }
        if (this.groupConcatSeparator != null && !this.groupConcatSeparator.isEverything(visitor)) {
            return false;
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy o : this.groupConcatOrderList) {
                if (o.expression.isEverything(visitor)) continue;
                return false;
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy o : this.arrayAggOrderList) {
                if (o.expression.isEverything(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        if (this.on != null) {
            cost += this.on.getCost();
        }
        if (this.filterCondition != null) {
            cost += this.filterCondition.getCost();
        }
        return cost;
    }

    static {
        Aggregate.addAggregate("COUNT", AggregateType.COUNT);
        Aggregate.addAggregate("SUM", AggregateType.SUM);
        Aggregate.addAggregate("MIN", AggregateType.MIN);
        Aggregate.addAggregate("MAX", AggregateType.MAX);
        Aggregate.addAggregate("AVG", AggregateType.AVG);
        Aggregate.addAggregate("GROUP_CONCAT", AggregateType.GROUP_CONCAT);
        Aggregate.addAggregate("STRING_AGG", AggregateType.GROUP_CONCAT);
        Aggregate.addAggregate("STDDEV_SAMP", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV_POP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("STDDEVP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("VAR_POP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VARP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VAR_SAMP", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VAR", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VARIANCE", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("BOOL_OR", AggregateType.BOOL_OR);
        Aggregate.addAggregate("SOME", AggregateType.BOOL_OR);
        Aggregate.addAggregate("BOOL_AND", AggregateType.BOOL_AND);
        Aggregate.addAggregate("EVERY", AggregateType.BOOL_AND);
        Aggregate.addAggregate("SELECTIVITY", AggregateType.SELECTIVITY);
        Aggregate.addAggregate("HISTOGRAM", AggregateType.HISTOGRAM);
        Aggregate.addAggregate("BIT_OR", AggregateType.BIT_OR);
        Aggregate.addAggregate("BIT_AND", AggregateType.BIT_AND);
        Aggregate.addAggregate("MEDIAN", AggregateType.MEDIAN);
        Aggregate.addAggregate("ARRAY_AGG", AggregateType.ARRAY_AGG);
    }

    public static enum AggregateType {
        COUNT_ALL,
        COUNT,
        GROUP_CONCAT,
        SUM,
        MIN,
        MAX,
        AVG,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_POP,
        VAR_SAMP,
        BOOL_OR,
        BOOL_AND,
        BIT_OR,
        BIT_AND,
        SELECTIVITY,
        HISTOGRAM,
        MEDIAN,
        ARRAY_AGG;

    }
}

