/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Database;
import org.h2.expression.Aggregate;
import org.h2.expression.AggregateData;
import org.h2.message.DbException;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final Aggregate.AggregateType aggregateType;
    private long count;
    private ValueHashMap<AggregateDataDefault> distinctValues;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(Aggregate.AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(Database database, int dataType, boolean distinct, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (distinct) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(v, this);
            return;
        }
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = v.convertTo(dataType);
                    break;
                }
                v = v.convertTo(this.value.getType());
                this.value = this.value.add(v);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = v.convertTo(DataType.getAddProofType(dataType));
                    break;
                }
                v = v.convertTo(this.value.getType());
                this.value = this.value.add(v);
                break;
            }
            case MIN: {
                if (this.value != null && database.compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case MAX: {
                if (this.value != null && database.compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double x = v.getDouble();
                if (this.count == 1L) {
                    this.mean = x;
                    this.m2 = 0.0;
                    break;
                }
                double delta = x - this.mean;
                this.mean += delta / (double)this.count;
                this.m2 += delta * (x - this.mean);
                break;
            }
            case BOOL_AND: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && v.getBoolean());
                break;
            }
            case BOOL_OR: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || v.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = v.convertTo(dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & v.getLong()).convertTo(dataType);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = v.convertTo(dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | v.getLong()).convertTo(dataType);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int dataType, boolean distinct) {
        if (distinct) {
            this.count = 0L;
            this.groupDistinct(database, dataType);
        }
        Value v = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case BOOL_AND: 
            case BOOL_OR: 
            case BIT_AND: 
            case BIT_OR: {
                v = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                v = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return v == null ? ValueNull.INSTANCE : v.convertTo(dataType);
    }

    private static Value divide(Value a, long by) {
        if (by == 0L) {
            return ValueNull.INSTANCE;
        }
        int type = Value.getHigherOrder(a.getType(), 5);
        Value b = ValueLong.get(by).convertTo(type);
        a = a.convertTo(type).divide(b);
        return a;
    }

    private void groupDistinct(Database database, int dataType) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value v : this.distinctValues.keys()) {
            this.add(database, dataType, false, v);
        }
    }
}

