/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

class AggregateDataMedian
extends AggregateData {
    private Collection<Value> values;

    AggregateDataMedian() {
    }

    private static boolean isNullsLast(Index index) {
        IndexColumn ic = index.getIndexColumns()[0];
        int sortType = ic.sortType;
        return (sortType & 4) != 0 || (sortType & 1) != 0 && (sortType & 2) == 0;
    }

    static Index getMedianColumnIndex(Expression on) {
        if (on instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)on;
            Column column = col.getColumn();
            TableFilter filter = col.getTableFilter();
            if (filter != null) {
                Table table = filter.getTable();
                ArrayList<Index> indexes = table.getIndexes();
                Index result = null;
                if (indexes != null) {
                    boolean nullable = column.isNullable();
                    int size = indexes.size();
                    for (int i = 1; i < size; ++i) {
                        Index index = indexes.get(i);
                        if (!index.canFindNext() || !index.isFirstColumn(column) || result != null && result.getColumns().length <= index.getColumns().length && (!nullable || !AggregateDataMedian.isNullsLast(result) || AggregateDataMedian.isNullsLast(index))) continue;
                        result = index;
                    }
                }
                return result;
            }
        }
        return null;
    }

    static Value getResultFromIndex(Session session, Expression on, int dataType) {
        Index index = AggregateDataMedian.getMedianColumnIndex(on);
        long count = index.getRowCount(session);
        if (count == 0L) {
            return ValueNull.INSTANCE;
        }
        Cursor cursor = index.find(session, null, null);
        cursor.next();
        int columnId = index.getColumns()[0].getColumnId();
        ExpressionColumn expr = (ExpressionColumn)on;
        if (expr.getColumn().isNullable()) {
            boolean hasNulls = false;
            while (count > 0L) {
                SearchRow row = cursor.getSearchRow();
                if (row == null) {
                    return ValueNull.INSTANCE;
                }
                if (row.getValue(columnId) != ValueNull.INSTANCE) break;
                --count;
                cursor.next();
                hasNulls = true;
            }
            if (count == 0L) {
                return ValueNull.INSTANCE;
            }
            if (!hasNulls && AggregateDataMedian.isNullsLast(index)) {
                TableFilter tableFilter = expr.getTableFilter();
                SearchRow check = tableFilter.getTable().getTemplateSimpleRow(true);
                check.setValue(columnId, ValueNull.INSTANCE);
                Cursor nullsCursor = index.find(session, check, check);
                while (nullsCursor.next()) {
                    --count;
                }
                if (count <= 0L) {
                    return ValueNull.INSTANCE;
                }
            }
        }
        long skip = (count - 1L) / 2L;
        int i = 0;
        while ((long)i < skip) {
            cursor.next();
            ++i;
        }
        SearchRow row = cursor.getSearchRow();
        if (row == null) {
            return ValueNull.INSTANCE;
        }
        Value v = row.getValue(columnId);
        if (v == ValueNull.INSTANCE) {
            return v;
        }
        if ((count & 1L) == 0L) {
            cursor.next();
            row = cursor.getSearchRow();
            if (row == null) {
                return v;
            }
            Value v2 = row.getValue(columnId);
            if (v2 == ValueNull.INSTANCE) {
                return v;
            }
            return AggregateDataMedian.getMedian(v, v2, dataType, session.getDatabase().getCompareMode());
        }
        return v;
    }

    @Override
    void add(Database database, int dataType, boolean distinct, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        Collection<Value> c = this.values;
        if (c == null) {
            c = distinct ? new HashSet() : new ArrayList();
            this.values = c;
        }
        c.add(v);
    }

    @Override
    Value getValue(Database database, int dataType, boolean distinct) {
        Collection<Value> c = this.values;
        if (c == null) {
            return ValueNull.INSTANCE;
        }
        if (distinct && c instanceof ArrayList) {
            c = new HashSet<Value>(c);
        }
        Value[] a = c.toArray(new Value[0]);
        final CompareMode mode = database.getCompareMode();
        Arrays.sort(a, new Comparator<Value>(){

            @Override
            public int compare(Value o1, Value o2) {
                return o1.compareTo(o2, mode);
            }
        });
        int len = a.length;
        int idx = len / 2;
        Value v1 = a[idx];
        if ((len & 1) == 1) {
            return v1.convertTo(dataType);
        }
        return AggregateDataMedian.getMedian(a[idx - 1], v1, dataType, mode);
    }

    private static Value getMedian(Value v0, Value v1, int dataType, CompareMode mode) {
        if (v0.compareTo(v1, mode) == 0) {
            return v0.convertTo(dataType);
        }
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: {
                return ValueInt.get((v0.getInt() + v1.getInt()) / 2).convertTo(dataType);
            }
            case 5: {
                return ValueLong.get((v0.getLong() + v1.getLong()) / 2L);
            }
            case 6: {
                return ValueDecimal.get(v0.getBigDecimal().add(v1.getBigDecimal()).divide(BigDecimal.valueOf(2L)));
            }
            case 8: {
                return ValueFloat.get((v0.getFloat() + v1.getFloat()) / 2.0f);
            }
            case 7: {
                return ValueDouble.get(((double)v0.getFloat() + v1.getDouble()) / 2.0);
            }
            case 9: {
                ValueTime t0 = (ValueTime)v0.convertTo(9);
                ValueTime t1 = (ValueTime)v1.convertTo(9);
                return ValueTime.fromNanos((t0.getNanos() + t1.getNanos()) / 2L);
            }
            case 10: {
                ValueDate d0 = (ValueDate)v0.convertTo(10);
                ValueDate d1 = (ValueDate)v1.convertTo(10);
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay((DateTimeUtils.absoluteDayFromDateValue(d0.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(d1.getDateValue())) / 2L));
            }
            case 11: {
                ValueTimestamp ts0 = (ValueTimestamp)v0.convertTo(11);
                ValueTimestamp ts1 = (ValueTimestamp)v1.convertTo(11);
                long dateSum = DateTimeUtils.absoluteDayFromDateValue(ts0.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(ts1.getDateValue());
                long nanos = (ts0.getTimeNanos() + ts1.getTimeNanos()) / 2L;
                if ((dateSum & 1L) != 0L && (nanos += 43200000000000L) >= 86400000000000L) {
                    nanos -= 86400000000000L;
                    ++dateSum;
                }
                return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(dateSum / 2L), nanos);
            }
            case 24: {
                ValueTimestampTimeZone ts0 = (ValueTimestampTimeZone)v0.convertTo(24);
                ValueTimestampTimeZone ts1 = (ValueTimestampTimeZone)v1.convertTo(24);
                long dateSum = DateTimeUtils.absoluteDayFromDateValue(ts0.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(ts1.getDateValue());
                long nanos = (ts0.getTimeNanos() + ts1.getTimeNanos()) / 2L;
                int offset = ts0.getTimeZoneOffsetMins() + ts1.getTimeZoneOffsetMins();
                if ((dateSum & 1L) != 0L) {
                    nanos += 43200000000000L;
                }
                if ((offset & 1) != 0) {
                    nanos += 30000000000L;
                }
                if (nanos >= 86400000000000L) {
                    nanos -= 86400000000000L;
                    ++dateSum;
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(dateSum / 2L), nanos, (short)(offset / 2));
            }
        }
        return v0.convertTo(dataType);
    }
}

