/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.AbstractList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    public ConditionInParameter(Database database, Expression left, Parameter parameter) {
        this.database = database;
        this.left = left;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        boolean result = false;
        boolean hasNull = false;
        Value value = this.parameter.getValue(session);
        if (value instanceof ValueArray) {
            for (Value r : ((ValueArray)value).getList()) {
                if (r == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                result = Comparison.compareNotNull(this.database, l, r = r.convertTo(l.getType()), 0);
                if (!result) {
                    continue;
                }
                break;
            }
        } else if (value == ValueNull.INSTANCE) {
            hasNull = true;
        } else {
            value = value.convertTo(l.getType());
            result = Comparison.compareNotNull(this.database, l, value, 0);
        }
        if (!result && hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(result);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.left.mapColumns(resolver, level);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left.isConstant() && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        filter.addIndexCondition(IndexCondition.getInList(l, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public String getSQL() {
        return '(' + this.left.getSQL() + " = ANY(" + this.parameter.getSQL() + "))";
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.parameter.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int index) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[index]);
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

