/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Operation
extends Expression {
    private OpType opType;
    private Expression left;
    private Expression right;
    private int dataType;
    private boolean convertRight = true;

    public Operation(OpType opType, Expression left, Expression right) {
        this.opType = opType;
        this.left = left;
        this.right = right;
    }

    @Override
    public String getSQL() {
        String sql = this.opType == OpType.NEGATE ? "- " + this.left.getSQL() : this.left.getSQL() + " " + this.getOperationToken() + " " + this.right.getSQL();
        return "(" + sql + ")";
    }

    private String getOperationToken() {
        switch (this.opType) {
            case NEGATE: {
                return "-";
            }
            case CONCAT: {
                return "||";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Value r;
        Value l = this.left.getValue(session).convertTo(this.dataType);
        if (this.right == null) {
            r = null;
        } else {
            r = this.right.getValue(session);
            if (this.convertRight) {
                r = r.convertTo(this.dataType);
            }
        }
        switch (this.opType) {
            case NEGATE: {
                return l == ValueNull.INSTANCE ? l : l.negate();
            }
            case CONCAT: {
                Mode mode = session.getDatabase().getMode();
                if (l == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return r;
                }
                if (r == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return l;
                }
                String s1 = l.getString();
                String s2 = r.getString();
                StringBuilder buff = new StringBuilder(s1.length() + s2.length());
                buff.append(s1).append(s2);
                return ValueString.get(buff.toString());
            }
            case PLUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.add(r);
            }
            case MINUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.subtract(r);
            }
            case MULTIPLY: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.multiply(r);
            }
            case DIVIDE: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.divide(r);
            }
            case MODULUS: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.modulus(r);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.left.mapColumns(resolver, level);
        if (this.right != null) {
            this.right.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        switch (this.opType) {
            case NEGATE: {
                this.dataType = this.left.getType();
                if (this.dataType != -1) break;
                this.dataType = 6;
                break;
            }
            case CONCAT: {
                this.right = this.right.optimize(session);
                this.dataType = 13;
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                this.right = this.right.optimize(session);
                int l = this.left.getType();
                int r = this.right.getType();
                if (l == 0 && r == 0 || l == -1 && r == -1) {
                    if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.dataType = 13;
                        this.opType = OpType.CONCAT;
                        break;
                    }
                    this.dataType = 6;
                    break;
                }
                if (l == 10 || l == 11 || l == 9 || r == 10 || r == 11 || r == 9) {
                    if (this.opType == OpType.PLUS) {
                        if (r != Value.getHigherOrder(l, r)) {
                            this.swap();
                            int t = l;
                            l = r;
                            r = t;
                        }
                        if (l == 4) {
                            Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                            f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            f.setParameter(1, this.left);
                            f.setParameter(2, this.right);
                            f.doneWithParameters();
                            return f.optimize(session);
                        }
                        if (l == 6 || l == 8 || l == 7) {
                            Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                            f.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.left = new Operation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.left);
                            f.setParameter(1, this.left);
                            f.setParameter(2, this.right);
                            f.doneWithParameters();
                            return f.optimize(session);
                        }
                        if (l == 9 && r == 9) {
                            this.dataType = 9;
                            return this;
                        }
                        if (l == 9) {
                            this.dataType = 11;
                            return this;
                        }
                    } else if (this.opType == OpType.MINUS) {
                        if ((l == 10 || l == 11) && r == 4) {
                            Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                            f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            this.right = new Operation(OpType.NEGATE, this.right, null);
                            this.right = this.right.optimize(session);
                            f.setParameter(1, this.right);
                            f.setParameter(2, this.left);
                            f.doneWithParameters();
                            return f.optimize(session);
                        }
                        if (!(l != 10 && l != 11 || r != 6 && r != 8 && r != 7)) {
                            Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                            f.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.right = new Operation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.right);
                            this.right = new Operation(OpType.NEGATE, this.right, null);
                            this.right = this.right.optimize(session);
                            f.setParameter(1, this.right);
                            f.setParameter(2, this.left);
                            f.doneWithParameters();
                            return f.optimize(session);
                        }
                        if (l == 10 || l == 11) {
                            if (r == 9) {
                                this.dataType = 11;
                                return this;
                            }
                            if (r == 10 || r == 11) {
                                Function f = Function.getFunction(session.getDatabase(), "DATEDIFF");
                                f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                f.setParameter(1, this.right);
                                f.setParameter(2, this.left);
                                f.doneWithParameters();
                                return f.optimize(session);
                            }
                        } else if (l == 9 && r == 9) {
                            this.dataType = 9;
                            return this;
                        }
                    } else if (this.opType == OpType.MULTIPLY) {
                        if (l == 9) {
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                        if (r == 9) {
                            this.swap();
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                    } else if (this.opType == OpType.DIVIDE && l == 9) {
                        this.dataType = 9;
                        this.convertRight = false;
                        return this;
                    }
                    throw DbException.getUnsupportedException(DataType.getDataType((int)l).name + " " + this.getOperationToken() + " " + DataType.getDataType((int)r).name);
                }
                this.dataType = Value.getHigherOrder(l, r);
                if (!DataType.isStringType(this.dataType) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.opType = OpType.CONCAT;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private void swap() {
        Expression temp = this.left;
        this.left = this.right;
        this.right = temp;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public long getPrecision() {
        if (this.right != null) {
            switch (this.opType) {
                case CONCAT: {
                    return this.left.getPrecision() + this.right.getPrecision();
                }
            }
            return Math.max(this.left.getPrecision(), this.right.getPrecision());
        }
        return this.left.getPrecision();
    }

    @Override
    public int getDisplaySize() {
        if (this.right != null) {
            switch (this.opType) {
                case CONCAT: {
                    return MathUtils.convertLongToInt((long)this.left.getDisplaySize() + (long)this.right.getDisplaySize());
                }
            }
            return Math.max(this.left.getDisplaySize(), this.right.getDisplaySize());
        }
        return this.left.getDisplaySize();
    }

    @Override
    public int getScale() {
        if (this.right != null) {
            return Math.max(this.left.getScale(), this.right.getScale());
        }
        return this.left.getScale();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && (this.right == null || this.right.isEverything(visitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + (this.right == null ? 0 : this.right.getCost());
    }

    public static enum OpType {
        CONCAT,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        NEGATE,
        MODULUS;

    }
}

