/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Function;
import org.h2.expression.FunctionInfo;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.tools.SimpleResultSet;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class TableFunction
extends Function {
    private final boolean distinct;
    private final long rowCount;
    private Column[] columnList;

    TableFunction(Database database, FunctionInfo info, long rowCount) {
        super(database, info);
        this.distinct = info.type == 224;
        this.rowCount = rowCount;
    }

    @Override
    public Value getValue(Session session) {
        return this.getTable(session, this.args, false, this.distinct);
    }

    @Override
    protected void checkParameterCount(int len) {
        if (len < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder(this.getName());
        buff.append('(');
        int i = 0;
        for (Expression e : this.args) {
            buff.appendExceptFirst(", ");
            buff.append(this.columnList[i++].getCreateSQL()).append('=').append(e.getSQL());
        }
        return buff.append(')').toString();
    }

    @Override
    public String getName() {
        return this.distinct ? "TABLE_DISTINCT" : "TABLE";
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] nullArgs) {
        return this.getTable(session, this.args, true, false);
    }

    public void setColumns(ArrayList<Column> columns) {
        this.columnList = columns.toArray(new Column[0]);
    }

    private ValueResultSet getTable(Session session, Expression[] argList, boolean onlyColumnList, boolean distinctRows) {
        int len = this.columnList.length;
        Expression[] header = new Expression[len];
        Database db = session.getDatabase();
        for (int i = 0; i < len; ++i) {
            Column c = this.columnList[i];
            ExpressionColumn col = new ExpressionColumn(db, c);
            header[i] = col;
        }
        LocalResult result = new LocalResult(session, header, len);
        if (distinctRows) {
            result.setDistinct();
        }
        if (!onlyColumnList) {
            Value[] l;
            Value[][] list = new Value[len][];
            int rows = 0;
            for (int i = 0; i < len; ++i) {
                Value v = argList[i].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    list[i] = new Value[0];
                    continue;
                }
                ValueArray array = (ValueArray)v.convertTo(17);
                l = array.getList();
                list[i] = l;
                rows = Math.max(rows, l.length);
            }
            for (int row = 0; row < rows; ++row) {
                Value[] r = new Value[len];
                for (int j = 0; j < len; ++j) {
                    Value v;
                    l = list[j];
                    if (l.length <= row) {
                        v = ValueNull.INSTANCE;
                    } else {
                        Column c = this.columnList[j];
                        v = l[row];
                        v = c.convert(v);
                        v = v.convertPrecision(c.getPrecision(), false);
                        v = v.convertScale(true, c.getScale());
                    }
                    r[j] = v;
                }
                result.addRow(r);
            }
        }
        result.done();
        return ValueResultSet.get(TableFunction.getSimpleResultSet(result, Integer.MAX_VALUE));
    }

    private static SimpleResultSet getSimpleResultSet(LocalResult rs, int maxrows) {
        int i;
        int columnCount = rs.getVisibleColumnCount();
        SimpleResultSet simple = new SimpleResultSet();
        simple.setAutoClose(false);
        for (i = 0; i < columnCount; ++i) {
            String name = rs.getColumnName(i);
            int sqlType = DataType.convertTypeToSQLType(rs.getColumnType(i));
            int precision = MathUtils.convertLongToInt(rs.getColumnPrecision(i));
            int scale = rs.getColumnScale(i);
            simple.addColumn(name, sqlType, precision, scale);
        }
        rs.reset();
        for (i = 0; i < maxrows && rs.next(); ++i) {
            Object[] list = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                list[j] = rs.currentRow()[j].getObject();
            }
            simple.addRow(list);
        }
        return simple;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return TableFunction.getExpressionColumns(session, this.getTable(session, this.getArgs(), true, false).getResultSet());
    }
}

