/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.h2.fulltext.FullText;
import org.h2.fulltext.IndexInfo;
import org.h2.util.SoftHashMap;

final class FullTextSettings {
    private static final Map<String, FullTextSettings> SETTINGS = new HashMap<String, FullTextSettings>();
    private boolean initialized;
    private final Set<String> ignoreList = new HashSet<String>();
    private final Map<String, Integer> words = new HashMap<String, Integer>();
    private final Map<Integer, IndexInfo> indexes = Collections.synchronizedMap(new HashMap());
    private final SoftHashMap<Connection, SoftHashMap<String, PreparedStatement>> cache = new SoftHashMap();
    private String whitespaceChars = " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]<>\\";

    private FullTextSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIgnored() {
        Set<String> set = this.ignoreList;
        synchronized (set) {
            this.ignoreList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnored(Iterable<String> words) {
        Set<String> set = this.ignoreList;
        synchronized (set) {
            for (String word : words) {
                word = FullTextSettings.normalizeWord(word);
                this.ignoreList.add(word);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWordList() {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            this.words.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWordId(String word) {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            return this.words.get(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String word, Integer id) {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            if (!this.words.containsKey(word)) {
                this.words.put(word, id);
            }
        }
    }

    protected IndexInfo getIndexInfo(int indexId) {
        return this.indexes.get(indexId);
    }

    protected void addIndexInfo(IndexInfo index) {
        this.indexes.put(index.id, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertWord(String word) {
        word = FullTextSettings.normalizeWord(word);
        Set<String> set = this.ignoreList;
        synchronized (set) {
            if (this.ignoreList.contains(word)) {
                return null;
            }
        }
        return word;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FullTextSettings getInstance(Connection conn) throws SQLException {
        FullTextSettings setting;
        String path = FullTextSettings.getIndexPath(conn);
        Map<String, FullTextSettings> map = SETTINGS;
        synchronized (map) {
            setting = SETTINGS.get(path);
            if (setting == null) {
                setting = new FullTextSettings();
                SETTINGS.put(path, setting);
            }
        }
        return setting;
    }

    private static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        rs.next();
        String path = rs.getString(1);
        if ("MEM:UNNAMED".equals(path)) {
            throw FullText.throwException("Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        rs.close();
        return path;
    }

    protected synchronized PreparedStatement prepare(Connection conn, String sql) throws SQLException {
        PreparedStatement prep;
        SoftHashMap<String, PreparedStatement> c = this.cache.get(conn);
        if (c == null) {
            c = new SoftHashMap();
            this.cache.put(conn, c);
        }
        if ((prep = c.get(sql)) != null && prep.getConnection().isClosed()) {
            prep = null;
        }
        if (prep == null) {
            prep = conn.prepareStatement(sql);
            c.put(sql, prep);
        }
        return prep;
    }

    protected void removeAllIndexes() {
        this.indexes.clear();
    }

    protected void removeIndexInfo(IndexInfo index) {
        this.indexes.remove(index.id);
    }

    protected void setInitialized(boolean b) {
        this.initialized = b;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeAll() {
        Map<String, FullTextSettings> map = SETTINGS;
        synchronized (map) {
            SETTINGS.clear();
        }
    }

    protected void setWhitespaceChars(String whitespaceChars) {
        this.whitespaceChars = whitespaceChars;
    }

    protected String getWhitespaceChars() {
        return this.whitespaceChars;
    }

    private static String normalizeWord(String word) {
        return word.toUpperCase();
    }
}

