/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;

public class IndexCursor
implements Cursor {
    private Session session;
    private final TableFilter tableFilter;
    private Index index;
    private Table table;
    private IndexColumn[] indexColumns;
    private boolean alwaysFalse;
    private SearchRow start;
    private SearchRow end;
    private SearchRow intersects;
    private Cursor cursor;
    private Column inColumn;
    private int inListIndex;
    private Value[] inList;
    private ResultInterface inResult;
    private HashSet<Value> inResultTested;

    public IndexCursor(TableFilter filter) {
        this.tableFilter = filter;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.table = index.getTable();
        Column[] columns = this.table.getColumns();
        this.indexColumns = new IndexColumn[columns.length];
        IndexColumn[] idxCols = index.getIndexColumns();
        if (idxCols != null) {
            int len = columns.length;
            for (int i = 0; i < len; ++i) {
                int idx = index.getColumnIndex(columns[i]);
                if (idx < 0) continue;
                this.indexColumns[i] = idxCols[idx];
            }
        }
    }

    public void prepare(Session s, ArrayList<IndexCondition> indexConditions) {
        this.session = s;
        this.alwaysFalse = false;
        this.end = null;
        this.start = null;
        this.inList = null;
        this.inColumn = null;
        this.inResult = null;
        this.inResultTested = null;
        this.intersects = null;
        for (IndexCondition condition : indexConditions) {
            IndexColumn idxCol;
            if (condition.isAlwaysFalse()) {
                this.alwaysFalse = true;
                break;
            }
            if (this.index.isFindUsingFullTableScan()) continue;
            Column column = condition.getColumn();
            if (condition.getCompareType() == 9) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inList = condition.getCurrentValueList(s);
                this.inListIndex = 0;
                continue;
            }
            if (condition.getCompareType() == 10) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inResult = condition.getCurrentResult();
                continue;
            }
            Value v = condition.getCurrentValue(s);
            boolean isStart = condition.isStart();
            boolean isEnd = condition.isEnd();
            boolean isIntersects = condition.isSpatialIntersects();
            int columnId = column.getColumnId();
            if (columnId >= 0 && (idxCol = this.indexColumns[columnId]) != null && (idxCol.sortType & 1) != 0) {
                boolean temp = isStart;
                isStart = isEnd;
                isEnd = temp;
            }
            if (isStart) {
                this.start = this.getSearchRow(this.start, columnId, v, true);
            }
            if (isEnd) {
                this.end = this.getSearchRow(this.end, columnId, v, false);
            }
            if (isIntersects) {
                this.intersects = this.getSpatialSearchRow(this.intersects, columnId, v);
            }
            if ((isStart || isEnd) && !this.canUseIndexFor(this.inColumn)) {
                this.inColumn = null;
                this.inList = null;
                this.inResult = null;
            }
            if (this.session.getDatabase().getSettings().optimizeIsNull || !isStart || !isEnd || v != ValueNull.INSTANCE) continue;
            this.alwaysFalse = true;
        }
        if (this.inColumn != null) {
            this.start = this.table.getTemplateRow();
        }
    }

    public void find(Session s, ArrayList<IndexCondition> indexConditions) {
        this.prepare(s, indexConditions);
        if (this.inColumn != null) {
            return;
        }
        if (!this.alwaysFalse) {
            this.cursor = this.intersects != null && this.index instanceof SpatialIndex ? ((SpatialIndex)this.index).findByGeometry(this.tableFilter, this.start, this.end, this.intersects) : this.index.find(this.tableFilter, this.start, this.end);
        }
    }

    private boolean canUseIndexForIn(Column column) {
        if (this.inColumn != null) {
            return false;
        }
        return this.canUseIndexFor(column);
    }

    private boolean canUseIndexFor(Column column) {
        IndexColumn[] cols = this.index.getIndexColumns();
        if (cols == null) {
            return true;
        }
        IndexColumn idxCol = cols[0];
        return idxCol == null || idxCol.column == column;
    }

    private SearchRow getSpatialSearchRow(SearchRow row, int columnId, Value v) {
        if (row == null) {
            row = this.table.getTemplateRow();
        } else if (row.getValue(columnId) != null) {
            ValueGeometry vg = (ValueGeometry)row.getValue(columnId).convertTo(22);
            v = ((ValueGeometry)v.convertTo(22)).getEnvelopeUnion(vg);
        }
        if (columnId < 0) {
            row.setKey(v.getLong());
        } else {
            row.setValue(columnId, v);
        }
        return row;
    }

    private SearchRow getSearchRow(SearchRow row, int columnId, Value v, boolean max) {
        if (row == null) {
            row = this.table.getTemplateRow();
        } else {
            v = this.getMax(row.getValue(columnId), v, max);
        }
        if (columnId < 0) {
            row.setKey(v.getLong());
        } else {
            row.setValue(columnId, v);
        }
        return row;
    }

    private Value getMax(Value a, Value b, boolean bigger) {
        int comp;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (this.session.getDatabase().getSettings().optimizeIsNull) {
            if (a == ValueNull.INSTANCE) {
                return b;
            }
            if (b == ValueNull.INSTANCE) {
                return a;
            }
        }
        if ((comp = a.compareTo(b, this.table.getDatabase().getCompareMode())) == 0) {
            return a;
        }
        if ((a == ValueNull.INSTANCE || b == ValueNull.INSTANCE) && this.session.getDatabase().getSettings().optimizeIsNull) {
            return null;
        }
        if (!bigger) {
            comp = -comp;
        }
        return comp > 0 ? a : b;
    }

    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    public SearchRow getStart() {
        return this.start;
    }

    public SearchRow getEnd() {
        return this.end;
    }

    @Override
    public Row get() {
        if (this.cursor == null) {
            return null;
        }
        return this.cursor.get();
    }

    @Override
    public SearchRow getSearchRow() {
        return this.cursor.getSearchRow();
    }

    @Override
    public boolean next() {
        while (true) {
            if (this.cursor == null) {
                this.nextCursor();
                if (this.cursor == null) {
                    return false;
                }
            }
            if (this.cursor.next()) {
                return true;
            }
            this.cursor = null;
        }
    }

    private void nextCursor() {
        block3: {
            block4: {
                if (this.inList == null) break block4;
                while (this.inListIndex < this.inList.length) {
                    Value v;
                    if ((v = this.inList[this.inListIndex++]) == ValueNull.INSTANCE) continue;
                    this.find(v);
                    break block3;
                }
                break block3;
            }
            if (this.inResult == null) break block3;
            while (this.inResult.next()) {
                Value v = this.inResult.currentRow()[0];
                if (v == ValueNull.INSTANCE) continue;
                if (this.inResultTested == null) {
                    this.inResultTested = new HashSet();
                }
                if (!this.inResultTested.add(v)) continue;
                this.find(v);
                break;
            }
        }
    }

    private void find(Value v) {
        v = this.inColumn.convert(v);
        int id = this.inColumn.getColumnId();
        this.start.setValue(id, v);
        this.cursor = this.index.find(this.tableFilter, this.start, this.start);
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

