/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionCursor;
import org.h2.index.SpatialIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class MultiVersionIndex
implements Index {
    private final Index base;
    private final TreeIndex delta;
    private final RegularTable table;
    private final Object sync;
    private final Column firstColumn;

    public MultiVersionIndex(Index base, RegularTable table) {
        this.base = base;
        this.table = table;
        IndexType deltaIndexType = IndexType.createNonUnique(false);
        if (base instanceof SpatialIndex) {
            throw DbException.get(50100, "MVCC & spatial index");
        }
        this.delta = new TreeIndex(table, -1, "DELTA", base.getIndexColumns(), deltaIndexType);
        this.delta.setMultiVersion(true);
        this.sync = base.getDatabase();
        this.firstColumn = base.getColumns()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.base.add(session, row);
            if (!this.removeIfExists(session, row) && row.getSessionId() != 0) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.base.close(session);
        }
    }

    @Override
    public boolean isFindUsingFullTableScan() {
        return this.base.isFindUsingFullTableScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        Object object = this.sync;
        synchronized (object) {
            Cursor baseCursor = this.base.find(filter, first, last);
            Cursor deltaCursor = this.delta.find(filter, first, last);
            return new MultiVersionCursor(filter.getSession(), this, baseCursor, deltaCursor, this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        Object object = this.sync;
        synchronized (object) {
            Cursor baseCursor = this.base.find(session, first, last);
            Cursor deltaCursor = this.delta.find(session, first, last);
            return new MultiVersionCursor(session, this, baseCursor, deltaCursor, this.sync);
        }
    }

    @Override
    public Cursor findNext(Session session, SearchRow first, SearchRow last) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return this.base.canGetFirstOrLast() && this.delta.canGetFirstOrLast();
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        SearchRow row;
        if (first) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow row2 = cursor.getSearchRow();
                Value v = row2.getValue(this.firstColumn.getColumnId());
                if (v == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        Cursor baseCursor = this.base.findFirstOrLast(session, false);
        Cursor deltaCursor = this.delta.findFirstOrLast(session, false);
        MultiVersionCursor cursor = new MultiVersionCursor(session, this, baseCursor, deltaCursor, this.sync);
        cursor.loadCurrent();
        while (cursor.previous() && (row = cursor.getSearchRow()) != null) {
            Value v = row.getValue(this.firstColumn.getColumnId());
            if (v == ValueNull.INSTANCE) continue;
            return cursor;
        }
        return cursor;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return this.base.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
    }

    @Override
    public boolean needRebuild() {
        return this.base.needRebuild();
    }

    public boolean isUncommittedFromOtherSession(Session session, Row row) {
        Cursor c = this.delta.find(session, (SearchRow)row, (SearchRow)row);
        if (c.next()) {
            Row r = c.get();
            return r.getSessionId() != session.getId();
        }
        return false;
    }

    private boolean removeIfExists(Session session, Row row) {
        Cursor c = this.delta.find(session, (SearchRow)row, (SearchRow)row);
        while (c.next()) {
            Row r = c.get();
            if (r.getKey() != row.getKey() || r.getVersion() != row.getVersion()) continue;
            if (r != row && this.table.getScanIndex(session).compareRows(r, row) != 0) {
                row.setVersion(r.getVersion() + 1);
                continue;
            }
            this.delta.remove(session, r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session, row);
            if (!this.removeIfExists(session, row)) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.delta.truncate(session);
            this.base.truncate(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(int operation, Row row) {
        Object object = this.sync;
        synchronized (object) {
            this.removeIfExists(null, row);
        }
    }

    @Override
    public int compareRows(SearchRow rowData, SearchRow compare) {
        return this.base.compareRows(rowData, compare);
    }

    @Override
    public int getColumnIndex(Column col) {
        return this.base.getColumnIndex(col);
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.base.isFirstColumn(column);
    }

    @Override
    public Column[] getColumns() {
        return this.base.getColumns();
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.base.getIndexColumns();
    }

    @Override
    public String getCreateSQL() {
        return this.base.getCreateSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        return this.base.getCreateSQLForCopy(forTable, quotedName);
    }

    @Override
    public String getDropSQL() {
        return this.base.getDropSQL();
    }

    @Override
    public IndexType getIndexType() {
        return this.base.getIndexType();
    }

    @Override
    public String getPlanSQL() {
        return this.base.getPlanSQL();
    }

    @Override
    public long getRowCount(Session session) {
        return this.base.getRowCount(session);
    }

    @Override
    public Table getTable() {
        return this.base.getTable();
    }

    @Override
    public int getType() {
        return this.base.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildrenAndResources(Session session) {
        Object object = this.sync;
        synchronized (object) {
            this.table.removeIndex(this);
            this.remove(session);
        }
    }

    @Override
    public String getSQL() {
        return this.base.getSQL();
    }

    @Override
    public Schema getSchema() {
        return this.base.getSchema();
    }

    @Override
    public void checkRename() {
        this.base.checkRename();
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        return this.base.getChildren();
    }

    @Override
    public String getComment() {
        return this.base.getComment();
    }

    @Override
    public Database getDatabase() {
        return this.base.getDatabase();
    }

    @Override
    public int getId() {
        return this.base.getId();
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public boolean isTemporary() {
        return this.base.isTemporary();
    }

    @Override
    public void rename(String newName) {
        this.base.rename(newName);
    }

    @Override
    public void setComment(String comment) {
        this.base.setComment(comment);
    }

    @Override
    public void setTemporary(boolean temporary) {
        this.base.setTemporary(temporary);
    }

    @Override
    public long getRowCountApproximation() {
        return this.base.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.base.getDiskSpaceUsed();
    }

    public Index getBaseIndex() {
        return this.base;
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.base.getRow(session, key);
    }

    @Override
    public boolean isHidden() {
        return this.base.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return this.base.isRowIdIndex() && this.delta.isRowIdIndex();
    }

    @Override
    public boolean canScan() {
        return this.base.canScan();
    }

    @Override
    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.base.setSortedInsertMode(sortedInsertMode);
        this.delta.setSortedInsertMode(sortedInsertMode);
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        return null;
    }
}

