/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class SpatialTreeIndex
extends BaseIndex
implements SpatialIndex {
    private static final String MAP_PREFIX = "RTREE_";
    private final MVRTreeMap<Long> treeMap;
    private final MVStore store;
    private boolean closed;
    private boolean needRebuild;

    public SpatialTreeIndex(Table table, int id, String indexName, IndexColumn[] columns, IndexType indexType, boolean persistent, boolean create, Session session) {
        if (indexType.isUnique()) {
            throw DbException.getUnsupportedException("not unique");
        }
        if (!persistent && !create) {
            throw DbException.getUnsupportedException("Non persistent index called with create==false");
        }
        if (columns.length > 1) {
            throw DbException.getUnsupportedException("can only do one column");
        }
        if ((columns[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException("cannot do descending");
        }
        if ((columns[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls first");
        }
        if ((columns[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls last");
        }
        this.initBaseIndex(table, id, indexName, columns, indexType);
        this.needRebuild = create;
        this.table = table;
        if (!this.database.isStarting() && columns[0].column.getType() != 22) {
            throw DbException.getUnsupportedException("spatial index on non-geometry column, " + columns[0].column.getCreateSQL());
        }
        if (!persistent) {
            this.store = MVStore.open(null);
            this.treeMap = (MVRTreeMap)this.store.openMap("spatialIndex", new MVRTreeMap.Builder());
        } else {
            if (id < 0) {
                throw DbException.getUnsupportedException("Persistent index with id<0");
            }
            MVTableEngine.init(session.getDatabase());
            this.store = session.getDatabase().getMvStore().getStore();
            this.treeMap = (MVRTreeMap)this.store.openMap(MAP_PREFIX + this.getId(), new MVRTreeMap.Builder());
            if (this.treeMap.isEmpty()) {
                this.needRebuild = true;
            }
        }
    }

    @Override
    public void close(Session session) {
        this.store.close();
        this.closed = true;
    }

    @Override
    public void add(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.treeMap.add(this.getKey(row), row.getKey());
    }

    private SpatialKey getKey(SearchRow row) {
        if (row == null) {
            return null;
        }
        Value v = row.getValue(this.columnIds[0]);
        if (v == ValueNull.INSTANCE) {
            return null;
        }
        Geometry g = ((ValueGeometry)v.convertTo(22)).getGeometryNoCopy();
        Envelope env = g.getEnvelopeInternal();
        return new SpatialKey(row.getKey(), (float)env.getMinX(), (float)env.getMaxX(), (float)env.getMinY(), (float)env.getMaxY());
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (!this.treeMap.remove(this.getKey(row), row.getKey())) {
            throw DbException.throwInternalError("row not found");
        }
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        return new SpatialCursor(this.treeMap.keySet().iterator(), this.table, session);
    }

    @Override
    public Cursor findByGeometry(TableFilter filter, SearchRow first, SearchRow last, SearchRow intersection) {
        if (intersection == null) {
            return this.find(filter.getSession(), first, last);
        }
        return new SpatialCursor(this.treeMap.findIntersectingKeys(this.getKey(intersection)), this.table, filter.getSession());
    }

    public static long getCostRangeIndex(int[] masks, Column[] columns) {
        if (columns.length == 0) {
            return Long.MAX_VALUE;
        }
        for (Column column : columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 0x10) == 16) continue;
            return Long.MAX_VALUE;
        }
        return 2L;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return SpatialTreeIndex.getCostRangeIndex(masks, this.columns);
    }

    @Override
    public void remove(Session session) {
        if (!this.treeMap.isClosed()) {
            this.store.removeMap(this.treeMap);
        }
    }

    @Override
    public void truncate(Session session) {
        this.treeMap.clear();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return this.needRebuild;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        if (this.closed) {
            throw DbException.throwInternalError(this.toString());
        }
        if (!first) {
            throw DbException.throwInternalError("Spatial Index can only be fetch by ascending order");
        }
        return this.find(session);
    }

    @Override
    public long getRowCount(Session session) {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static final class SpatialCursor
    implements Cursor {
        private final Iterator<SpatialKey> it;
        private SpatialKey current;
        private final Table table;
        private Session session;

        public SpatialCursor(Iterator<SpatialKey> it, Table table, Session session) {
            this.it = it;
            this.table = table;
            this.session = session;
        }

        @Override
        public Row get() {
            return this.table.getRow(this.session, this.current.getId());
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.current = this.it.next();
            return true;
        }

        @Override
        public boolean previous() {
            return false;
        }
    }
}

