/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    Value value;
    private final JdbcConnection conn;

    public JdbcBlob(JdbcConnection conn, Value value, int id) {
        this.setTrace(conn.getSession().getTrace(), 9, id);
        this.conn = conn;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long precision;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (precision = this.value.getPrecision()) > 0L) {
                return precision;
            }
            return IOUtils.copyAndCloseInput(this.value.getInputStream(), null);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBytes(" + pos + ", " + length + ");");
            }
            this.checkClosed();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InputStream in = this.value.getInputStream();){
                IOUtils.skipFully(in, pos - 1L);
                IOUtils.copy(in, out, length);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + pos + ", " + JdbcBlob.quoteBytes(bytes) + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            this.value = this.conn.createBlob(new ByteArrayInputStream(bytes), -1L);
            return bytes.length;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + pos + ", " + JdbcBlob.quoteBytes(bytes) + ", " + offset + ", " + len + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            this.value = this.conn.createBlob(new ByteArrayInputStream(bytes, offset, len), -1L);
            return (int)this.value.getPrecision();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkClosed();
            return this.value.getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + pos + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection c = this.conn;
            final PipedInputStream in = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcBlob.this.value = c.createBlob(in, -1L);
                }
            };
            PipedOutputStream out = new PipedOutputStream(in){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception e) {
                        throw DbException.convertToIOException(e);
                    }
                }
            };
            task.execute();
            return new BufferedOutputStream(out);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(" + JdbcBlob.quoteBytes(pattern) + ", " + start + ");");
        }
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Blob blobPattern, long start) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(blobPattern, " + start + ");");
        }
        throw this.unsupported("LOB subset");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream(pos, length)");
            this.checkClosed();
            return this.value.getInputStream(pos, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

