/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.store.RangeReader;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements NClob {
    Value value;
    private final JdbcConnection conn;

    public JdbcClob(JdbcConnection conn, Value value, int id) {
        this.setTrace(conn.getSession().getTrace(), 10, id);
        this.conn = conn;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long precision;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 16 && (precision = this.value.getPrecision()) > 0L) {
                return precision;
            }
            return IOUtils.copyAndCloseInput(this.value.getReader(), null, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String s = this.value.getString();
            return IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setCharacterStream(" + pos + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection c = this.conn;
            final PipedInputStream in = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcClob.this.value = c.createClob(IOUtils.getReader(in), -1L);
                }
            };
            PipedOutputStream out = new PipedOutputStream(in){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception e) {
                        throw DbException.convertToIOException(e);
                    }
                }
            };
            task.execute();
            return IOUtils.getBufferedWriter(out);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSubString(" + pos + ", " + length + ");");
            }
            this.checkClosed();
            if (pos < 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (length < 0) {
                throw DbException.getInvalidValueException("length", length);
            }
            StringWriter writer = new StringWriter(Math.min(4096, length));
            try (Reader reader = this.value.getReader();){
                IOUtils.skipFully(reader, pos - 1L);
                IOUtils.copyAndCloseInput(reader, writer, length);
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + pos + ", " + JdbcClob.quote(str) + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (str == null) {
                throw DbException.getInvalidValueException("str", str);
            }
            this.value = this.conn.createClob(new StringReader(str), -1L);
            return str.length();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + pos + ", " + JdbcClob.quote(str) + ", " + offset + ", " + len + ");");
            }
            this.checkClosed();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (str == null) {
                throw DbException.getInvalidValueException("str", str);
            }
            this.value = this.conn.createClob(new RangeReader(new StringReader(str), offset, len), -1L);
            return (int)this.value.getPrecision();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long position(String pattern, long start) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Clob clobPattern, long start) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream(pos, length)");
            this.checkClosed();
            return this.value.getReader(pos, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

