/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public final class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final TransactionStore.TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        this.mvTable = table;
        this.initBaseIndex(table, id, indexName, columns, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(columns);
        }
        this.keyColumns = columns.length + 1;
        String mapName = "index." + this.getId();
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < columns.length; ++i) {
            sortTypes[i] = columns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(db.getCompareMode(), db, sortTypes);
        ValueDataType valueType = new ValueDataType(null, null, null);
        TransactionStore.Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(mapName, keyType, valueType);
        t.commit();
        if (!keyType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        MVMap<ValueArray, Value> map = this.openMap(bufferName);
        for (Row row : rows) {
            ValueArray key = this.convertToKey(row);
            map.put(key, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> bufferNames) {
        ArrayList<String> mapNames = new ArrayList<String>(bufferNames);
        CompareMode compareMode = this.database.getCompareMode();
        int buffersCount = bufferNames.size();
        PriorityQueue<Source> queue = new PriorityQueue<Source>(buffersCount, new Source.Comparator(compareMode));
        for (String bufferName : bufferNames) {
            Iterator<Object> iter = this.openMap(bufferName).keyIterator(null);
            if (!iter.hasNext()) continue;
            queue.add(new Source(iter));
        }
        try {
            while (!queue.isEmpty()) {
                Source s = (Source)queue.remove();
                ValueArray rowData = s.next();
                if (this.indexType.isUnique()) {
                    Value[] array = rowData.getList();
                    array = (Value[])array.clone();
                    array[this.keyColumns - 1] = ValueLong.MIN;
                    ValueArray unique = ValueArray.get(array);
                    SearchRow row = this.convertToSearchRow(rowData);
                    if (!this.mayHaveNullDuplicates(row)) {
                        this.requireUnique(row, this.dataMap, unique);
                    }
                }
                this.dataMap.putCommitted(rowData, ValueNull.INSTANCE);
                if (!s.hasNext()) continue;
                queue.offer(s);
            }
        }
        finally {
            for (String tempMapName : mapNames) {
                MVMap<ValueArray, Value> map = this.openMap(tempMapName);
                map.getStore().removeMap(map);
            }
        }
    }

    private MVMap<ValueArray, Value> openMap(String mapName) {
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            sortTypes[i] = this.indexColumns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(this.database.getCompareMode(), this.database, sortTypes);
        ValueDataType valueType = new ValueDataType(null, null, null);
        MVMap.Builder builder = new MVMap.Builder().keyType(keyType).valueType(valueType);
        Object map = this.database.getMvStore().getStore().openMap(mapName, builder);
        if (!keyType.equals(((MVMap)map).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
        return map;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        ValueArray array = this.convertToKey(row);
        ValueArray unique = null;
        if (this.indexType.isUnique()) {
            unique = this.convertToKey(row);
            unique.getList()[this.keyColumns - 1] = ValueLong.MIN;
            if (this.mayHaveNullDuplicates(row)) {
                unique = null;
            } else {
                this.requireUnique(row, map, unique);
            }
        }
        try {
            map.put(array, ValueNull.INSTANCE);
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (unique != null) {
            ValueArray k;
            Iterator<Value> it = map.keyIterator(unique, true);
            while (it.hasNext() && this.compareRows(row, this.convertToSearchRow(k = (ValueArray)it.next())) == 0) {
                if (map.isSameTransaction(k)) continue;
                if (map.get(k) != null) {
                    throw this.getDuplicateKeyException(k.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    private void requireUnique(SearchRow row, TransactionStore.TransactionMap<Value, Value> map, ValueArray unique) {
        ValueArray k;
        Value key = map.ceilingKey(unique);
        if (key != null && this.compareRows(row, this.convertToSearchRow(k = (ValueArray)key)) == 0) {
            throw this.getDuplicateKeyException(k.toString());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray array = this.convertToKey(row);
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value old = map.remove(array);
            if (old == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, false, last);
    }

    private Cursor find(Session session, SearchRow first, boolean bigger, SearchRow last) {
        TransactionStore.TransactionMap<Value, Value> map;
        ValueArray min;
        block8: {
            block9: {
                ValueArray v;
                block7: {
                    min = this.convertToKey(first);
                    if (min != null) {
                        min.getList()[this.keyColumns - 1] = ValueLong.MIN;
                    }
                    map = this.getMap(session);
                    if (!bigger || min == null) break block8;
                    int offset = 1;
                    while (true) {
                        if ((v = (ValueArray)map.relativeKey(min, offset)) != null) {
                            int idx;
                            Value b;
                            boolean foundHigher = false;
                            for (int i = 0; i < this.keyColumns - 1 && (b = first.getValue(idx = this.columnIds[i])) != null; ++i) {
                                Value a = v.getList()[i];
                                if (this.database.compare(a, b) <= 0) continue;
                                foundHigher = true;
                                break;
                            }
                            if (!foundHigher) {
                                offset += offset;
                                min = v;
                                continue;
                            }
                        }
                        if (offset > 1) {
                            offset /= 2;
                            continue;
                        }
                        if (map.get(v) != null) break block7;
                        if ((min = (ValueArray)map.higherKey(min)) == null) break;
                    }
                    break block9;
                }
                min = v;
            }
            if (min == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
        }
        return new MVStoreCursor(session, map.keyIterator(min), last);
    }

    private ValueArray convertToKey(SearchRow r) {
        if (r == null) {
            return null;
        }
        Value[] array = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            int idx = c.getColumnId();
            Value v = r.getValue(idx);
            if (v == null) continue;
            array[i] = v.convertTo(c.getType());
        }
        array[this.keyColumns - 1] = ValueLong.get(r.getKey());
        return ValueArray.get(array);
    }

    SearchRow convertToSearchRow(ValueArray key) {
        Value[] array = key.getList();
        Row searchRow = this.mvTable.getTemplateRow();
        searchRow.setKey(array[array.length - 1].getLong());
        Column[] cols = this.getColumns();
        for (int i = 0; i < array.length - 1; ++i) {
            Column c = cols[i];
            int idx = c.getColumnId();
            Value v = array[i];
            searchRow.setValue(idx, v);
        }
        return searchRow;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, false, allColumnsSet);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            TransactionStore.Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        Value key;
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        Value value = key = first ? map.firstKey() : map.lastKey();
        while (true) {
            if (key == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (((ValueArray)key).getList()[0] != ValueNull.INSTANCE) break;
            key = first ? map.higherKey(key) : map.lowerKey(key);
        }
        ArrayList list = New.arrayList();
        list.add(key);
        MVStoreCursor cursor = new MVStoreCursor(session, list.iterator(), null);
        cursor.next();
        return cursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        return this.find(session, higherThan, true, last);
    }

    @Override
    public void checkRename() {
    }

    private TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t, Long.MAX_VALUE);
    }

    final class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private final SearchRow last;
        private Value current;
        private SearchRow searchRow;
        private Row row;

        MVStoreCursor(Session session, Iterator<Value> it, SearchRow last) {
            this.session = session;
            this.it = it;
            this.last = last;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.convertToSearchRow((ValueArray)this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<ValueArray> iterator;
        ValueArray currentRowData;

        public Source(Iterator<ValueArray> iterator) {
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean result = this.iterator.hasNext();
            if (result) {
                this.currentRowData = this.iterator.next();
            }
            return result;
        }

        public ValueArray next() {
            return this.currentRowData;
        }

        public static final class Comparator
        implements java.util.Comparator<Source> {
            private final CompareMode compareMode;

            public Comparator(CompareMode compareMode) {
                this.compareMode = compareMode;
            }

            @Override
            public int compare(Source one, Source two) {
                return one.currentRowData.compareTo(two.currentRowData, this.compareMode);
            }
        }
    }
}

