/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.db.MVDelegateIndex;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.mvstore.db.MVSecondaryIndex;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.mvstore.db.TransactionStore;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableType;
import org.h2.util.DebuggingThreadLocal;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.DataType;

public class MVTable
extends TableBase {
    public static final DebuggingThreadLocal<String> WAITING_FOR_LOCK;
    public static final DebuggingThreadLocal<ArrayList<String>> EXCLUSIVE_LOCKS;
    public static final DebuggingThreadLocal<ArrayList<String>> SHARED_LOCKS;
    private static final String NO_EXTRA_INFO = "";
    private MVPrimaryIndex primaryIndex;
    private final ArrayList<Index> indexes = New.arrayList();
    private volatile long lastModificationId;
    private volatile Session lockExclusiveSession;
    private final ConcurrentHashMap<Session, Session> lockSharedSessions = new ConcurrentHashMap();
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private final boolean containsLargeObject;
    private Column rowIdColumn;
    private final MVTableEngine.Store store;
    private final TransactionStore transactionStore;

    public MVTable(CreateTableData data, MVTableEngine.Store store) {
        super(data);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.store = store;
        this.transactionStore = store.getTransactionStore();
        this.isHidden = data.isHidden;
        boolean b = false;
        for (Column col : this.getColumns()) {
            if (!DataType.isLargeObject(col.getType())) continue;
            b = true;
            break;
        }
        this.containsLargeObject = b;
        this.traceLock = this.database.getTrace(7);
    }

    void init(Session session) {
        this.primaryIndex = new MVPrimaryIndex(session.getDatabase(), this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        int lockMode = this.database.getLockMode();
        if (lockMode == 0) {
            return false;
        }
        if (!forceLockEvenInMvcc && this.database.isMultiVersion()) {
            if (exclusive) {
                exclusive = false;
            } else if (this.lockExclusiveSession == null) {
                return false;
            }
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (!exclusive && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        Object object = this.getLockSyncObject();
        synchronized (object) {
            if (!exclusive && this.lockSharedSessions.containsKey(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                WAITING_FOR_LOCK.set(this.getName());
            }
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, lockMode, exclusive);
            }
            finally {
                session.setWaitForLock(null, null);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    WAITING_FOR_LOCK.remove();
                }
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private Object getLockSyncObject() {
        if (this.database.isMultiThreaded()) {
            return this;
        }
        return this.database;
    }

    private void doLock1(Session session, int lockMode, boolean exclusive) {
        this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_REQUESTING_FOR, NO_EXTRA_INFO);
        long max = 0L;
        boolean checkDeadlock = false;
        while (this.waitingSessions.getFirst() != session || !this.doLock2(session, lockMode, exclusive)) {
            if (checkDeadlock) {
                ArrayList<Session> sessions = this.checkDeadlock(session, null, null);
                if (sessions != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(sessions, exclusive));
                }
            } else {
                checkDeadlock = true;
            }
            long now = System.nanoTime();
            if (max == 0L) {
                max = now + TimeUnit.MILLISECONDS.toNanos(session.getLockTimeout());
            } else if (now >= max) {
                this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_TIMEOUT_AFTER, NO_EXTRA_INFO + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long sleep;
                this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_WAITING_FOR, NO_EXTRA_INFO);
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long free = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long free2 = Runtime.getRuntime().freeMemory();
                        if (free == free2) break;
                    }
                }
                if ((sleep = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(max - now))) == 0L) {
                    sleep = 1L;
                }
                this.getLockSyncObject().wait(sleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session, int lockMode, boolean exclusive) {
        if (exclusive) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_ADDED_FOR, NO_EXTRA_INFO);
                    session.addLock(this);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_ADD_UPGRADED_FOR, NO_EXTRA_INFO);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (lockMode == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                return true;
            }
            if (!this.lockSharedSessions.containsKey(session)) {
                this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_OK, NO_EXTRA_INFO);
                session.addLock(this);
                this.lockSharedSessions.put(session, session);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    if (SHARED_LOCKS.get() == null) {
                        SHARED_LOCKS.set(new ArrayList());
                    }
                    SHARED_LOCKS.get().add(this.getName());
                }
            }
            return true;
        }
        return false;
    }

    private static String getDeadlockDetails(ArrayList<Session> sessions, boolean exclusive) {
        StringBuilder buff = new StringBuilder();
        for (Session s : sessions) {
            Table lock = s.getWaitForLock();
            Thread thread = s.getWaitForLockThread();
            buff.append("\nSession ").append(s.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(lock.toString()).append(exclusive ? " (exclusive)" : " (shared)").append(" while locking ");
            int i = 0;
            for (Table t : s.getLocks()) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(t.toString());
                if (!(t instanceof MVTable)) continue;
                if (((MVTable)t).lockExclusiveSession == s) {
                    buff.append(" (exclusive)");
                    continue;
                }
                buff.append(" (shared)");
            }
            buff.append('.');
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session clash, Set<Session> visited) {
        Class<MVTable> clazz = MVTable.class;
        synchronized (MVTable.class) {
            Table t;
            if (clash == null) {
                clash = session;
                visited = new HashSet<Session>();
            } else {
                if (clash == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (visited.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            visited.add(session);
            ArrayList<Session> error = null;
            for (Session s : this.lockSharedSessions.keySet()) {
                Table t2;
                if (s == session || (t2 = s.getWaitForLock()) == null || (error = t2.checkDeadlock(s, clash, visited)) == null) continue;
                error.add(session);
                break;
            }
            Session copyOfLockExclusiveSession = this.lockExclusiveSession;
            if (error == null && copyOfLockExclusiveSession != null && (t = copyOfLockExclusiveSession.getWaitForLock()) != null && (error = t.checkDeadlock(copyOfLockExclusiveSession, clash, visited)) != null) {
                error.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return error;
        }
    }

    private void traceLock(Session session, boolean exclusive, TraceLockEvent eventEnum, String extraInfo) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3} {4}", session.getId(), exclusive ? "exclusive write lock" : "shared read lock", eventEnum.getEventText(), this.getName(), extraInfo);
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusiveSession == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session s) {
        if (this.database != null) {
            this.traceLock(s, this.lockExclusiveSession == s, TraceLockEvent.TRACE_LOCK_UNLOCK, NO_EXTRA_INFO);
            if (this.lockExclusiveSession == s) {
                this.lockSharedSessions.remove(s);
                this.lockExclusiveSession = null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && EXCLUSIVE_LOCKS.get() != null) {
                    EXCLUSIVE_LOCKS.get().remove(this.getName());
                }
            }
            Object object = this.getLockSyncObject();
            synchronized (object) {
                if (this.lockSharedSessions.size() > 0) {
                    this.lockSharedSessions.remove(s);
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR && SHARED_LOCKS.get() != null) {
                        SHARED_LOCKS.get().remove(this.getName());
                    }
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.getLockSyncObject().notifyAll();
                }
            }
        }
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> constraints;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (constraints = this.getConstraints()) != null) {
            for (Constraint c : constraints) {
                ConstraintReferential ref;
                if (c.getConstraintType() != Constraint.Type.REFERENTIAL || (ref = (ConstraintReferential)c).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.primaryIndex.getRow(session, key);
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        BaseIndex index;
        boolean isSessionTemporary;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn c : cols) {
                Column column = c.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        int mainIndexColumn = this.getMainIndexColumn(indexType, cols);
        if (this.database.isStarting()) {
            if (this.transactionStore.store.hasMap("index." + indexId)) {
                mainIndexColumn = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            mainIndexColumn = -1;
        }
        if (mainIndexColumn != -1) {
            this.primaryIndex.setMainIndexColumn(mainIndexColumn);
            index = new MVDelegateIndex(this, indexId, indexName, this.primaryIndex, indexType);
        } else {
            index = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), this, indexId, indexName, cols, indexType) : new MVSecondaryIndex(session.getDatabase(), this, indexId, indexName, cols, indexType);
        }
        if (index.needRebuild()) {
            this.rebuildIndex(session, (MVIndex)((Object)index), indexName);
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private void rebuildIndex(Session session, MVIndex index, String indexName) {
        try {
            if (session.getDatabase().getMvStore() == null || index instanceof MVSpatialIndex) {
                this.rebuildIndexBuffered(session, index);
            } else {
                this.rebuildIndexBlockMerge(session, index);
            }
        }
        catch (DbException e) {
            this.getSchema().freeUniqueName(indexName);
            try {
                index.remove(session);
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not remove index");
                throw e2;
            }
            throw e;
        }
    }

    private void rebuildIndexBlockMerge(Session session, MVIndex index) {
        long remaining;
        if (index instanceof MVSpatialIndex) {
            this.rebuildIndexBuffered(session, index);
        }
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        MVTableEngine.Store store = session.getDatabase().getMvStore();
        int bufferSize = this.database.getMaxMemoryRows() / 2;
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ":" + index.getName();
        int t = MathUtils.convertLongToInt(total);
        ArrayList<String> bufferNames = New.arrayList();
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t);
            if (buffer.size() >= bufferSize) {
                MVTable.sortRows(buffer, index);
                String mapName = store.nextTemporaryMapName();
                index.addRowsToBuffer(buffer, mapName);
                bufferNames.add(mapName);
                buffer.clear();
            }
            --remaining;
        }
        MVTable.sortRows(buffer, index);
        if (!bufferNames.isEmpty()) {
            String mapName = store.nextTemporaryMapName();
            index.addRowsToBuffer(buffer, mapName);
            bufferNames.add(mapName);
            buffer.clear();
            index.addBufferedRows(bufferNames);
        } else {
            MVTable.addRowsToIndex(session, buffer, index);
        }
        if (SysProperties.CHECK && remaining != 0L) {
            DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
        }
    }

    private void rebuildIndexBuffered(Session session, Index index) {
        long remaining;
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        int bufferSize = (int)Math.min(total, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ":" + index.getName();
        int t = MathUtils.convertLongToInt(total);
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t);
            if (buffer.size() >= bufferSize) {
                MVTable.addRowsToIndex(session, buffer, index);
            }
            --remaining;
        }
        MVTable.addRowsToIndex(session, buffer, index);
        if (SysProperties.CHECK && remaining != 0L) {
            DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
        }
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] cols) {
        if (this.primaryIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || cols.length != 1) {
            return -1;
        }
        IndexColumn first = cols[0];
        if (first.sortType != 0) {
            return -1;
        }
        switch (first.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return first.column.getColumnId();
    }

    private static void addRowsToIndex(Session session, ArrayList<Row> list, Index index) {
        MVTable.sortRows(list, index);
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    private static void sortRows(ArrayList<Row> list, final Index index) {
        Collections.sort(list, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return index.compareRows(r1, r2);
            }
        });
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
            }
        }
        catch (Throwable e) {
            t.rollbackToSavepoint(savepoint);
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.changesSinceAnalyze = 0;
    }

    @Override
    public void addRow(Session session, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.add(session, row);
            }
        }
        catch (Throwable e) {
            t.rollbackToSavepoint(savepoint);
            DbException de = DbException.convert(e);
            if (de.getErrorCode() == 23505) {
                for (Index index : this.indexes) {
                    MultiVersionIndex mv;
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(mv = (MultiVersionIndex)index).isUncommittedFromOtherSession(session, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw de;
        }
        this.analyzeIfRequired(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeIfRequired(Session session) {
        MVTable mVTable = this;
        synchronized (mVTable) {
            if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
                return;
            }
            this.changesSinceAnalyze = 0;
            int n = 2 * this.nextAnalyze;
            if (n > 0) {
                this.nextAnalyze = n;
            }
        }
        session.markTableForAnalyze(this);
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.primaryIndex;
    }

    @Override
    public Index getUniqueIndex() {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        this.database.getMvStore().removeTable(this);
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)obj;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.primaryIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.close(session);
        this.invalidate();
    }

    @Override
    public long getRowCount(Session session) {
        return this.primaryIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.primaryIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.Transaction getTransactionBegin() {
        return this.transactionStore.begin();
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public boolean isMVStore() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.lastModificationId = this.database.getNextModificationDataId();
        }
    }

    DbException convertException(IllegalStateException e) {
        if (DataUtils.getErrorCode(e.getMessage()) == 101) {
            throw DbException.get(90131, e, this.getName());
        }
        return this.store.convertIllegalStateException(e);
    }

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            WAITING_FOR_LOCK = new DebuggingThreadLocal();
            EXCLUSIVE_LOCKS = new DebuggingThreadLocal();
            SHARED_LOCKS = new DebuggingThreadLocal();
        } else {
            WAITING_FOR_LOCK = null;
            EXCLUSIVE_LOCKS = null;
            SHARED_LOCKS = null;
        }
    }

    private static enum TraceLockEvent {
        TRACE_LOCK_OK("ok"),
        TRACE_LOCK_WAITING_FOR("waiting for"),
        TRACE_LOCK_REQUESTING_FOR("requesting for"),
        TRACE_LOCK_TIMEOUT_AFTER("timeout after "),
        TRACE_LOCK_UNLOCK("unlock"),
        TRACE_LOCK_ADDED_FOR("added for"),
        TRACE_LOCK_ADD_UPGRADED_FOR("add (upgraded) for ");

        private final String eventText;

        private TraceLockEvent(String eventText) {
            this.eventText = eventText;
        }

        public String getEventText() {
            return this.eventText;
        }
    }
}

