/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class TransactionStore {
    final MVStore store;
    final MVMap<Integer, Object[]> preparedTransactions;
    final MVMap<Long, Object[]> undoLog;
    final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final HashMap<Integer, MVMap<Object, VersionedValue>> maps = new HashMap();
    private final DataType dataType;
    private final BitSet openTransactions = new BitSet();
    private boolean init;
    private int maxTransactionId = 65535;
    private int nextTempMapId;

    public TransactionStore(MVStore store) {
        this(store, new ObjectDataType());
    }

    public TransactionStore(MVStore store, DataType dataType) {
        this.store = store;
        this.dataType = dataType;
        this.preparedTransactions = store.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType oldValueType = new VersionedValueType(dataType);
        ArrayType undoLogValueType = new ArrayType(new DataType[]{new ObjectDataType(), dataType, oldValueType});
        MVMap.Builder builder = new MVMap.Builder().valueType(undoLogValueType);
        this.undoLog = store.openMap("undoLog", builder);
        if (this.undoLog.getValueType() != undoLogValueType) {
            throw DataUtils.newIllegalStateException(100, "Undo map open with a different value type", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        this.init = true;
        for (String mapName : this.store.getMapNames()) {
            if (!mapName.startsWith("temp.")) continue;
            MVMap<Object, Integer> temp = this.openTempMap(mapName);
            this.store.removeMap(temp);
        }
        this.rwLock.writeLock().lock();
        try {
            if (this.undoLog.size() > 0) {
                for (Long key : this.undoLog.keySet()) {
                    int transactionId = TransactionStore.getTransactionId(key);
                    this.openTransactions.set(transactionId);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void setMaxTransactionId(int max) {
        this.maxTransactionId = max;
    }

    static long getOperationId(int transactionId, long logId) {
        DataUtils.checkArgument(transactionId >= 0 && transactionId < 0x1000000, "Transaction id out of range: {0}", transactionId);
        DataUtils.checkArgument(logId >= 0L && logId < 0x10000000000L, "Transaction log id out of range: {0}", logId);
        return (long)transactionId << 40 | logId;
    }

    static int getTransactionId(long operationId) {
        return (int)(operationId >>> 40);
    }

    static long getLogId(long operationId) {
        return operationId & 0xFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getOpenTransactions() {
        this.rwLock.readLock().lock();
        try {
            ArrayList<Transaction> list = New.arrayList();
            Long key = this.undoLog.firstKey();
            while (key != null) {
                String name;
                int status;
                int transactionId = TransactionStore.getTransactionId(key);
                key = this.undoLog.lowerKey(TransactionStore.getOperationId(transactionId + 1, 0L));
                long logId = TransactionStore.getLogId(key) + 1L;
                Object[] data = this.preparedTransactions.get(transactionId);
                if (data == null) {
                    status = this.undoLog.containsKey(TransactionStore.getOperationId(transactionId, 0L)) ? 1 : 3;
                    name = null;
                } else {
                    status = (Integer)data[0];
                    name = (String)data[1];
                }
                Transaction t = new Transaction(this, transactionId, status, name, logId);
                list.add(t);
                key = this.undoLog.ceilingKey(TransactionStore.getOperationId(transactionId + 1, 0L));
            }
            ArrayList<Transaction> arrayList = list;
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public synchronized void close() {
        this.store.commit();
    }

    public synchronized Transaction begin() {
        if (!this.init) {
            throw DataUtils.newIllegalStateException(103, "Not initialized", new Object[0]);
        }
        int transactionId = this.openTransactions.nextClearBit(1);
        if (transactionId > this.maxTransactionId) {
            throw DataUtils.newIllegalStateException(102, "There are {0} open transactions", transactionId - 1);
        }
        this.openTransactions.set(transactionId);
        int status = 1;
        return new Transaction(this, transactionId, status, null, 0L);
    }

    synchronized void storeTransaction(Transaction t) {
        if (t.getStatus() == 2 || t.getName() != null) {
            Object[] v = new Object[]{t.getStatus(), t.getName()};
            this.preparedTransactions.put(t.getId(), v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Transaction t, long logId, int mapId, Object key, Object oldValue) {
        Long undoKey = TransactionStore.getOperationId(t.getId(), logId);
        Object[] log = new Object[]{mapId, key, oldValue};
        this.rwLock.writeLock().lock();
        try {
            if (logId == 0L && this.undoLog.containsKey(undoKey)) {
                throw DataUtils.newIllegalStateException(102, "An old transaction with the same id is still open: {0}", t.getId());
            }
            this.undoLog.put(undoKey, log);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUndo(Transaction t, long logId) {
        Long undoKey = TransactionStore.getOperationId(t.getId(), logId);
        this.rwLock.writeLock().lock();
        try {
            Object[] old = this.undoLog.remove(undoKey);
            if (old == null) {
                throw DataUtils.newIllegalStateException(103, "Transaction {0} was concurrently rolled back", t.getId());
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    synchronized <K, V> void removeMap(TransactionMap<K, V> map) {
        this.maps.remove(map.mapId);
        this.store.removeMap(map.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction t, long maxLogId) {
        if (this.store.isClosed()) {
            return;
        }
        this.rwLock.writeLock().lock();
        int oldStatus = t.getStatus();
        try {
            t.setStatus(3);
            for (long logId = 0L; logId < maxLogId; ++logId) {
                Object key;
                VersionedValue value;
                Long undoKey = TransactionStore.getOperationId(t.getId(), logId);
                Object[] op = this.undoLog.get(undoKey);
                if (op == null) {
                    if ((undoKey = this.undoLog.ceilingKey(undoKey)) == null) break;
                    if (TransactionStore.getTransactionId(undoKey) != t.getId()) {
                        break;
                    }
                    logId = TransactionStore.getLogId(undoKey) - 1L;
                    continue;
                }
                int mapId = (Integer)op[0];
                MVMap<Object, VersionedValue> map = this.openMap(mapId);
                if (map != null && (value = map.get(key = op[1])) != null && value.operationId == undoKey) {
                    if (value.value == null) {
                        map.remove(key);
                    } else {
                        map.put(key, new VersionedValue(0L, value.value));
                    }
                }
                this.undoLog.remove(undoKey);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.endTransaction(t, oldStatus);
    }

    synchronized <K> MVMap<K, VersionedValue> openMap(String name, DataType keyType, DataType valueType) {
        Object map;
        if (keyType == null) {
            keyType = new ObjectDataType();
        }
        if (valueType == null) {
            valueType = new ObjectDataType();
        }
        VersionedValueType vt = new VersionedValueType(valueType);
        MVMap.Builder builder = new MVMap.Builder().keyType(keyType).valueType(vt);
        Object m = map = this.store.openMap(name, builder);
        this.maps.put(((MVMap)map).getId(), (MVMap<Object, VersionedValue>)m);
        return map;
    }

    synchronized MVMap<Object, VersionedValue> openMap(int mapId) {
        MVMap<Object, VersionedValue> map = this.maps.get(mapId);
        if (map != null) {
            return map;
        }
        String mapName = this.store.getMapName(mapId);
        if (mapName == null) {
            return null;
        }
        VersionedValueType vt = new VersionedValueType(this.dataType);
        MVMap.Builder mapBuilder = new MVMap.Builder().keyType(this.dataType).valueType(vt);
        map = this.store.openMap(mapName, mapBuilder);
        this.maps.put(mapId, map);
        return map;
    }

    synchronized MVMap<Object, Integer> createTempMap() {
        String mapName = "temp." + this.nextTempMapId++;
        return this.openTempMap(mapName);
    }

    MVMap<Object, Integer> openTempMap(String mapName) {
        MVMap.Builder mapBuilder = new MVMap.Builder().keyType(this.dataType);
        return this.store.openMap(mapName, mapBuilder);
    }

    synchronized void endTransaction(Transaction t, int oldStatus) {
        int max;
        int unsaved;
        if (oldStatus == 2) {
            this.preparedTransactions.remove(t.getId());
        }
        t.setStatus(0);
        this.openTransactions.clear(t.transactionId);
        if (oldStatus == 2 || this.store.getAutoCommitDelay() == 0) {
            this.store.commit();
            return;
        }
        if (this.undoLog.isEmpty() && (unsaved = this.store.getUnsavedMemory()) * 4 > (max = this.store.getAutoCommitMemory()) * 3) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackTo(Transaction t, long maxLogId, long toLogId) {
        this.rwLock.writeLock().lock();
        try {
            for (long logId = maxLogId - 1L; logId >= toLogId; --logId) {
                Long undoKey = TransactionStore.getOperationId(t.getId(), logId);
                Object[] op = this.undoLog.get(undoKey);
                if (op == null) {
                    if ((undoKey = this.undoLog.floorKey(undoKey)) == null) break;
                    if (TransactionStore.getTransactionId(undoKey) != t.getId()) {
                        break;
                    }
                    logId = TransactionStore.getLogId(undoKey) + 1L;
                    continue;
                }
                int mapId = (Integer)op[0];
                MVMap<Object, VersionedValue> map = this.openMap(mapId);
                if (map != null) {
                    Object key = op[1];
                    VersionedValue oldValue = (VersionedValue)op[2];
                    if (oldValue == null) {
                        map.remove(key);
                    } else {
                        map.put(key, oldValue);
                    }
                }
                this.undoLog.remove(undoKey);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    Iterator<Change> getChanges(final Transaction t, final long maxLogId, final long toLogId) {
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = maxLogId - 1L;
                this.fetchNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNext() {
                TransactionStore.this.rwLock.writeLock().lock();
                try {
                    while (this.logId >= toLogId) {
                        Long undoKey = TransactionStore.getOperationId(t.getId(), this.logId);
                        Object[] op = TransactionStore.this.undoLog.get(undoKey);
                        --this.logId;
                        if (op == null) {
                            if ((undoKey = TransactionStore.this.undoLog.floorKey(undoKey)) == null) break;
                            if (TransactionStore.getTransactionId(undoKey) != t.getId()) {
                                break;
                            }
                            this.logId = TransactionStore.getLogId(undoKey);
                            continue;
                        }
                        int mapId = (Integer)op[0];
                        MVMap<Object, VersionedValue> m = TransactionStore.this.openMap(mapId);
                        if (m == null) continue;
                        this.current = new Change();
                        this.current.mapName = m.getName();
                        this.current.key = op[1];
                        VersionedValue oldValue = (VersionedValue)op[2];
                        this.current.value = oldValue == null ? null : oldValue.value;
                        return;
                    }
                }
                finally {
                    TransactionStore.this.rwLock.writeLock().unlock();
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Change next() {
                if (this.current == null) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change result = this.current;
                this.fetchNext();
                return result;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] elementTypes) {
            this.arrayLength = elementTypes.length;
            this.elementTypes = elementTypes;
        }

        @Override
        public int getMemory(Object obj) {
            Object[] array = (Object[])obj;
            int size = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                Object o = array[i];
                if (o == null) continue;
                size += t.getMemory(o);
            }
            return size;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == bObj) {
                return 0;
            }
            Object[] a = (Object[])aObj;
            Object[] b = (Object[])bObj;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                int comp = t.compare(a[i], b[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }

        @Override
        public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                obj[i] = this.read(buff);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                this.write(buff, obj[i]);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            Object[] array = (Object[])obj;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                Object o = array[i];
                if (o == null) {
                    buff.put((byte)0);
                    continue;
                }
                buff.put((byte)1);
                t.write(buff, o);
            }
        }

        @Override
        public Object read(ByteBuffer buff) {
            Object[] array = new Object[this.arrayLength];
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                if (buff.get() != 1) continue;
                array[i] = t.read(buff);
            }
            return array;
        }
    }

    public static class VersionedValueType
    implements DataType {
        private final DataType valueType;

        VersionedValueType(DataType valueType) {
            this.valueType = valueType;
        }

        @Override
        public int getMemory(Object obj) {
            VersionedValue v = (VersionedValue)obj;
            return this.valueType.getMemory(v.value) + 8;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == bObj) {
                return 0;
            }
            VersionedValue a = (VersionedValue)aObj;
            VersionedValue b = (VersionedValue)bObj;
            long comp = a.operationId - b.operationId;
            if (comp == 0L) {
                return this.valueType.compare(a.value, b.value);
            }
            return Long.signum(comp);
        }

        @Override
        public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
            if (buff.get() == 0) {
                for (int i = 0; i < len; ++i) {
                    obj[i] = new VersionedValue(0L, this.valueType.read(buff));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    obj[i] = this.read(buff);
                }
            }
        }

        @Override
        public Object read(ByteBuffer buff) {
            long operationId = DataUtils.readVarLong(buff);
            Object value = buff.get() == 1 ? this.valueType.read(buff) : null;
            return new VersionedValue(operationId, value);
        }

        @Override
        public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
            VersionedValue v;
            int i;
            boolean fastPath = true;
            for (i = 0; i < len; ++i) {
                v = (VersionedValue)obj[i];
                if (v.operationId == 0L && v.value != null) continue;
                fastPath = false;
            }
            if (fastPath) {
                buff.put((byte)0);
                for (i = 0; i < len; ++i) {
                    v = (VersionedValue)obj[i];
                    this.valueType.write(buff, v.value);
                }
            } else {
                buff.put((byte)1);
                for (i = 0; i < len; ++i) {
                    this.write(buff, obj[i]);
                }
            }
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            VersionedValue v = (VersionedValue)obj;
            buff.putVarLong(v.operationId);
            if (v.value == null) {
                buff.put((byte)0);
            } else {
                buff.put((byte)1);
                this.valueType.write(buff, v.value);
            }
        }
    }

    static class VersionedValue {
        final long operationId;
        final Object value;

        VersionedValue(long operationId, Object value) {
            this.operationId = operationId;
            this.value = value;
        }

        public String toString() {
            return this.value + (this.operationId == 0L ? "" : " " + TransactionStore.getTransactionId(this.operationId) + "/" + TransactionStore.getLogId(this.operationId));
        }
    }

    public static class TransactionMap<K, V> {
        final int mapId;
        long readLogId = Long.MAX_VALUE;
        final MVMap<K, VersionedValue> map;
        final Transaction transaction;

        TransactionMap(Transaction transaction, MVMap<K, VersionedValue> map, int mapId) {
            this.transaction = transaction;
            this.map = map;
            this.mapId = mapId;
        }

        public void setSavepoint(long savepoint) {
            this.readLogId = savepoint;
        }

        public TransactionMap<K, V> getInstance(Transaction transaction, long savepoint) {
            TransactionMap<K, V> m = new TransactionMap<K, V>(transaction, this.map, this.mapId);
            m.setSavepoint(savepoint);
            return m;
        }

        public long sizeAsLongMax() {
            return this.map.sizeAsLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long sizeAsLong() {
            this.transaction.store.rwLock.readLock().lock();
            try {
                long undoLogSize;
                MVMap<Long, Object[]> undo;
                long sizeRaw = this.map.sizeAsLong();
                MVMap<Long, Object[]> mVMap = undo = this.transaction.store.undoLog;
                synchronized (mVMap) {
                    undoLogSize = undo.sizeAsLong();
                }
                if (undoLogSize == 0L) {
                    long l = sizeRaw;
                    return l;
                }
                if (undoLogSize > sizeRaw) {
                    long size = 0L;
                    Cursor<Object, VersionedValue> cursor = this.map.cursor(null);
                    while (cursor.hasNext()) {
                        K key = cursor.next();
                        VersionedValue data = this.map.get(key);
                        if ((data = this.getValue(key, this.readLogId, data)) == null || data.value == null) continue;
                        ++size;
                    }
                    long key = size;
                    return key;
                }
                mVMap = undo;
                synchronized (mVMap) {
                    long size = this.map.sizeAsLong();
                    MVMap<Object, Integer> temp = this.transaction.store.createTempMap();
                    try {
                        for (Map.Entry<Long, Object[]> e : undo.entrySet()) {
                            Integer old;
                            Object key;
                            Object[] op = e.getValue();
                            int m = (Integer)op[0];
                            if (m != this.mapId || this.get(key = op[1]) != null || (old = temp.put(key, 1)) != null) continue;
                            --size;
                        }
                    }
                    finally {
                        this.transaction.store.store.removeMap(temp);
                    }
                    long l = size;
                    return l;
                }
            }
            finally {
                this.transaction.store.rwLock.readLock().unlock();
            }
        }

        public V remove(K key) {
            return this.set(key, null);
        }

        public V put(K key, V value) {
            DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
            return this.set(key, value);
        }

        public V putCommitted(K key, V value) {
            DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
            VersionedValue newValue = new VersionedValue(0L, value);
            VersionedValue oldValue = this.map.put(key, newValue);
            return (V)(oldValue == null ? null : oldValue.value);
        }

        private V set(K key, V value) {
            this.transaction.checkNotClosed();
            V old = this.get(key);
            boolean ok = this.trySet(key, value, false);
            if (ok) {
                return old;
            }
            throw DataUtils.newIllegalStateException(101, "Entry is locked", new Object[0]);
        }

        public boolean tryRemove(K key) {
            return this.trySet(key, null, false);
        }

        public boolean tryPut(K key, V value) {
            DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
            return this.trySet(key, value, false);
        }

        public boolean trySet(K key, V value, boolean onlyIfUnchanged) {
            VersionedValue old;
            VersionedValue current = this.map.get(key);
            if (onlyIfUnchanged && !this.map.areValuesEqual(old = this.getValue(key, this.readLogId), current)) {
                long tx = TransactionStore.getTransactionId(current.operationId);
                if (tx == (long)this.transaction.transactionId) {
                    if (value == null) {
                        return true;
                    }
                    if (current.value != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            VersionedValue newValue = new VersionedValue(TransactionStore.getOperationId(this.transaction.transactionId, this.transaction.logId), value);
            if (current == null) {
                this.transaction.log(this.mapId, key, current);
                VersionedValue old2 = this.map.putIfAbsent(key, newValue);
                if (old2 != null) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            long id = current.operationId;
            if (id == 0L) {
                this.transaction.log(this.mapId, key, current);
                if (!this.map.replace(key, current, newValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            int tx = TransactionStore.getTransactionId(current.operationId);
            if (tx == this.transaction.transactionId) {
                this.transaction.log(this.mapId, key, current);
                if (!this.map.replace(key, current, newValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            return false;
        }

        public V get(K key) {
            return this.get(key, this.readLogId);
        }

        public V getLatest(K key) {
            return this.get(key, Long.MAX_VALUE);
        }

        public boolean containsKey(K key) {
            return this.get(key) != null;
        }

        public V get(K key, long maxLogId) {
            VersionedValue data = this.getValue(key, maxLogId);
            return (V)(data == null ? null : data.value);
        }

        public boolean isSameTransaction(K key) {
            VersionedValue data = this.map.get(key);
            if (data == null) {
                return false;
            }
            int tx = TransactionStore.getTransactionId(data.operationId);
            return tx == this.transaction.transactionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionedValue getValue(K key, long maxLog) {
            this.transaction.store.rwLock.readLock().lock();
            try {
                VersionedValue data = this.map.get(key);
                VersionedValue versionedValue = this.getValue(key, maxLog, data);
                return versionedValue;
            }
            finally {
                this.transaction.store.rwLock.readLock().unlock();
            }
        }

        VersionedValue getValue(K key, long maxLog, VersionedValue data) {
            while (data != null) {
                long id = data.operationId;
                if (id == 0L) {
                    return data;
                }
                int tx = TransactionStore.getTransactionId(id);
                if (tx == this.transaction.transactionId && TransactionStore.getLogId(id) < maxLog) {
                    return data;
                }
                Object[] d = this.transaction.store.undoLog.get(id);
                if (d == null) {
                    if (this.transaction.store.store.isReadOnly()) {
                        return null;
                    }
                    data = this.map.get(key);
                    continue;
                }
                data = (VersionedValue)d[2];
            }
            return null;
        }

        public boolean isClosed() {
            return this.map.isClosed();
        }

        public void clear() {
            this.map.clear();
        }

        public K firstKey() {
            Iterator<Object> it = this.keyIterator(null);
            return (K)(it.hasNext() ? it.next() : null);
        }

        public K lastKey() {
            K k = this.map.lastKey();
            while (k != null && this.get(k) == null) {
                k = this.map.lowerKey(k);
            }
            return k;
        }

        public K higherKey(K key) {
            while ((key = this.map.higherKey(key)) != null && this.get(key) == null) {
            }
            return key;
        }

        public K ceilingKey(K key) {
            Iterator<K> it = this.keyIterator(key);
            return it.hasNext() ? (K)it.next() : null;
        }

        public K relativeKey(K key, long offset) {
            K k;
            K k2 = k = offset > 0L ? this.map.ceilingKey(key) : this.map.floorKey(key);
            if (k == null) {
                return k;
            }
            long index = this.map.getKeyIndex(k);
            return this.map.getKey(index + offset);
        }

        public K floorKey(K key) {
            key = this.map.floorKey(key);
            while (key != null && this.get(key) == null) {
                key = this.map.lowerKey(key);
            }
            return key;
        }

        public K lowerKey(K key) {
            while ((key = this.map.lowerKey(key)) != null && this.get(key) == null) {
            }
            return key;
        }

        public Iterator<K> keyIterator(K from) {
            return this.keyIterator(from, false);
        }

        public Iterator<K> keyIterator(final K from, final boolean includeUncommitted) {
            return new Iterator<K>(){
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = from;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        Object k;
                        try {
                            k = this.cursor.next();
                        }
                        catch (IllegalStateException e) {
                            if (DataUtils.getErrorCode(e.getMessage()) == 9) {
                                this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                                if (!this.cursor.hasNext()) break;
                                this.cursor.next();
                                if (!this.cursor.hasNext()) break;
                                k = this.cursor.next();
                            }
                            throw e;
                        }
                        this.currentKey = k;
                        if (includeUncommitted) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(k)) continue;
                        return;
                    }
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.currentKey != null;
                }

                @Override
                public K next() {
                    Object result = this.currentKey;
                    this.fetchNext();
                    return result;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<Map.Entry<K, V>> entryIterator(final K from, final K to) {
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> current;
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = from;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        TransactionMap.this.transaction.store.rwLock.readLock().lock();
                        try {
                            k = this.cursor.next();
                            ** GOTO lbl17
                        }
                        catch (IllegalStateException e) {
                            if (DataUtils.getErrorCode(e.getMessage()) != 9) throw e;
                            this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                            if (!this.cursor.hasNext()) {
                                TransactionMap.this.transaction.store.rwLock.readLock().unlock();
                                break;
                            }
                            this.cursor.next();
                            if (!this.cursor.hasNext()) break;
                            k = this.cursor.next();
lbl17:
                            // 2 sources

                            key = k;
                            ** if (to != null && TransactionMap.this.map.getKeyType().compare(k, (Object)to) > 0) goto lbl-1000
                        }
lbl-1000:
                        // 1 sources

                        {
                            data = TransactionMap.this.map.get(key);
                            if ((data = TransactionMap.this.getValue(key, TransactionMap.this.readLogId, data)) == null || data.value == null) continue;
                            value = data.value;
                            this.current = new DataUtils.MapEntry<K, Object>(key, value);
                            this.currentKey = key;
                            return;
                        }
lbl-1000:
                        // 1 sources

                        {
                            break;
                        }
                    }
                    this.current = null;
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry result = this.current;
                    this.fetchNext();
                    return result;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<K> wrapIterator(final Iterator<K> iterator, final boolean includeUncommitted) {
            return new Iterator<K>(){
                private K current;
                {
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (iterator.hasNext()) {
                        this.current = iterator.next();
                        if (includeUncommitted) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(this.current)) continue;
                        return;
                    }
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public K next() {
                    Object result = this.current;
                    this.fetchNext();
                    return result;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public DataType getKeyType() {
            return this.map.getKeyType();
        }
    }

    public static class Transaction {
        public static final int STATUS_CLOSED = 0;
        public static final int STATUS_OPEN = 1;
        public static final int STATUS_PREPARED = 2;
        public static final int STATUS_COMMITTING = 3;
        final TransactionStore store;
        final int transactionId;
        long logId;
        private int status;
        private String name;

        Transaction(TransactionStore store, int transactionId, int status, String name, long logId) {
            this.store = store;
            this.transactionId = transactionId;
            this.status = status;
            this.name = name;
            this.logId = logId;
        }

        public int getId() {
            return this.transactionId;
        }

        public int getStatus() {
            return this.status;
        }

        void setStatus(int status) {
            this.status = status;
        }

        public void setName(String name) {
            this.checkNotClosed();
            this.name = name;
            this.store.storeTransaction(this);
        }

        public String getName() {
            return this.name;
        }

        public long setSavepoint() {
            return this.logId;
        }

        void log(int mapId, Object key, Object oldValue) {
            this.store.log(this, this.logId, mapId, key, oldValue);
            ++this.logId;
        }

        void logUndo() {
            this.store.logUndo(this, --this.logId);
        }

        public <K, V> TransactionMap<K, V> openMap(String name) {
            return this.openMap(name, null, null);
        }

        public <K, V> TransactionMap<K, V> openMap(String name, DataType keyType, DataType valueType) {
            this.checkNotClosed();
            MVMap map = this.store.openMap(name, keyType, valueType);
            int mapId = map.getId();
            return new TransactionMap(this, map, mapId);
        }

        public <K, V> TransactionMap<K, V> openMap(MVMap<K, VersionedValue> map) {
            this.checkNotClosed();
            int mapId = map.getId();
            return new TransactionMap(this, map, mapId);
        }

        public void prepare() {
            this.checkNotClosed();
            this.status = 2;
            this.store.storeTransaction(this);
        }

        public void commit() {
            this.checkNotClosed();
            this.store.commit(this, this.logId);
        }

        public void rollbackToSavepoint(long savepointId) {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, savepointId);
            this.logId = savepointId;
        }

        public void rollback() {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, 0L);
            this.store.endTransaction(this, this.status);
        }

        public Iterator<Change> getChanges(long savepointId) {
            return this.store.getChanges(this, this.logId, savepointId);
        }

        void checkNotClosed() {
            if (this.status == 0) {
                throw DataUtils.newIllegalStateException(4, "Transaction is closed", new Object[0]);
            }
        }

        public <K, V> void removeMap(TransactionMap<K, V> map) {
            this.store.removeMap(map);
        }

        public String toString() {
            return "" + this.transactionId;
        }
    }

    public static class Change {
        public String mapName;
        public Object key;
        public Object value;
    }
}

